/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u001b\taqI]1qQ&$\u0018\u0010V3ti*\u00111\u0001B\u0001\tG>|7NY8pW*\u0011QAB\u0001\u0007I>\u001cw-\u001a8\u000b\u0005\u001dA\u0011AB2za\",'O\u0003\u0002\n\u0015\u0005)a.Z85U*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0014\t>\u001cW/\\3oi&tw\rV3ti\n\u000b7/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAQ\u0001\u0007\u0001\u0005Re\t\u0001cZ3u\u000fJ\f\u0007\u000f\u001b<juN#\u0018\u0010\\3\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0011\u001d\u0014\u0018\r\u001d5wSjT!a\b\u0005\u0002\u001bYL7/^1mSj\fG/[8o\u0013\t\tCD\u0001\u0006He\u0006\u0004\bn\u0015;zY\u0016DQa\t\u0001\u0005B\u0011\n\u0001c\u001a:ba\"$Um]2sSB$\u0018n\u001c8\u0016\u0003\u0015\u00022AJ\u00170\u001b\u00059#B\u0001\u0015*\u0003%IW.\\;uC\ndWM\u0003\u0002+W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00031\nQa]2bY\u0006L!AL\u0014\u0003\t1K7\u000f\u001e\t\u0003aUj\u0011!\r\u0006\u0003eM\nA\u0001\\1oO*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005\u0019\u0019FO]5oO\")\u0001\b\u0001C\u0001s\u000591/Z2uS>tW#A\u0018\t\u000bm\u0002A\u0011\u0001\u001f\u0002'\u0019Lg\u000eZ!di&4\u0018\u000e^=TiJ,\u0017-\\:\u0015\u0003u\u0002\"AP \u000e\u0003-J!\u0001Q\u0016\u0003\tUs\u0017\u000e\u001e\u0015\u0003u\t\u0003\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0006\u0002\u000b),h.\u001b;\n\u0005\u001d#%\u0001\u0002+fgR\u0004")
public class GraphityTest
extends DocumentingTestBase {
    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Joe has Joe_s1", "Joe_s1 next Joe_s2", "Bill has Bill_s1", "Bill_s1 next Bill_s2", "Ted has Ted_s1", "Ted_s1 next Ted_s2", "Bob bob_knows Ted", "Bob has Bob_s1", "Ted bob_knows Bill", "Jane jane_knows Bill", "Bill jane_knows Joe", "Joe jane_knows Bob"}));
    }

    @Override
    public String section() {
        return "cookbook";
    }

    @Test
    public void findActivityStreams() {
        this.testQuery("Find Activity Streams in a network without scaling penalty", "This is an approach for scaling the retrieval of activity streams in a friend graph put forward by Rene Pickard as http://www.rene-pickhardt.de/graphity-an-efficient-graph-model-for-retrieving-the-top-k-news-feeds-for-users-in-social-networks/[Graphity].\nIn short, a linked list is created for every persons friends in the order that the last activities of these friends have occured.\nWhen new activities occur for a friend, all the ordered friend lists that this friend is part of are reordered, transferring computing load to the time of new event updates instead of activity stream reads.\n\n[TIP]\nThis approach of course makes excessive use of relationship types.\nThis needs to be taken into consideration when designing a production system with this approach.\nSee <<capabilities-capacity>> for the maximum number of relationship types.\n\nTo find the activity stream for a person, just follow the linked list of the friend list, and retrieve the needed amount of activities form the respective activity list of the friends.", "MATCH p=(me {name: 'Jane'})-[:jane_knows*]->(friend), (friend)-[:has]->(status) RETURN me.name, friend.name, status.name, length(p) ORDER BY length(p)", "The returns the activity stream for Jane.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"status.name"), (Object)"Bill_s1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"friend.name"), (Object)"Bill"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"me.name"), (Object)"Jane"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"length(p)"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"status.name"), (Object)"Joe_s1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"friend.name"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"me.name"), (Object)"Jane"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"length(p)"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"status.name"), (Object)"Bob_s1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"friend.name"), (Object)"Bob"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"me.name"), (Object)"Jane"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"length(p)"), (Object)BoxesRunTime.boxToInteger((int)3))}))})), (Object)p.toList());
            }
        }}));
    }
}

