/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u001b\tI\u0002*\u001f9fe\u0016$w-Z\"p[6|gn\u0012:pkB\u001cH+Z:u\u0015\t\u0019A!\u0001\u0005d_>\\'m\\8l\u0015\t)a!\u0001\u0004e_\u000e<WM\u001c\u0006\u0003\u000f!\taaY=qQ\u0016\u0014(BA\u0005\u000b\u0003\u0015qWm\u001c\u001bk\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0005\u0013\t\tBAA\nE_\u000e,X.\u001a8uS:<G+Z:u\u0005\u0006\u001cX\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!)\u0001\u0004\u0001C!3\u0005\u0001rM]1qQ\u0012+7o\u0019:jaRLwN\\\u000b\u00025A\u00191D\t\u0013\u000e\u0003qQ!!\b\u0010\u0002\u0013%lW.\u001e;bE2,'BA\u0010!\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\b\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!A.\u00198h\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\rM#(/\u001b8h\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u001d\u0019Xm\u0019;j_:,\u0012\u0001\n\u0005\u0006a\u0001!\t&M\u0001\u0011O\u0016$xI]1qQZL'p\u0015;zY\u0016,\u0012A\r\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n\u0001b\u001a:ba\"4\u0018N\u001f\u0006\u0003o!\tQB^5tk\u0006d\u0017N_1uS>t\u0017BA\u001d5\u0005)9%/\u00199i'RLH.\u001a\u0005\u0006w\u0001!\t\u0001P\u0001\u0011M&tGmQ8n[>twI]8vaN$\u0012!\u0010\t\u0003}}j\u0011\u0001I\u0005\u0003\u0001\u0002\u0012A!\u00168ji\"\u0012!H\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b*\tQA[;oSRL!a\u0012#\u0003\tQ+7\u000f\u001e")
public class HyperedgeCommonGroupsTest
extends DocumentingTestBase {
    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User1 hasRoleInGroup U1G1R12", "U1G1R12 hasGroup Group1", "U1G1R12 hasRole Role1", "U1G1R12 hasRole Role2", "User1 hasRoleInGroup U1G2R23", "U1G2R23 hasGroup Group2", "U1G2R23 hasRole Role2", "U1G2R23 hasRole Role3", "User1 hasRoleInGroup U1G3R34", "U1G3R34 hasGroup Group3", "U1G3R34 hasRole Role3", "U1G3R34 hasRole Role4", "User2 hasRoleInGroup U2G1R25", "U2G1R25 hasGroup Group1", "U2G1R25 hasRole Role2", "U2G1R25 hasRole Role5", "User2 hasRoleInGroup U2G2R34", "U2G2R34 hasGroup Group2", "U2G2R34 hasRole Role3", "U2G2R34 hasRole Role4", "User2 hasRoleInGroup U2G3R56", "U2G3R56 hasGroup Group3", "U2G3R56 hasRole Role5", "U2G3R56 hasRole Role6"}));
    }

    @Override
    public String section() {
        return "cookbook";
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Test
    public void findCommonGroups() {
        this.testQuery("Find common groups based on shared roles", "Assume a more complicated graph:\n\n1. Two user nodes +User1+, +User2+.\n2. +User1+ is in +Group1+, +Group2+, +Group3+.\n3. +User1+ has +Role1+, +Role2+ in +Group1+; +Role2+, +Role3+ in +Group2+; +Role3+, +Role4+ in +Group3+ (hyper edges).\n4. +User2+ is in +Group1+, +Group2+, +Group3+.\n5. +User2+ has +Role2+, +Role5+ in +Group1+; +Role3+, +Role4+ in +Group2+; +Role5+, +Role6+ in +Group3+ (hyper edges).\n\nThe graph for this looks like the following (nodes like +U1G2R23+ representing the HyperEdges):\n\n.Graph\ninclude::includes/cypher-hyperedgecommongroups-graph.asciidoc[]\n\nTo return +Group1+ and +Group2+ as +User1+ and +User2+ share at least one common role in these two groups, the query looks like this:\n               ", "match (u1)-[:hasRoleInGroup]->(hyperEdge1)-[:hasGroup]->(group), (hyperEdge1)-[:hasRole]->(role), (u2)-[:hasRoleInGroup]->(hyperEdge2)-[:hasGroup]->(group), (hyperEdge2)-[:hasRole]->(role) where u1.name = 'User1' and u2.name = 'User2' return group.name, count(role) order by group.name ASC", "The groups where +User1+ and +User2+ share at least one common role:", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"group.name"), (Object)"Group1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(role)"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"group.name"), (Object)"Group2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"count(role)"), (Object)BoxesRunTime.boxToInteger((int)1))}))})), (Object)p.toList());
            }
        }}));
    }
}

