/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u001b\ti\u0001*\u001f9fe\u0016$w-\u001a+fgRT!a\u0001\u0003\u0002\u0011\r|wn\u001b2p_.T!!\u0002\u0004\u0002\r\u0011|7mZ3o\u0015\t9\u0001\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u0013)\tQA\\3pi)T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\u0011I!!\u0005\u0003\u0003'\u0011{7-^7f]RLgn\u001a+fgR\u0014\u0015m]3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003J\u0012\u0001E4sCBDG)Z:de&\u0004H/[8o+\u0005Q\u0002cA\u000e#I5\tAD\u0003\u0002\u001e=\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003?\u0001\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012\u001d\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001\u00027b]\u001eT\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,M\t11\u000b\u001e:j]\u001eDQ!\f\u0001\u0005\u00029\nqa]3di&|g.F\u0001%\u0011\u0015\u0001\u0004\u0001\"\u00152\u0003A9W\r^$sCBDg/\u001b>TifdW-F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0005he\u0006\u0004\bN^5{\u0015\t9\u0004\"A\u0007wSN,\u0018\r\\5{CRLwN\\\u0005\u0003sQ\u0012!b\u0012:ba\"\u001cF/\u001f7f\u0011\u0015Y\u0004\u0001\"\u0001=\u0003)1\u0017N\u001c3He>,\bo\u001d\u000b\u0002{A\u0011ahP\u0007\u0002A%\u0011\u0001\t\t\u0002\u0005+:LG\u000f\u000b\u0002;\u0005B\u00111IR\u0007\u0002\t*\u0011QIC\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u000f\u0012\u0013A\u0001V3ti\")\u0011\n\u0001C\u0001y\u0005)b-\u001b8e\u00032dwI]8vaN4uN]!Vg\u0016\u0014\bF\u0001%C\u0001")
public class HyperedgeTest
extends DocumentingTestBase {
    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User1 in Group1", "User1 in Group2", "Group2 canHave Role2", "Group2 canHave Role1", "Group1 canHave Role1", "Group1 canHave Role2", "Group1 isA Group", "Group2 isA Group", "Role1 isA Role", "Role2 isA Role", "User1 hasRoleInGroup U1G2R1", "U1G2R1 hasRole Role1", "U1G2R1 hasGroup Group2", "User1 hasRoleInGroup U1G1R2", "U1G1R2 hasRole Role2", "U1G1R2 hasGroup Group1"}));
    }

    @Override
    public String section() {
        return "cookbook";
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Test
    public void findGroups() {
        this.testQuery("Find Groups", "To find out in what roles a user is for a particular groups (here\n        'Group2'), the following query can traverse this HyperEdge node and\n        provide answers.", "match ({name: 'User1'})-[:hasRoleInGroup]->(hyperEdge)-[:hasGroup]->({name: 'Group2'}), (hyperEdge)-[:hasRole]->(role) return role.name", "The role of +User1+ is returned:", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"role.name"), (Object)"Role1")})), (Object)p.toList().head());
            }
        }}));
    }

    @Test
    public void findAllGroupsForAUser() {
        this.testQuery("Find all groups and roles for a user", "Here, find all groups and the roles a user has, sorted by the name of the role.", "match ({name: 'User1'})-[:hasRoleInGroup]->(hyperEdge)-[:hasGroup]->(group), (hyperEdge)-[:hasRole]->(role) return role.name, group.name order by role.name asc", "The groups and roles of +User1+ are returned:", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                List result = p.toList();
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"role.name"), (Object)"Role1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"group.name"), (Object)"Group2")})), (Object)result.head());
                Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"role.name"), (Object)"Role2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"group.name"), (Object)"Group1")})), (Object)((IterableLike)result.tail()).head());
            }
        }}));
    }
}

