/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u001b\taa*Z<t\r\u0016,G\rV3ti*\u00111\u0001B\u0001\tG>|7NY8pW*\u0011QAB\u0001\u0007I>\u001cw-\u001a8\u000b\u0005\u001dA\u0011AB2za\",'O\u0003\u0002\n\u0015\u0005)a.Z85U*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0014\t>\u001cW/\\3oi&tw\rV3ti\n\u000b7/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAQ\u0001\u0007\u0001\u0005Re\t\u0001cZ3u\u000fJ\f\u0007\u000f\u001b<juN#\u0018\u0010\\3\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0011\u001d\u0014\u0018\r\u001d5wSjT!a\b\u0005\u0002\u001bYL7/^1mSj\fG/[8o\u0013\t\tCD\u0001\u0006He\u0006\u0004\bn\u0015;zY\u0016DQa\t\u0001\u0005\u0002\u0011\nqa]3di&|g.F\u0001&!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003mC:<'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u0012aa\u0015;sS:<\u0007b\u0002\u0018\u0001\u0005\u0004%\teL\u0001\b]>$\u0016\u000e\u001e7f+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$a\u0002\"p_2,\u0017M\u001c\u0005\u0007o\u0001\u0001\u000b\u0011\u0002\u0019\u0002\u00119|G+\u001b;mK\u0002Bq!\u000f\u0001C\u0002\u0013\u0005#(\u0001\u0007tKR,\b/U;fe&,7/F\u0001<!\ra\u0014)J\u0007\u0002{)\u0011ahP\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u0011\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C{\t!A*[:u\u0011\u0019!\u0005\u0001)A\u0005w\u0005i1/\u001a;vaF+XM]5fg\u0002BQA\u0012\u0001\u0005\u0002\u001d\u000ba\u0002^5nK2Lg.Z*fCJ\u001c\u0007\u000eF\u0001I!\t\t\u0014*\u0003\u0002Ke\t!QK\\5uQ\t)E\n\u0005\u0002N!6\taJ\u0003\u0002P\u0015\u0005)!.\u001e8ji&\u0011\u0011K\u0014\u0002\u0005)\u0016\u001cH\u000f")
public class NewsFeedTest
extends DocumentingTestBase {
    private final boolean noTitle;
    private final List<String> setupQueries = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\ncreate \n(bob{name:'Bob'})-[:STATUS]->(bob_s1{name:'bob_s1', text:'bobs status1',date:1})-[:NEXT]->(bob_s2{name:'bob_s2', text:'bobs status2',date:4}),\n(alice{name:'Alice'})-[:STATUS]->(alice_s1{name:'alice_s1', text:'Alices status1',date:2})-[:NEXT]->(alice_s2{name:'alice_s2', text:'Alices status2',date:5}),\n(joe{name:'Joe'})-[:STATUS]->(joe_s1{name:'joe_s1', text:'Joe status1',date:3})-[:NEXT]->(joe_s2{name:'joe_s2', text:'Joe status2',date:6}),\n(joe)-[:FRIEND{status:'CONFIRMED'}]->bob,\n(alice)-[:FRIEND{status:'PENDING'}]->joe,\n(bob)-[:FRIEND{status:'CONFIRMED'}]->alice\n"}));

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Override
    public String section() {
        return "cookbook";
    }

    @Override
    public boolean noTitle() {
        return this.noTitle;
    }

    @Override
    public List<String> setupQueries() {
        return this.setupQueries;
    }

    @Test
    public void timelineSearch() {
        this.testQuery("Retrieve the ordered timeline of status updates of all my friends", "\nImplementation of newsfeed or timeline feature is a frequent requirement for social applications.\nThe following exmaples are inspired by https://web.archive.org/web/20121102191919/http://techfin.in/2012/10/newsfeed-feature-powered-by-neo4j-graph-database/[Newsfeed feature powered by Neo4j Graph Database].\nThe query asked here is:\n\nStarting at `me`, retrieve the time-ordered status feed of the status updates of me and and all friends that are connected via a `CONFIRMED FRIEND` relationship to me.", "MATCH (me {name: 'Joe'})-[rels:FRIEND*0..1]-(myfriend)\nWHERE ALL(r in rels WHERE r.status = 'CONFIRMED')\nWITH myfriend\nMATCH (myfriend)-[:STATUS]-(latestupdate)-[:NEXT*0..1]-(statusupdates) \nRETURN myfriend.name as name, statusupdates.date as date, statusupdates.text as text\nORDER BY statusupdates.date DESC LIMIT 3", "\nTo understand the strategy, let's divide the query into five steps:\n\n. First Get the list of all my friends (along with me) through `FRIEND` relationship (`MATCH (me {name: 'Joe'})-[rels:FRIEND*0..1]-(myfriend)`). Also,  the `WHERE` predicate can be added to check whether the friend request is pending or confirmed.\n. Get the latest status update of my friends through Status relationship (`MATCH myfriend-[:STATUS]-latestupdate`).\n. Get subsequent status updates (along with the latest one) of my friends through `NEXT` relationships (`MATCH (myfriend)-[:STATUS]-(latestupdate)-[:NEXT*0..1]-(statusupdates)`) which will give you the latest and one additional statusupdate; adjust `0..1` to whatever suits your case.\n. Sort the status updates by posted date (`ORDER BY statusupdates.date DESC`).\n. `LIMIT` the number of updates you need in every query (`LIMIT 3`).", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"date"), (Object)BoxesRunTime.boxToInteger((int)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"text"), (Object)"Joe status2")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Bob"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"date"), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"text"), (Object)"bobs status2")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Joe"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"date"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"text"), (Object)"Joe status1")}))})), (Object)p.toList());
            }
        }}));
    }

    public NewsFeedTest() {
        this.noTitle = true;
    }
}

