/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u001b\ta\u0001+\u0019;i)J,W\rV3ti*\u00111\u0001B\u0001\tG>|7NY8pW*\u0011QAB\u0001\u0007I>\u001cw-\u001a8\u000b\u0005\u001dA\u0011AB2za\",'O\u0003\u0002\n\u0015\u0005)a.Z85U*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0014\t>\u001cW/\\3oi&tw\rV3ti\n\u000b7/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAQ\u0001\u0007\u0001\u0005Be\t\u0001c\u001a:ba\"$Um]2sSB$\u0018n\u001c8\u0016\u0003i\u00012a\u0007\u0012%\u001b\u0005a\"BA\u000f\u001f\u0003%IW.\\;uC\ndWM\u0003\u0002 A\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u000f\u0003\t1K7\u000f\u001e\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019\u0019FO]5oO\")Q\u0006\u0001C\u0001]\u000591/Z2uS>tW#\u0001\u0013\t\u000bA\u0002A\u0011A\u0019\u0002\u0013\u0005dG.\u0012<f]R\u001cH#\u0001\u001a\u0011\u0005M\"T\"\u0001\u0011\n\u0005U\u0002#\u0001B+oSRD#aL\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005iR\u0011!\u00026v]&$\u0018B\u0001\u001f:\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011A\u0019\u0002\u0015MLgn\u001a7f\t\u0006$X\r\u000b\u0002>o!)\u0011\t\u0001C\u0001c\u0005Q1\u000f[1sK\u0012\u0014vn\u001c;)\u0005\u0001;\u0004")
public class PathTreeTest
extends DocumentingTestBase {
    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Root 2010 Y10", "Root 2011 Y11", "Y10 12 Y10M12", "Y11 01 Y11M01", "Y10M12 31 Y10M12D31", "Y11M01 01 Y11M01D01", "Y11M01 02 Y11M11D02", "Y11M01 03 Y11M12D03", "Y10M12D31 NEXT Y11M01D01", "Y11M01D01 NEXT Y11M11D02", "Y11M11D02 NEXT Y11M12D03", "Y10M12D31 VALUE Event1", "Y10M12D31 VALUE Event2", "Y11M01D01 VALUE Event2", "Y11M12D03 VALUE Event3"}));
    }

    @Override
    public String section() {
        return "cookbook";
    }

    @Test
    public void allEvents() {
        this.testQuery("Return the full range", "In this case, the range goes from the first to the last leaf of the index tree. Here, \n+startPath+ (color +Greenyellow+) and +endPath+  (color +Green+) span up the range, +valuePath+  (color +Blue+) is then connecting the leafs, and the values can\nbe read from the +middle+ node, hanging off the +values+ (color +Red+) path.\n\n.Graph\ninclude::includes/path-tree-layout-full-range.asciidoc[]\n\n", "MATCH startPath=(root)-[:`2010`]->()-[:`12`]->()-[:`31`]->(startLeaf), endPath=(root)-[:`2011`]->()-[:`01`]->()-[:`03`]->(endLeaf), valuePath=(startLeaf)-[:NEXT*0..]->(middle)-[:NEXT*0..]->(endLeaf), vals=(middle)-[:VALUE]->(event) WHERE root.name = 'Root'RETURN event.name ORDER BY event.name ASC", "Returning all events between 2010-12-31 and 2011-01-03, in this case all events.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"event.name"), (Object)"Event1")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"event.name"), (Object)"Event2")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"event.name"), (Object)"Event2")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"event.name"), (Object)"Event3")}))})), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void singleDate() {
        this.testQuery("Return zero range", "Here, only the events indexed under one leaf (2010-12-31) are returned.\nThe query only needs one path segment +rootPath+  (color +Green+) through the index.\n\n.Graph\ninclude::includes/path-tree-layout-zero-range.asciidoc[]\n\n", "MATCH rootPath=(root)-[:`2010`]->()-[:`12`]->()-[:`31`]->(leaf), (leaf)-[:VALUE]->(event) WHERE root.name = 'Root'RETURN event.name ORDER BY event.name ASC", "Returning all events on the date 2010-12-31, in this case +Event1+ and +Event2+", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"event.name"), (Object)"Event1")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"event.name"), (Object)"Event2")}))})), (Object)p.toList());
            }
        }}));
    }

    @Test
    public void sharedRoot() {
        this.testQuery("Return partly shared path ranges", "Here, the query range results in partly shared paths when querying the index,\nmaking the introduction of and common path segment +commonPath+ (color +Black+) necessary, before spanning up +startPath+ (color +Greenyellow+) and \n+endPath+ (color +Darkgreen+) . After that, +valuePath+ (color +Blue+) connects the leafs and the indexed values are returned off +values+ (color +Red+)  path.\n\n.Graph\ninclude::includes/path-tree-layout-shared-root-path.asciidoc[]\n\n", "MATCH commonPath=(root)-[:`2011`]->()-[:`01`]->(commonRootEnd), startPath=(commonRootEnd)-[:`01`]->(startLeaf), endPath=(commonRootEnd)-[:`03`]->(endLeaf), valuePath=(startLeaf)-[:NEXT*0..]->(middle)-[:NEXT*0..]->(endLeaf), vals=(middle)-[:VALUE]->(event) WHERE root.name = 'Root'RETURN event.name ORDER BY event.name ASC", "Returning all events between 2011-01-01 and 2011-01-03, in this case +Event2+ and +Event3+.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"event.name"), (Object)"Event2")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"event.name"), (Object)"Event3")}))})), (Object)p.toList());
            }
        }}));
    }
}

