/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.docgen.cookbook;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.docgen.DocumentingTestBase;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u001b\tA\u0002+Z8qY\u0016\u001c\u0016.\\5mCJLG/\u001f+bON$Vm\u001d;\u000b\u0005\r!\u0011\u0001C2p_.\u0014wn\\6\u000b\u0005\u00151\u0011A\u00023pG\u001e,gN\u0003\u0002\b\u0011\u000511-\u001f9iKJT!!\u0003\u0006\u0002\u000b9,w\u000e\u000e6\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0003\n\u0005E!!a\u0005#pGVlWM\u001c;j]\u001e$Vm\u001d;CCN,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u0015A\u0002\u0001\"\u0011\u001a\u0003A9'/\u00199i\t\u0016\u001c8M]5qi&|g.F\u0001\u001b!\rY\"\u0005J\u0007\u00029)\u0011QDH\u0001\nS6lW\u000f^1cY\u0016T!a\b\u0011\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019CD\u0001\u0003MSN$\bCA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011a\u0017M\\4\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\u0007'R\u0014\u0018N\\4\t\u000b5\u0002A\u0011\u0001\u0018\u0002\u000fM,7\r^5p]V\tA\u0005C\u00041\u0001\t\u0007I\u0011I\u0019\u0002\u000f9|G+\u001b;mKV\t!\u0007\u0005\u00024i5\t\u0001%\u0003\u00026A\t9!i\\8mK\u0006t\u0007BB\u001c\u0001A\u0003%!'\u0001\u0005o_RKG\u000f\\3!\u0011\u0015I\u0004\u0001\"\u0015;\u0003A9W\r^$sCBDg/\u001b>TifdW-F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0005he\u0006\u0004\bN^5{\u0015\t\u0001\u0005\"A\u0007wSN,\u0018\r\\5{CRLwN\\\u0005\u0003\u0005v\u0012!b\u0012:ba\"\u001cF/\u001f7f\u0011\u0015!\u0005\u0001\"\u0001F\u0003Q\u0001Xm\u001c9mKNKW.\u001b7be&$\u0018\u0010V1hgR\ta\t\u0005\u00024\u000f&\u0011\u0001\n\t\u0002\u0005+:LG\u000f\u000b\u0002D\u0015B\u00111JT\u0007\u0002\u0019*\u0011QJC\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u001f2\u0013A\u0001V3ti\u0002")
public class PeopleSimilarityTagsTest
extends DocumentingTestBase {
    private final boolean noTitle;

    @Override
    public List<String> graphDescription() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Joe favorite Cats", "Joe favorite Horses", "Joe favorite Bikes", "Joe favorite Surfing", "Cats tagged Animals", "Horses tagged Animals", "Surfing tagged Hobby", "Bikes tagged Hobby", "Derrick favorite Bikes", "Sara favorite Bikes", "Sara favorite Horses"}));
    }

    @Override
    public String section() {
        return "cookbook";
    }

    @Override
    public boolean noTitle() {
        return this.noTitle;
    }

    @Override
    public GraphStyle getGraphvizStyle() {
        return AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors();
    }

    @Test
    public void peopleSimilarityTags() {
        this.testQuery("Find people based on similar tagged favorties", "To find people similar to me based on the taggings of their favorited items, one approach could be:\n\n* Determine the tags associated with what I favorite.\n* What else is tagged with those tags?\n* Who favorites items tagged with the same tags?\n* Sort the result by how many of the same things these people like.\n\n", "MATCH (me)-[:favorite]->(myFavorites)-[:tagged]->(tag)<-[:tagged]-(theirFavorites)<-[:favorite]-(people) WHERE me.name = 'Joe' AND NOT me=people RETURN people.name as name, count(*) as similar_favs ORDER BY similar_favs DESC", "The query returns the list of possible friends ranked by them liking similar stuff that are not yet friends.", (Seq<Function1<ExecutionResult, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutionResult p) {
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Sara"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"similar_favs"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)"Derrick"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"similar_favs"), (Object)BoxesRunTime.boxToInteger((int)1))}))})), (Object)p.toList());
            }
        }}));
    }

    public PeopleSimilarityTagsTest() {
        this.noTitle = true;
    }
}

