/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.example;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.AsciiDocGenerator;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.JavaTestDocsGenerator;
import org.neo4j.test.TestData;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class IntroDocTest
implements GraphHolder {
    private static final String DOCS_TARGET = "target/docs/dev/general/";
    @Rule
    public TestData<JavaTestDocsGenerator> gen = TestData.producedThrough((TestData.Producer)JavaTestDocsGenerator.PRODUCER);
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this, (boolean)true));
    private static ImpermanentGraphDatabase graphdb;
    private static ExecutionEngine engine;

    @Test
    @GraphDescription.Graph(value={"John friend Sara", "John friend Joe", "Sara friend Maria", "Joe friend Steve"}, autoIndexNodes=true)
    public void intro_examples() throws Exception {
        try (Transaction ignored = graphdb.beginTx();){
            Writer fw = AsciiDocGenerator.getFW((String)DOCS_TARGET, (String)((JavaTestDocsGenerator)this.gen.get()).getTitle());
            this.data.get();
            fw.append("\nImagine an example graph like the following one:\n\n");
            fw.append(AsciiDocGenerator.dumpToSeparateFileWithType((File)new File(DOCS_TARGET), (String)"intro.graph", (String)AsciidocHelper.createGraphVizWithNodeId((String)"Example Graph", (GraphDatabaseService)this.graphdb(), (String)"cypher-intro")));
            fw.append("\nFor example, here is a query which finds a user called John and John's friends (though not his direct friends) before returning both John and any friends-of-friends that are found.");
            fw.append("\n\n");
            String query = "MATCH (john {name: 'John'})-[:friend]->()-[:friend]->(fof) RETURN john, fof ";
            fw.append(AsciiDocGenerator.dumpToSeparateFileWithType((File)new File(DOCS_TARGET), (String)"intro.query", (String)AsciidocHelper.createCypherSnippet((String)query)));
            fw.append("\nResulting in:\n\n");
            fw.append(AsciiDocGenerator.dumpToSeparateFileWithType((File)new File(DOCS_TARGET), (String)"intro.result", (String)AsciidocHelper.createQueryResultSnippet((String)engine.execute(query).dumpToString())));
            fw.append("\nNext up we will add filtering to set more parts in motion:\n\nWe take a list of user names and find all nodes with names from this list, match their friends and return only those followed users who have a +name+ property starting with +S+.");
            query = "MATCH (user)-[:friend]->(follower) WHERE user.name IN ['Joe', 'John', 'Sara', 'Maria', 'Steve'] AND follower.name =~ 'S.*' RETURN user, follower.name ";
            fw.append("\n\n");
            fw.append(AsciiDocGenerator.dumpToSeparateFileWithType((File)new File(DOCS_TARGET), (String)"intro.query", (String)AsciidocHelper.createCypherSnippet((String)query)));
            fw.append("\nResulting in:\n\n");
            fw.append(AsciiDocGenerator.dumpToSeparateFileWithType((File)new File(DOCS_TARGET), (String)"intro.result", (String)AsciidocHelper.createQueryResultSnippet((String)engine.execute(query).dumpToString())));
            fw.close();
        }
    }

    @BeforeClass
    public static void setup() throws IOException {
        graphdb = (ImpermanentGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabase();
        graphdb.cleanContent();
        engine = new ExecutionEngine((GraphDatabaseService)graphdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void shutdown() {
        try {
            if (graphdb != null) {
                graphdb.shutdown();
            }
        }
        finally {
            graphdb = null;
        }
    }

    public GraphDatabaseService graphdb() {
        return graphdb;
    }
}

