/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.example;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.FileUtils;

public class JavaQuery {
    private static final String DB_PATH = "target/java-query-db";
    String resultString;
    String columnsString;
    String nodeResult;
    String rows = "";

    public static void main(String[] args) {
        JavaQuery javaQuery = new JavaQuery();
        javaQuery.run();
    }

    void run() {
        ExecutionResult result;
        this.clearDbPath();
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(DB_PATH);
        try (Transaction tx = db.beginTx();){
            Node myNode = db.createNode();
            myNode.setProperty("name", (Object)"my node");
            tx.success();
        }
        ExecutionEngine engine = new ExecutionEngine(db);
        try (Transaction ignored = db.beginTx();){
            result = engine.execute("match (n {name: 'my node'}) return n, n.name");
            ResourceIterator n_column = result.columnAs("n");
            for (Node node2 : IteratorUtil.asIterable((Iterator)n_column)) {
                this.nodeResult = node2 + ": " + node2.getProperty("name");
            }
        }
        List columns = result.columns();
        result = engine.execute("match (n {name: 'my node'}) return n, n.name");
        for (Map row : result) {
            for (Map.Entry entry : row.entrySet()) {
                this.rows = this.rows + (String)entry.getKey() + ": " + entry.getValue() + "; ";
            }
            this.rows = this.rows + "\n";
        }
        this.resultString = engine.execute("match (n {name: 'my node'}) return n, n.name").dumpToString();
        this.columnsString = columns.toString();
        db.shutdown();
    }

    private void clearDbPath() {
        try {
            FileUtils.deleteRecursively((File)new File(DB_PATH));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

