/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.codegen.core.Configuration;
import org.neo4j.cypherdsl.codegen.core.FieldNameGenerator;
import org.neo4j.cypherdsl.codegen.core.ModelBuilder;
import org.neo4j.cypherdsl.codegen.core.NodeImplBuilder;
import org.neo4j.cypherdsl.codegen.core.PropertyDefinition;
import org.neo4j.cypherdsl.codegen.core.RelationshipImplBuilder;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeBase;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.SymbolicName;

@API(status=API.Status.INTERNAL, since="2021.1.0")
abstract class AbstractModelBuilder<T extends ModelBuilder<?>>
implements ModelBuilder<T> {
    protected static final ClassName TYPE_NAME_NODE = ClassName.get(Node.class);
    protected static final ClassName TYPE_NAME_NODE_BASE = ClassName.get(NodeBase.class);
    protected static final ClassName TYPE_NAME_SYMBOLIC_NAME = ClassName.get(SymbolicName.class);
    protected static final ClassName TYPE_NAME_LIST = ClassName.get(List.class);
    protected static final ClassName TYPE_NAME_STRING = ClassName.get(String.class);
    protected static final ClassName TYPE_NAME_MAP_EXPRESSION = ClassName.get(MapExpression.class);
    private volatile JavaFile javaFile;
    protected final FieldNameGenerator fieldNameGenerator;
    protected final ClassName className;
    protected final String plainClassName;
    protected final Set<PropertyDefinition> properties = new LinkedHashSet<PropertyDefinition>();
    private final Configuration.JavaVersion target;
    private final String indent;
    private Clock clock = Clock.systemDefaultZone();
    private boolean addAtGenerated = true;

    AbstractModelBuilder(FieldNameGenerator fieldNameGenerator, ClassName className, String plainClassName, Configuration.JavaVersion target, String indent) {
        this.fieldNameGenerator = fieldNameGenerator;
        this.className = className;
        this.plainClassName = plainClassName;
        this.target = target;
        this.indent = indent;
    }

    protected abstract JavaFile buildJavaFile();

    @Override
    public final T addProperty(String newProperty) {
        return this.addProperty(PropertyDefinition.create(newProperty, newProperty));
    }

    @Override
    public final T addProperty(PropertyDefinition newProperty) {
        return this.addProperties(Collections.singleton(newProperty));
    }

    @Override
    public final T addProperties(Collection<PropertyDefinition> newProperties) {
        return (T)this.callOnlyWithoutJavaFilePresent(() -> {
            this.properties.addAll(newProperties);
            return this;
        });
    }

    @Override
    public final String getPackageName() {
        return this.className.packageName();
    }

    @Override
    public final String getCanonicalClassName() {
        return this.className.canonicalName();
    }

    @Override
    public final String getPlainClassName() {
        return this.plainClassName;
    }

    @Override
    public final void writeTo(Path path) {
        try {
            this.getJavaFile().writeTo(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final void writeTo(Appendable appendable) {
        try {
            this.getJavaFile().writeTo(appendable);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final String writeToString() {
        try {
            StringBuilder out = new StringBuilder();
            this.getJavaFile().writeTo((Appendable)out);
            return out.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final String getFieldName() {
        return this.fieldNameGenerator.generate(this.getPlainClassName());
    }

    final T apply(Configuration configuration) {
        configuration.getClock().ifPresent(c -> {
            this.clock = c;
        });
        this.addAtGenerated = configuration.isAddAtGenerated();
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <V> V callOnlyWithoutJavaFilePresent(Supplier<V> c) {
        AbstractModelBuilder abstractModelBuilder = this;
        synchronized (abstractModelBuilder) {
            if (this.javaFile == null) {
                return c.get();
            }
        }
        throw new IllegalStateException("Class has already been generated, cannot add properties.");
    }

    final TypeSpec.Builder addGenerated(TypeSpec.Builder builder) {
        Object nameOfAtGenerated = this.target == Configuration.JavaVersion.RELEASE_8 ? ClassName.get((String)"javax.annotation", (String)"Generated", (String[])new String[0]) : (this.target == Configuration.JavaVersion.RELEASE_11 && this.addAtGenerated ? ClassName.get((String)"javax.annotation.processing", (String)"Generated", (String[])new String[0]) : null);
        String comment = "This class is generated by the Neo4j Cypher-DSL. All changes to it will be lost after regeneration.";
        if (nameOfAtGenerated == null) {
            builder.addJavadoc(CodeBlock.of((String)comment, (Object[])new Object[0]));
        } else {
            AnnotationSpec spec = AnnotationSpec.builder((ClassName)nameOfAtGenerated).addMember("value", "$S", new Object[]{this.getClass().getName()}).addMember("date", "$S", new Object[]{ZonedDateTime.now(this.clock).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)}).addMember("comments", "$S", new Object[]{comment}).build();
            builder.addAnnotation(spec);
        }
        return builder;
    }

    final Stream<FieldSpec> generateFieldSpecsFromProperties() {
        return this.properties.stream().map(p -> {
            CodeBlock initializer;
            String fieldName;
            if (p.getNameInDomain() == null) {
                fieldName = p.getNameInGraph();
                initializer = CodeBlock.of((String)"this.property($S)", (Object[])new Object[]{p.getNameInGraph()});
            } else {
                fieldName = p.getNameInDomain();
                initializer = CodeBlock.of((String)"this.property($S).referencedAs($S)", (Object[])new Object[]{p.getNameInGraph(), p.getNameInDomain()});
            }
            return FieldSpec.builder(Property.class, (String)this.fieldNameGenerator.generate(fieldName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).initializer(initializer).build();
        });
    }

    final JavaFile.Builder prepareFileBuilder(TypeSpec typeSpec) {
        return JavaFile.builder((String)this.getPackageName(), (TypeSpec)typeSpec).skipJavaLangImports(true).indent(this.indent);
    }

    final ClassName getClassName() {
        return this.className;
    }

    static final ClassName extractClassName(ModelBuilder<?> optionalSource) {
        if (optionalSource == null) {
            return null;
        }
        if (optionalSource instanceof NodeImplBuilder) {
            return ((NodeImplBuilder)optionalSource).getClassName();
        }
        if (optionalSource instanceof RelationshipImplBuilder) {
            return ((RelationshipImplBuilder)optionalSource).getClassName();
        }
        return ClassName.bestGuess((String)optionalSource.getCanonicalClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaFile getJavaFile() {
        JavaFile result = this.javaFile;
        if (result == null) {
            AbstractModelBuilder abstractModelBuilder = this;
            synchronized (abstractModelBuilder) {
                result = this.javaFile;
                if (result == null) {
                    result = this.javaFile = this.buildJavaFile();
                }
            }
        }
        return result;
    }
}

