/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.codegen.core.AbstractModelBuilder;
import org.neo4j.cypherdsl.codegen.core.Configuration;
import org.neo4j.cypherdsl.codegen.core.NodeModelBuilder;
import org.neo4j.cypherdsl.codegen.core.RelationshipModelBuilder;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.RelationshipBase;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class RelationshipImplBuilder
extends AbstractModelBuilder<RelationshipModelBuilder>
implements RelationshipModelBuilder {
    private static final ClassName TYPE_NAME_RELATIONSHIP_BASE = ClassName.get(RelationshipBase.class);
    private static final TypeVariableName S = TypeVariableName.get((String)"S", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)TYPE_NAME_NODE_BASE, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})});
    private static final TypeVariableName E = TypeVariableName.get((String)"E", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)TYPE_NAME_NODE_BASE, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})});
    private final FieldSpec relationshipTypeField;
    private TypeName parameterizedTypeName;
    private TypeName startNode = S;
    private TypeName endNode = E;

    static RelationshipModelBuilder create(Configuration configuration, String packageName, String relationshipType, String alternateClassNameSuggestion) {
        String className = configuration.getRelationshipNameGenerator().generate(alternateClassNameSuggestion != null ? alternateClassNameSuggestion : relationshipType);
        String usedPackageName = packageName == null ? configuration.getDefaultPackage() : packageName;
        RelationshipImplBuilder builder = new RelationshipImplBuilder(configuration, relationshipType, ClassName.get((String)usedPackageName, (String)((String)configuration.getTypeNameDecorator().apply(className)), (String[])new String[0]), className);
        return (RelationshipModelBuilder)builder.apply(configuration);
    }

    private RelationshipImplBuilder(Configuration configuration, String relationshipType, ClassName className, String fieldName) {
        super(configuration.getConstantFieldNameGenerator(), className, fieldName, configuration.getTarget(), configuration.getIndent());
        if (relationshipType == null) {
            throw new IllegalStateException("Cannot build a RelationshipImpl without a single relationship type!");
        }
        this.relationshipTypeField = FieldSpec.builder(String.class, (String)configuration.getConstantFieldNameGenerator().generate("$TYPE"), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{relationshipType}).build();
        this.parameterizedTypeName = className;
    }

    @Override
    public RelationshipModelBuilder setStartNode(NodeModelBuilder newStartNode) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            this.startNode = RelationshipImplBuilder.extractClassName(newStartNode);
            return this;
        });
    }

    @Override
    public RelationshipModelBuilder setEndNode(NodeModelBuilder newEndNode) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            this.endNode = RelationshipImplBuilder.extractClassName(newEndNode);
            return this;
        });
    }

    private MethodSpec buildDefaultConstructor() {
        ParameterSpec startNodeParam = ParameterSpec.builder((TypeName)this.startNode, (String)"start", (Modifier[])new Modifier[0]).build();
        ParameterSpec endNodeParam = ParameterSpec.builder((TypeName)this.endNode, (String)"end", (Modifier[])new Modifier[0]).build();
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(startNodeParam).addParameter(endNodeParam).addStatement("super($N, $N, $N)", new Object[]{startNodeParam, this.relationshipTypeField, endNodeParam}).build();
    }

    private MethodSpec buildCopyConstructor() {
        ParameterSpec symbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"symbolicName", (Modifier[])new Modifier[0]).build();
        ParameterSpec start = ParameterSpec.builder((TypeName)TYPE_NAME_NODE, (String)"start", (Modifier[])new Modifier[0]).build();
        ParameterSpec properties = ParameterSpec.builder((TypeName)ClassName.get(Properties.class), (String)"properties", (Modifier[])new Modifier[0]).build();
        ParameterSpec end = ParameterSpec.builder((TypeName)TYPE_NAME_NODE, (String)"end", (Modifier[])new Modifier[0]).build();
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameters(Arrays.asList(symbolicName, start, properties, end)).addStatement("super($N, $N, $N, $N, $N)", new Object[]{symbolicName, start, this.relationshipTypeField, properties, end}).build();
    }

    private MethodSpec buildNamedMethod() {
        ParameterSpec newSymbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"newSymbolicName", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"named").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedTypeName).addParameter(newSymbolicName).addStatement("return new $T$L($N, getLeft(), getDetails().getProperties(), getRight())", new Object[]{this.className, this.parameterizedTypeName == this.className ? "" : "<>", newSymbolicName}).build();
    }

    private MethodSpec buildWithPropertiesMethod() {
        ParameterSpec newProperties = ParameterSpec.builder((TypeName)TYPE_NAME_MAP_EXPRESSION, (String)"newProperties", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"withProperties").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.parameterizedTypeName).addParameter(newProperties).addStatement("return new $T$L(getSymbolicName().orElse(null), getLeft(), Properties.create($N), getRight())", new Object[]{this.className, this.parameterizedTypeName == this.className ? "" : "<>", newProperties}).build();
    }

    private List<FieldSpec> buildFields() {
        return Stream.concat(Stream.of(this.relationshipTypeField), this.generateFieldSpecsFromProperties()).collect(Collectors.toList());
    }

    @Override
    protected JavaFile buildJavaFile() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className);
        if (this.startNode == S && this.endNode == E) {
            this.parameterizedTypeName = ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{S, E});
            builder.addTypeVariable(S);
            builder.addTypeVariable(E);
        } else if (this.startNode == S) {
            this.parameterizedTypeName = ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{S});
            builder.addTypeVariable(S);
        } else if (this.endNode == E) {
            this.parameterizedTypeName = ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{E});
            builder.addTypeVariable(E);
        } else {
            this.parameterizedTypeName = this.className;
        }
        TypeSpec newType = this.addGenerated(builder).superclass((TypeName)ParameterizedTypeName.get((ClassName)TYPE_NAME_RELATIONSHIP_BASE, (TypeName[])new TypeName[]{this.startNode, this.endNode, this.parameterizedTypeName})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(this.buildFields()).addMethod(this.buildDefaultConstructor()).addMethod(this.buildCopyConstructor()).addMethod(this.buildNamedMethod()).addMethod(this.buildWithPropertiesMethod()).build();
        return this.prepareFileBuilder(newType).build();
    }
}

