/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.codegen.core.NodeModelBuilder;
import org.neo4j.cypherdsl.codegen.core.PropertyDefinition;
import org.neo4j.cypherdsl.codegen.core.RelationshipModelBuilder;

@API(status=API.Status.EXPERIMENTAL, since="2021.1.0")
public final class RelationshipPropertyDefinition {
    private final String type;
    private final String optionalPropertyHolder;
    private final String nameInDomain;
    private final NodeModelBuilder start;
    private final NodeModelBuilder end;
    private RelationshipModelBuilder relationshipBuilder;
    protected final Set<PropertyDefinition> properties;

    public static RelationshipPropertyDefinition create(String type, String optionalPropertyHolder, String nameInDomain, NodeModelBuilder start, NodeModelBuilder end, Collection<PropertyDefinition> optionalProperties) {
        return new RelationshipPropertyDefinition(type, optionalPropertyHolder, nameInDomain, start, null, end, (Set<PropertyDefinition>)(optionalProperties == null ? Collections.emptySet() : new HashSet<PropertyDefinition>(optionalProperties)));
    }

    private RelationshipPropertyDefinition(String type, String optionalPropertyHolder, String nameInDomain, NodeModelBuilder start, RelationshipModelBuilder relationshipBuilder, NodeModelBuilder end, Set<PropertyDefinition> properties) {
        this.type = type;
        this.optionalPropertyHolder = optionalPropertyHolder;
        this.nameInDomain = nameInDomain;
        this.start = start;
        this.end = end;
        this.relationshipBuilder = relationshipBuilder;
        this.properties = properties;
    }

    public RelationshipPropertyDefinition withBuilder(RelationshipModelBuilder newBuilder) {
        return new RelationshipPropertyDefinition(this.type, this.optionalPropertyHolder, this.nameInDomain, this.start, newBuilder, this.end, this.properties);
    }

    public String getType() {
        return this.type;
    }

    public String getNameInDomain() {
        return this.nameInDomain;
    }

    public NodeModelBuilder getStart() {
        return this.start;
    }

    public NodeModelBuilder getEnd() {
        return this.end;
    }

    RelationshipModelBuilder getRelationshipBuilder() {
        return this.relationshipBuilder;
    }

    public Set<PropertyDefinition> getProperties() {
        return Collections.unmodifiableSet(this.properties);
    }
}

