/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import java.nio.file.Path;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.codegen.core.ClassNameGenerator;
import org.neo4j.cypherdsl.codegen.core.FieldNameGenerator;
import org.neo4j.cypherdsl.codegen.core.NodeNameGenerator;
import org.neo4j.cypherdsl.codegen.core.RelationshipNameGenerator;

@API(status=API.Status.EXPERIMENTAL, since="2021.1.0")
public final class Configuration {
    private static final Configuration DEFAULT_CONFIG = Configuration.newConfig().build();
    public static final String PROPERTY_PREFIX = "org.neo4j.cypherdsl.codegen.prefix";
    public static final String PROPERTY_SUFFIX = "org.neo4j.cypherdsl.codegen.suffix";
    public static final String PROPERTY_INDENT_STYLE = "org.neo4j.cypherdsl.codegen.indent_style";
    public static final String PROPERTY_INDENT_SIZE = "org.neo4j.cypherdsl.codegen.indent_size";
    public static final String PROPERTY_TIMESTAMP = "org.neo4j.cypherdsl.codegen.timestamp";
    public static final String PROPERTY_ADD_AT_GENERATED = "org.neo4j.cypherdsl.codegen.add_at_generated";
    private final UnaryOperator<String> typeNameDecorator;
    private final ClassNameGenerator nodeNameGenerator;
    private final ClassNameGenerator relationshipNameGenerator;
    private final FieldNameGenerator fieldNameGenerator;
    private final JavaVersion target;
    private final String defaultPackage;
    private final Optional<Path> path;
    private final String indent;
    private final Optional<Clock> clock;
    private final boolean addAtGenerated;

    public static Configuration defaultConfig() {
        return DEFAULT_CONFIG;
    }

    public static Builder newConfig() {
        return Builder.newConfig();
    }

    public static Builder newConfig(Path path) {
        return Builder.newConfig(path);
    }

    private Configuration(UnaryOperator<String> typeNameDecorator, ClassNameGenerator nodeNameGenerator, ClassNameGenerator relationshipNameGenerator, FieldNameGenerator fieldNameGenerator, JavaVersion target, String defaultPackage, Path path, String indent, Clock clock, boolean addAtGenerated) {
        this.typeNameDecorator = typeNameDecorator;
        this.nodeNameGenerator = nodeNameGenerator;
        this.relationshipNameGenerator = relationshipNameGenerator;
        this.fieldNameGenerator = fieldNameGenerator;
        this.target = target;
        this.defaultPackage = defaultPackage;
        this.path = Optional.ofNullable(path);
        this.indent = indent;
        this.clock = Optional.ofNullable(clock);
        this.addAtGenerated = addAtGenerated;
    }

    public ClassNameGenerator getNodeNameGenerator() {
        return this.nodeNameGenerator;
    }

    public ClassNameGenerator getRelationshipNameGenerator() {
        return this.relationshipNameGenerator;
    }

    public FieldNameGenerator getConstantFieldNameGenerator() {
        return this.fieldNameGenerator;
    }

    public JavaVersion getTarget() {
        return this.target;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public Optional<Path> getPath() {
        return this.path;
    }

    public UnaryOperator<String> getTypeNameDecorator() {
        return this.typeNameDecorator;
    }

    public String getIndent() {
        return this.indent;
    }

    public Optional<Clock> getClock() {
        return this.clock;
    }

    public boolean isAddAtGenerated() {
        return this.addAtGenerated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.typeNameDecorator.equals(that.typeNameDecorator) && this.nodeNameGenerator.equals(that.nodeNameGenerator) && this.relationshipNameGenerator.equals(that.relationshipNameGenerator) && this.fieldNameGenerator.equals(that.fieldNameGenerator) && this.target == that.target && this.defaultPackage.equals(that.defaultPackage) && this.path.equals(that.path) && this.indent.equals(that.indent) && this.clock.equals(that.clock) && this.addAtGenerated == that.addAtGenerated;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeNameDecorator, this.nodeNameGenerator, this.relationshipNameGenerator, this.fieldNameGenerator, this.target, this.defaultPackage, this.path, this.indent, this.clock, this.addAtGenerated});
    }

    public static enum JavaVersion {
        RELEASE_8,
        RELEASE_11;

    }

    public static final class Builder {
        private ClassNameGenerator nodeNameGenerator = new NodeNameGenerator();
        private ClassNameGenerator relationshipNameGenerator = new RelationshipNameGenerator();
        private JavaVersion target = JavaVersion.RELEASE_8;
        private String defaultPackage = "";
        private Path path;
        private String prefix;
        private String suffix = "_";
        private IndentStyle indentStyle = IndentStyle.TAB;
        private int indentSize = 2;
        private String timestamp;
        private boolean addAtGenerated = false;

        private Builder() {
        }

        static Builder newConfig() {
            return new Builder();
        }

        static Builder newConfig(Path path) {
            return new Builder().withPath(path);
        }

        public Builder withNodeNameGenerator(ClassNameGenerator nodeNameGenerator) {
            if (nodeNameGenerator == null) {
                throw new IllegalArgumentException("A class name generator for nodes is required.");
            }
            this.nodeNameGenerator = nodeNameGenerator;
            return this;
        }

        public Builder withRelationshipNameGenerator(ClassNameGenerator relationshipNameGenerator) {
            if (relationshipNameGenerator == null) {
                throw new IllegalArgumentException("A class name generator for relationships is required.");
            }
            this.relationshipNameGenerator = relationshipNameGenerator;
            return this;
        }

        public Builder withTarget(JavaVersion target) {
            if (target == null) {
                throw new IllegalArgumentException("A java version is required.");
            }
            this.target = target;
            return this;
        }

        public Builder withDefaultPackage(String defaultPackage) {
            if (defaultPackage == null) {
                throw new IllegalArgumentException("A default package is required.");
            }
            this.defaultPackage = defaultPackage;
            return this;
        }

        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder withAddAtGenerated(boolean addAtGenerated) {
            this.addAtGenerated = addAtGenerated;
            return this;
        }

        public Builder withIndentStyle(IndentStyle indentStyle) {
            if (indentStyle == null) {
                throw new IllegalArgumentException("Indent style is required.");
            }
            this.indentStyle = indentStyle;
            return this;
        }

        public Builder withIndentSize(int indentSize) {
            this.indentSize = indentSize;
            return this;
        }

        public Configuration build() {
            String indent;
            UnaryOperator typeNameDecorator = this.prefix == null && this.suffix == null ? UnaryOperator.identity() : s -> (this.prefix != null ? this.prefix.trim() : "") + s + (this.suffix != null ? this.suffix.trim() : "");
            if (this.indentStyle == IndentStyle.TAB) {
                indent = "\t";
            } else {
                StringBuilder indentBuilder = new StringBuilder();
                for (int i = 0; i < this.indentSize; ++i) {
                    indentBuilder.append(" ");
                }
                indent = indentBuilder.toString();
            }
            Clock clock = null;
            if (this.timestamp != null && !this.timestamp.isEmpty()) {
                ZonedDateTime z = ZonedDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(this.timestamp));
                clock = Clock.fixed(z.toInstant(), z.getZone());
            }
            return new Configuration(typeNameDecorator, this.nodeNameGenerator, this.relationshipNameGenerator, FieldNameGenerator.Default.INSTANCE, this.target, this.defaultPackage, this.path, indent, clock, this.addAtGenerated);
        }
    }

    public static enum IndentStyle {
        TAB,
        SPACE;

    }
}

