/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.codegen.core.AbstractModelBuilder;
import org.neo4j.cypherdsl.codegen.core.Configuration;
import org.neo4j.cypherdsl.codegen.core.NodeModelBuilder;
import org.neo4j.cypherdsl.codegen.core.RelationshipPropertyDefinition;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.utils.Strings;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class NodeImplBuilder
extends AbstractModelBuilder<NodeModelBuilder>
implements NodeModelBuilder {
    private static final ClassName TYPE_NAME_NODE_LABEL = ClassName.get(NodeLabel.class);
    private final Set<String> labels = new LinkedHashSet<String>();
    private final Set<RelationshipPropertyDefinition> relationshipDefinitions = new LinkedHashSet<RelationshipPropertyDefinition>();

    static NodeModelBuilder create(Configuration configuration, String packageName, String suggestedTypeName) {
        String className = configuration.getNodeNameGenerator().generate(suggestedTypeName);
        String usedPackageName = packageName == null ? configuration.getDefaultPackage() : packageName;
        NodeImplBuilder builder = new NodeImplBuilder(configuration, ClassName.get((String)usedPackageName, (String)((String)configuration.getTypeNameDecorator().apply(className)), (String[])new String[0]), className);
        return (NodeModelBuilder)builder.apply(configuration);
    }

    private NodeImplBuilder(Configuration configuration, ClassName className, String fieldName) {
        super(configuration.getConstantFieldNameGenerator(), className, fieldName, configuration.getTarget(), configuration.getIndent());
    }

    @Override
    public NodeModelBuilder addLabel(String newLabel) {
        return this.addLabels(newLabel == null ? Collections.emptyList() : Collections.singleton(newLabel));
    }

    @Override
    public NodeModelBuilder addLabels(Collection<String> newLabels) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            if (newLabels != null) {
                this.labels.addAll(newLabels);
            }
            return this;
        });
    }

    @Override
    public NodeModelBuilder addRelationshipDefinition(RelationshipPropertyDefinition definition) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            if (definition != null) {
                this.relationshipDefinitions.add(definition);
            }
            return this;
        });
    }

    private MethodSpec buildDefaultConstructor() {
        CodeBlock.Builder superCallBuilder = CodeBlock.builder().add("super(", new Object[0]);
        superCallBuilder.add(CodeBlock.join((Iterable)this.labels.stream().map(l -> CodeBlock.of((String)"$S", (Object[])new Object[]{l})).collect(Collectors.toList()), (String)", "));
        superCallBuilder.add(")", new Object[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement(superCallBuilder.build()).build();
    }

    private MethodSpec buildCopyConstructor() {
        ParameterSpec symbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"symbolicName", (Modifier[])new Modifier[0]).build();
        ParameterSpec labelsParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)TYPE_NAME_LIST, (TypeName[])new TypeName[]{TYPE_NAME_NODE_LABEL}), (String)"labels", (Modifier[])new Modifier[0]).build();
        ParameterSpec properties = ParameterSpec.builder((TypeName)ClassName.get(Properties.class), (String)"properties", (Modifier[])new Modifier[0]).build();
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(symbolicName).addParameter(labelsParameter).addParameter(properties).addStatement("super($N, $N, $N)", new Object[]{symbolicName, labelsParameter, properties}).build();
    }

    private MethodSpec buildNamedMethod() {
        ParameterSpec newSymbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"newSymbolicName", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"named").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.className).addParameter(newSymbolicName).addStatement("return new $T($N, getLabels(), getProperties())", new Object[]{this.className, newSymbolicName}).build();
    }

    private MethodSpec buildWithPropertiesMethod() {
        ParameterSpec newProperties = ParameterSpec.builder((TypeName)TYPE_NAME_MAP_EXPRESSION, (String)"newProperties", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"withProperties").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.className).addParameter(newProperties).addStatement("return new $T(getSymbolicName().orElse(null), getLabels(), Properties.create($N))", new Object[]{this.className, newProperties}).build();
    }

    private static boolean isSelfReferential(RelationshipPropertyDefinition rpd) {
        return rpd.getStart() == rpd.getEnd();
    }

    private static boolean isNotSelfReferential(RelationshipPropertyDefinition rpd) {
        return !NodeImplBuilder.isSelfReferential(rpd);
    }

    private List<FieldSpec> buildFields() {
        FieldSpec defaultInstance = FieldSpec.builder((TypeName)this.className, (String)this.getFieldName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{this.className}).build();
        Stream<FieldSpec> properties = this.generateFieldSpecsFromProperties();
        Stream<FieldSpec> relationships = this.relationshipDefinitions.stream().filter(NodeImplBuilder::isNotSelfReferential).map(p -> {
            String fieldName = this.fieldNameGenerator.generate(p.getNameInDomain() == null ? p.getType() : p.getNameInDomain());
            ClassName relationshipClassName = NodeImplBuilder.extractClassName(p.getRelationshipBuilder());
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)relationshipClassName, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            if (this == p.getStart()) {
                builder.initializer("new $T(this, $T.$N)", new Object[]{relationshipClassName, NodeImplBuilder.extractClassName(p.getEnd()), p.getEnd().getFieldName()});
            } else {
                builder.initializer("new $T($T.$N, this)", new Object[]{relationshipClassName, NodeImplBuilder.extractClassName(p.getStart()), p.getStart().getFieldName()});
            }
            return builder.build();
        });
        return Stream.concat(Stream.of(defaultInstance), Stream.concat(properties, relationships)).collect(Collectors.toList());
    }

    static String capitalize(String str) {
        char updatedChar;
        if (!Strings.hasText((String)str)) {
            return str;
        }
        char baseChar = str.charAt(0);
        if (baseChar == (updatedChar = Character.toUpperCase(baseChar))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = updatedChar;
        return new String(chars);
    }

    @Override
    protected JavaFile buildJavaFile() {
        if (this.labels.isEmpty()) {
            throw new IllegalStateException("Cannot build NodeImpl without labels!");
        }
        TypeSpec.Builder builder = this.addGenerated(TypeSpec.classBuilder((ClassName)this.className)).superclass((TypeName)ParameterizedTypeName.get((ClassName)TYPE_NAME_NODE_BASE, (TypeName[])new TypeName[]{this.className})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(this.buildFields()).addMethod(this.buildDefaultConstructor()).addMethod(this.buildCopyConstructor()).addMethod(this.buildNamedMethod()).addMethod(this.buildWithPropertiesMethod());
        this.relationshipDefinitions.stream().filter(NodeImplBuilder::isSelfReferential).map(this.buildSelfReferentialAccessor()).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        TypeSpec newType = builder.build();
        return this.prepareFileBuilder(newType).build();
    }

    private Function<RelationshipPropertyDefinition, MethodSpec> buildSelfReferentialAccessor() {
        return p -> {
            ClassName relationshipClassName = NodeImplBuilder.extractClassName(p.getRelationshipBuilder());
            ParameterSpec end = ParameterSpec.builder((TypeName)this.className, (String)p.getNameInDomain(), (Modifier[])new Modifier[0]).build();
            return MethodSpec.methodBuilder((String)("with" + NodeImplBuilder.capitalize(p.getNameInDomain()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)relationshipClassName).addParameter(end).addStatement("return new $T(this, $N)", new Object[]{relationshipClassName, end}).build();
        };
    }
}

