/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import org.neo4j.cypherdsl.codegen.core.Identifiers;

@FunctionalInterface
public interface FieldNameGenerator {
    public String generate(String var1);

    public static enum Default implements FieldNameGenerator
    {
        INSTANCE;


        @Override
        public String generate(String name) {
            int codePoint;
            StringBuilder sb = new StringBuilder();
            int previousIndex = 0;
            boolean prevWasLower = false;
            boolean nextIsLower = false;
            for (int i = 0; i < name.length(); i += Character.charCount(codePoint)) {
                codePoint = name.codePointAt(i);
                if (Identifiers.isValidAt(i, codePoint)) {
                    if (nextIsLower || Character.isLowerCase(codePoint)) {
                        prevWasLower = true;
                        nextIsLower = false;
                        if (!sb.isEmpty() && !Character.isLetter(name.codePointAt(previousIndex))) {
                            sb.append("_");
                        }
                        codePoint = Character.toUpperCase(codePoint);
                    } else if (!sb.isEmpty() && (prevWasLower || i + 1 < name.length() && Character.isLowerCase(name.codePointAt(i + 1)))) {
                        sb.append("_");
                        nextIsLower = true;
                    }
                    sb.append(Character.toChars(codePoint));
                }
                previousIndex = i;
            }
            return sb.toString();
        }
    }
}

