/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.codegen.core.AbstractModelBuilder;
import org.neo4j.cypherdsl.codegen.core.Configuration;
import org.neo4j.cypherdsl.codegen.core.NodeModelBuilder;
import org.neo4j.cypherdsl.codegen.core.RelationshipFactoryDefinition;
import org.neo4j.cypherdsl.codegen.core.RelationshipImplBuilder;
import org.neo4j.cypherdsl.codegen.core.RelationshipModelBuilder;
import org.neo4j.cypherdsl.codegen.core.RelationshipPropertyDefinition;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Properties;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class NodeImplBuilder
extends AbstractModelBuilder<NodeModelBuilder>
implements NodeModelBuilder {
    private static final ClassName TYPE_NAME_NODE_LABEL = ClassName.get(NodeLabel.class);
    private final Set<String> labels = new LinkedHashSet<String>();
    private final Set<RelationshipPropertyDefinition> relationshipDefinitions = new LinkedHashSet<RelationshipPropertyDefinition>();
    private final Set<RelationshipFactoryDefinition> relationshipMethodDefinitions = new LinkedHashSet<RelationshipFactoryDefinition>();
    private NodeModelBuilder baseModel;
    private TypeVariableName self;
    private boolean extensible;

    static NodeModelBuilder create(Configuration configuration, String packageName, String suggestedTypeName) {
        String className = configuration.getNodeNameGenerator().generate(suggestedTypeName);
        String usedPackageName = packageName == null ? configuration.getDefaultPackage() : packageName;
        NodeImplBuilder builder = new NodeImplBuilder(configuration, ClassName.get((String)usedPackageName, (String)((String)configuration.getTypeNameDecorator().apply(className)), (String[])new String[0]), className);
        return (NodeModelBuilder)builder.apply(configuration);
    }

    private NodeImplBuilder(Configuration configuration, ClassName className, String fieldName) {
        super(configuration.getConstantFieldNameGenerator(), className, fieldName, configuration.getTarget(), configuration.getIndent());
        this.self = TypeVariableName.get((String)"SELF", (TypeName[])new TypeName[]{className});
    }

    @Override
    public NodeModelBuilder addLabel(String newLabel) {
        return this.addLabels(newLabel == null ? Collections.emptyList() : Collections.singleton(newLabel));
    }

    @Override
    public NodeModelBuilder addLabels(Collection<String> newLabels) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            if (newLabels != null) {
                this.labels.addAll(newLabels);
            }
            return this;
        });
    }

    @Override
    public NodeModelBuilder addRelationshipDefinition(RelationshipPropertyDefinition definition) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            if (definition != null) {
                this.relationshipDefinitions.add(definition);
            }
            return this;
        });
    }

    @Override
    public NodeModelBuilder addRelationshipFactory(RelationshipFactoryDefinition definition) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            if (definition != null) {
                this.relationshipMethodDefinitions.add(definition);
            }
            return this;
        });
    }

    @Override
    public NodeModelBuilder setBaseNodeModel(NodeModelBuilder baseNodeModel) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            this.baseModel = baseNodeModel;
            return this;
        });
    }

    @Override
    public NodeModelBuilder setExtensible(boolean isExtensible) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            NodeImplBuilder nodeImplBuilder = this;
            synchronized (nodeImplBuilder) {
                this.extensible = isExtensible;
                this.self = this.extensible ? TypeVariableName.get((String)"SELF", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})}) : TypeVariableName.get((String)"SELF", (TypeName[])new TypeName[]{this.className});
                return this;
            }
        });
    }

    @Override
    public boolean isExtensible() {
        return this.extensible;
    }

    private MethodSpec buildDefaultConstructor(FieldSpec primaryLabelField) {
        CodeBlock.Builder superCallBuilder = CodeBlock.builder().add("super(", new Object[0]);
        superCallBuilder.add(CodeBlock.of((String)"$N", (Object[])new Object[]{primaryLabelField}));
        if (this.labels.size() > 1) {
            superCallBuilder.add(", ", new Object[0]);
            superCallBuilder.add(CodeBlock.join(this.labels.stream().skip(1L).map(l -> CodeBlock.of((String)"$S", (Object[])new Object[]{l})).toList(), (String)", "));
        }
        superCallBuilder.add(")", new Object[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement(superCallBuilder.build()).build();
    }

    private MethodSpec buildConstructorForInheritance(FieldSpec primaryLabelField) {
        ParameterSpec primaryLabelParam = ParameterSpec.builder(String.class, (String)"primaryLabel", (Modifier[])new Modifier[0]).build();
        ParameterSpec additionalLabels = ParameterSpec.builder(String[].class, (String)"additionalLabels", (Modifier[])new Modifier[0]).build();
        CodeBlock.Builder superCallBuilder = CodeBlock.builder().add("super(", new Object[0]);
        superCallBuilder.add(CodeBlock.of((String)"$N", (Object[])new Object[]{primaryLabelParam}));
        superCallBuilder.add(", ", new Object[0]);
        superCallBuilder.add(CodeBlock.of((String)"$T.concat($T.stream($N), $T.of($N", (Object[])new Object[]{Stream.class, Arrays.class, additionalLabels, Stream.class, primaryLabelField}));
        if (this.labels.size() > 1) {
            superCallBuilder.add(", ", new Object[0]);
            superCallBuilder.add(CodeBlock.join(this.labels.stream().skip(1L).map(l -> CodeBlock.of((String)"$S", (Object[])new Object[]{l})).toList(), (String)", "));
        }
        superCallBuilder.add(")).toArray($T[]::new))", new Object[]{String.class});
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(primaryLabelParam).addParameter(additionalLabels).varargs().addStatement(superCallBuilder.build()).build();
    }

    private MethodSpec buildCreateMethod() {
        ParameterSpec symbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"symbolicName", (Modifier[])new Modifier[0]).build();
        ParameterSpec labelsParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)TYPE_NAME_LIST, (TypeName[])new TypeName[]{TYPE_NAME_NODE_LABEL}), (String)"labels", (Modifier[])new Modifier[0]).build();
        ParameterSpec properties = ParameterSpec.builder((TypeName)ClassName.get(Properties.class), (String)"properties", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(symbolicName).addParameter(labelsParameter).addParameter(properties);
        if (this.baseModel != null) {
            builder.addAnnotation(Override.class);
        }
        if (this.extensible) {
            builder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"unchecked\"", new Object[0]).build());
            builder.addStatement("return ($T) new $T<>($N, $N, $N)", new Object[]{this.self, this.className, symbolicName, labelsParameter, properties}).returns((TypeName)this.self);
        } else {
            builder.addStatement("return new $T($N, $N, $N)", new Object[]{this.className, symbolicName, labelsParameter, properties}).returns((TypeName)this.className);
        }
        return builder.build();
    }

    private MethodSpec buildCopyConstructor() {
        ParameterSpec symbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"symbolicName", (Modifier[])new Modifier[0]).build();
        ParameterSpec labelsParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)TYPE_NAME_LIST, (TypeName[])new TypeName[]{TYPE_NAME_NODE_LABEL}), (String)"labels", (Modifier[])new Modifier[0]).build();
        ParameterSpec properties = ParameterSpec.builder((TypeName)ClassName.get(Properties.class), (String)"properties", (Modifier[])new Modifier[0]).build();
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{this.extensible ? Modifier.PROTECTED : Modifier.PRIVATE}).addParameter(symbolicName).addParameter(labelsParameter).addParameter(properties).addStatement("super($N, $N, $N)", new Object[]{symbolicName, labelsParameter, properties}).build();
    }

    private MethodSpec buildNamedMethod() {
        ParameterSpec newSymbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"newSymbolicName", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"named").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(newSymbolicName);
        if (this.extensible) {
            builder.returns((TypeName)this.self).addStatement("return create($N, getLabels(), getProperties())", new Object[]{newSymbolicName});
        } else {
            builder.returns((TypeName)this.className).addStatement("return new $T($N, getLabels(), getProperties())", new Object[]{this.className, newSymbolicName});
        }
        return builder.build();
    }

    private MethodSpec buildWithPropertiesMethod() {
        ParameterSpec newProperties = ParameterSpec.builder((TypeName)TYPE_NAME_MAP_EXPRESSION, (String)"newProperties", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"withProperties").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(newProperties);
        if (this.extensible) {
            builder.returns((TypeName)this.self).addStatement("return create(getSymbolicName().orElse(null), getLabels(), Properties.create($N))", new Object[]{newProperties});
        } else {
            builder.returns((TypeName)this.className).addStatement("return new $T(getSymbolicName().orElse(null), getLabels(), Properties.create($N))", new Object[]{this.className, newProperties});
        }
        return builder.build();
    }

    private static boolean isSelfReferential(RelationshipPropertyDefinition rpd) {
        return rpd.getStart() == rpd.getEnd();
    }

    private static boolean isNotSelfReferential(RelationshipPropertyDefinition rpd) {
        return !NodeImplBuilder.isSelfReferential(rpd);
    }

    private List<FieldSpec> buildFields(FieldSpec primaryLabelField) {
        FieldSpec defaultInstance;
        if (this.extensible) {
            ParameterizedTypeName type = ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})});
            defaultInstance = FieldSpec.builder((TypeName)type, (String)this.getFieldName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T<>()", new Object[]{this.className}).build();
        } else {
            defaultInstance = FieldSpec.builder((TypeName)this.className, (String)this.getFieldName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{this.className}).build();
        }
        Stream<FieldSpec> properties = this.generateFieldSpecsFromProperties();
        Stream<FieldSpec> relationships = this.relationshipDefinitions.stream().filter(NodeImplBuilder::isNotSelfReferential).map(p -> {
            String fieldName = this.fieldNameGenerator.generate(p.getNameInDomain() == null ? p.getType() : p.getNameInDomain());
            ClassName startClass = NodeImplBuilder.extractClassName(p.getStart());
            ClassName endClass = NodeImplBuilder.extractClassName(p.getEnd());
            TypeName relationshipClassName = this.getRelationTypeWithParameters(p.getRelationshipBuilder(), (TypeName)startClass, endClass);
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)relationshipClassName, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            if (this == p.getStart()) {
                builder.initializer("new $T(this, $T.$N)", new Object[]{relationshipClassName, endClass, p.getEnd().getFieldName()});
            } else {
                builder.initializer("new $T($T.$N, this)", new Object[]{relationshipClassName, startClass, p.getStart().getFieldName()});
            }
            return builder.build();
        });
        return Stream.concat(Stream.of(primaryLabelField, defaultInstance), Stream.concat(properties, relationships)).toList();
    }

    static String capitalize(String str) {
        char updatedChar;
        if (str == null || str.isBlank()) {
            return str;
        }
        char baseChar = str.charAt(0);
        if (baseChar == (updatedChar = Character.toUpperCase(baseChar))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = updatedChar;
        return new String(chars);
    }

    @Override
    protected JavaFile buildJavaFile() {
        ClassName baseNode;
        block9: {
            block10: {
                if (this.labels.isEmpty()) {
                    throw new IllegalStateException("Cannot build NodeImpl without labels!");
                }
                ClassName className = baseNode = this.baseModel == null ? TYPE_NAME_NODE_BASE : NodeImplBuilder.extractClassName(this.baseModel);
                if (this.baseModel == null) break block9;
                NodeModelBuilder nodeModelBuilder = this.baseModel;
                if (!(nodeModelBuilder instanceof NodeImplBuilder)) break block10;
                NodeImplBuilder nmb = (NodeImplBuilder)nodeModelBuilder;
                if (nmb.extensible) break block9;
            }
            throw new IllegalStateException("Cannot extend non-extensible node " + this.baseModel.getCanonicalClassName());
        }
        FieldSpec primaryLabelField = FieldSpec.builder(String.class, (String)this.fieldNameGenerator.generate("$PRIMARY_LABEL"), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.labels.stream().findFirst().orElseThrow()}).build();
        TypeSpec.Builder builder = this.addGenerated(TypeSpec.classBuilder((ClassName)this.className));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.extensible) {
            builder.addTypeVariable(this.self).superclass((TypeName)ParameterizedTypeName.get((ClassName)baseNode, (TypeName[])new TypeName[]{this.self}));
        } else {
            builder.addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)baseNode, (TypeName[])new TypeName[]{this.className}));
        }
        builder.addFields(this.buildFields(primaryLabelField)).addMethod(this.buildDefaultConstructor(primaryLabelField));
        if (this.extensible) {
            builder.addMethod(this.buildConstructorForInheritance(primaryLabelField));
        }
        if (this.extensible || baseNode != TYPE_NAME_NODE_BASE) {
            builder.addMethod(this.buildCreateMethod());
        }
        builder.addMethod(this.buildCopyConstructor());
        if (baseNode == TYPE_NAME_NODE_BASE) {
            builder.addMethod(this.buildNamedMethod()).addMethod(this.buildWithPropertiesMethod());
        }
        this.relationshipDefinitions.stream().filter(NodeImplBuilder::isSelfReferential).map(this.buildSelfReferentialAccessor()).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        this.relationshipMethodDefinitions.stream().map(this.buildRelationshipFactoryMethod()).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        TypeSpec newType = builder.build();
        return this.prepareFileBuilder(newType).build();
    }

    private TypeName getRelationTypeWithParameters(RelationshipModelBuilder relationshipBuilder, TypeName startClass, ClassName endClass) {
        ClassName relationshipClassName;
        if (relationshipBuilder instanceof RelationshipImplBuilder) {
            RelationshipImplBuilder impl = (RelationshipImplBuilder)relationshipBuilder;
            relationshipClassName = impl.getTypeName(startClass, (TypeName)endClass);
        } else {
            relationshipClassName = NodeImplBuilder.extractClassName(relationshipBuilder);
        }
        return relationshipClassName;
    }

    private Function<RelationshipPropertyDefinition, MethodSpec> buildSelfReferentialAccessor() {
        return p -> {
            ClassName relationshipClassName = NodeImplBuilder.extractClassName(p.getRelationshipBuilder());
            ParameterSpec end = ParameterSpec.builder((TypeName)this.className, (String)p.getNameInDomain(), (Modifier[])new Modifier[0]).build();
            return MethodSpec.methodBuilder((String)("with" + NodeImplBuilder.capitalize(p.getNameInDomain()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)relationshipClassName).addParameter(end).addStatement("return new $T(this, $N)", new Object[]{relationshipClassName, end}).build();
        };
    }

    private Function<RelationshipFactoryDefinition, MethodSpec> buildRelationshipFactoryMethod() {
        return p -> {
            ClassName startClass = NodeImplBuilder.extractClassName(p.getStart());
            ClassName endClass = NodeImplBuilder.extractClassName(p.getEnd());
            TypeName relationshipClassName = this.getRelationTypeWithParameters(p.getRelationshipBuilder(), (TypeName)startClass, endClass);
            MethodSpec.Builder b = MethodSpec.methodBuilder((String)p.getNameInDomain()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(relationshipClassName);
            if (this == p.getStart()) {
                ParameterSpec param = ParameterSpec.builder((TypeName)endClass, (String)"end", (Modifier[])new Modifier[0]).build();
                b.addParameter(param).addStatement("return new $T(this, $N)", new Object[]{relationshipClassName, param});
            } else {
                ParameterSpec param = ParameterSpec.builder((TypeName)startClass, (String)"start", (Modifier[])new Modifier[0]).build();
                b.addParameter(param).addStatement("return new $T($N, this)", new Object[]{relationshipClassName, param});
            }
            return b.build();
        };
    }
}

