/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="2021.1.0")
public final class PropertyDefinition {
    private final String nameInGraph;
    private final String nameInDomain;

    public static PropertyDefinition create(String nameInGraph, String optionalNameInDomain) {
        if (nameInGraph == null || nameInGraph.isBlank()) {
            throw new IllegalArgumentException("The name of the property in the graph must not be null or empty.");
        }
        return new PropertyDefinition(nameInGraph, optionalNameInDomain);
    }

    private PropertyDefinition(String nameInGraph, String nameInDomain) {
        this.nameInGraph = nameInGraph;
        this.nameInDomain = nameInDomain;
    }

    public String getNameInGraph() {
        return this.nameInGraph;
    }

    public String getNameInDomain() {
        return this.nameInDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyDefinition that = (PropertyDefinition)o;
        return this.nameInGraph.equals(that.nameInGraph) && Objects.equals(this.nameInDomain, that.nameInDomain);
    }

    public int hashCode() {
        return Objects.hash(this.nameInGraph, this.nameInDomain);
    }
}

