/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.core;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.codegen.core.AbstractModelBuilder;
import org.neo4j.cypherdsl.codegen.core.Configuration;
import org.neo4j.cypherdsl.codegen.core.NodeModelBuilder;
import org.neo4j.cypherdsl.codegen.core.RelationshipModelBuilder;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.RelationshipBase;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class RelationshipImplBuilder
extends AbstractModelBuilder<RelationshipModelBuilder>
implements RelationshipModelBuilder {
    private static final ClassName TYPE_NAME_RELATIONSHIP_BASE = ClassName.get(RelationshipBase.class);
    private static final TypeVariableName S = TypeVariableName.get((String)"S", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)TYPE_NAME_NODE_BASE, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})});
    private static final TypeVariableName E = TypeVariableName.get((String)"E", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)TYPE_NAME_NODE_BASE, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})});
    private final FieldSpec relationshipTypeField;
    private final Deque<Edge> edges = new ArrayDeque<Edge>();

    static RelationshipModelBuilder create(Configuration configuration, String packageName, String relationshipType, String alternateClassNameSuggestion) {
        String className = configuration.getRelationshipNameGenerator().generate(alternateClassNameSuggestion != null ? alternateClassNameSuggestion : relationshipType);
        String usedPackageName = packageName == null ? configuration.getDefaultPackage() : packageName;
        RelationshipImplBuilder builder = new RelationshipImplBuilder(configuration, relationshipType, ClassName.get((String)usedPackageName, (String)((String)configuration.getTypeNameDecorator().apply(className)), (String[])new String[0]), className);
        return (RelationshipModelBuilder)builder.apply(configuration);
    }

    private RelationshipImplBuilder(Configuration configuration, String relationshipType, ClassName className, String fieldName) {
        super(configuration.getConstantFieldNameGenerator(), className, fieldName, configuration.getTarget(), configuration.getIndent());
        if (relationshipType == null) {
            throw new IllegalStateException("Cannot build a RelationshipImpl without a single relationship type!");
        }
        this.relationshipTypeField = FieldSpec.builder(String.class, (String)configuration.getConstantFieldNameGenerator().generate("$TYPE"), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{relationshipType}).build();
    }

    @Override
    public RelationshipModelBuilder setStartNode(NodeModelBuilder newStartNode) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            Edge lastRelation = this.getOrCreateLastDefinedRelationType();
            lastRelation.start = RelationshipImplBuilder.extractClassName(newStartNode);
            return this;
        });
    }

    @Override
    public RelationshipModelBuilder setEndNode(NodeModelBuilder newEndNode) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            Edge lastRelation = this.getOrCreateLastDefinedRelationType();
            lastRelation.end = RelationshipImplBuilder.extractClassName(newEndNode);
            return this;
        });
    }

    private Edge getOrCreateLastDefinedRelationType() {
        Edge lastRelation = this.edges.peek();
        if (lastRelation == null) {
            lastRelation = new Edge((TypeName)S, (TypeName)E);
            this.edges.push(lastRelation);
        }
        return lastRelation;
    }

    private MethodSpec buildConstructor(Edge relation, Edge expectedTypes) {
        ParameterSpec startNodeParam = ParameterSpec.builder((TypeName)relation.start, (String)"start", (Modifier[])new Modifier[0]).build();
        ParameterSpec endNodeParam = ParameterSpec.builder((TypeName)relation.end, (String)"end", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(startNodeParam).addParameter(endNodeParam);
        if (relation.start != expectedTypes.start) {
            if (relation.end != expectedTypes.end) {
                builder.addStatement("super(($T) $N, $N, ($T) $N)", new Object[]{expectedTypes.start, startNodeParam, this.relationshipTypeField, expectedTypes.end, endNodeParam});
            } else {
                builder.addStatement("super(($T) $N, $N, $N)", new Object[]{expectedTypes.start, startNodeParam, this.relationshipTypeField, endNodeParam});
            }
        } else if (relation.end != expectedTypes.end) {
            builder.addStatement("super($N, $N, ($T) $N)", new Object[]{startNodeParam, this.relationshipTypeField, expectedTypes.end, endNodeParam});
        } else {
            builder.addStatement("super($N, $N, $N)", new Object[]{startNodeParam, this.relationshipTypeField, endNodeParam});
        }
        return builder.build();
    }

    @Override
    public RelationshipModelBuilder addRelationship(NodeModelBuilder newStartNode, NodeModelBuilder newEndNode) {
        return this.callOnlyWithoutJavaFilePresent(() -> {
            TypeVariableName startNode = S;
            if (newStartNode != null) {
                startNode = newStartNode.isExtensible() ? ParameterizedTypeName.get((ClassName)RelationshipImplBuilder.extractClassName(newStartNode), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}) : RelationshipImplBuilder.extractClassName(newStartNode);
            }
            TypeVariableName endNode = E;
            if (newEndNode != null) {
                endNode = newEndNode.isExtensible() ? ParameterizedTypeName.get((ClassName)RelationshipImplBuilder.extractClassName(newEndNode), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}) : RelationshipImplBuilder.extractClassName(newEndNode);
            }
            this.edges.add(new Edge((TypeName)startNode, (TypeName)endNode));
            return this;
        });
    }

    private MethodSpec buildCopyConstructor() {
        ParameterSpec symbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"symbolicName", (Modifier[])new Modifier[0]).build();
        ParameterSpec start = ParameterSpec.builder((TypeName)TYPE_NAME_NODE, (String)"start", (Modifier[])new Modifier[0]).build();
        ParameterSpec properties = ParameterSpec.builder((TypeName)ClassName.get(Properties.class), (String)"properties", (Modifier[])new Modifier[0]).build();
        ParameterSpec end = ParameterSpec.builder((TypeName)TYPE_NAME_NODE, (String)"end", (Modifier[])new Modifier[0]).build();
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameters(Arrays.asList(symbolicName, start, properties, end)).addStatement("super($N, $N, $N, $N, $N)", new Object[]{symbolicName, start, this.relationshipTypeField, properties, end}).build();
    }

    private MethodSpec buildNamedMethod(TypeName typeName) {
        ParameterSpec newSymbolicName = ParameterSpec.builder((TypeName)TYPE_NAME_SYMBOLIC_NAME, (String)"newSymbolicName", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"named").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(typeName).addParameter(newSymbolicName).addStatement("return new $T$L($N, getLeft(), getDetails().getProperties(), getRight())", new Object[]{this.className, typeName == this.className ? "" : "<>", newSymbolicName}).build();
    }

    private MethodSpec buildWithPropertiesMethod(TypeName typeName) {
        ParameterSpec newProperties = ParameterSpec.builder((TypeName)TYPE_NAME_MAP_EXPRESSION, (String)"newProperties", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"withProperties").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(typeName).addParameter(newProperties).addStatement("return new $T$L(getSymbolicName().orElse(null), getLeft(), Properties.create($N), getRight())", new Object[]{this.className, typeName == this.className ? "" : "<>", newProperties}).build();
    }

    private List<FieldSpec> buildFields() {
        return Stream.concat(Stream.of(this.relationshipTypeField), this.generateFieldSpecsFromProperties()).toList();
    }

    @Override
    protected JavaFile buildJavaFile() {
        Edge expectedTypes = RelationshipImplBuilder.pickDefault(this.edges);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className);
        TypeName typeName = this.getTypeName(expectedTypes);
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName pt = (ParameterizedTypeName)typeName;
            for (TypeName t : pt.typeArguments) {
                if (!(t instanceof TypeVariableName)) continue;
                TypeVariableName tn = (TypeVariableName)t;
                builder.addTypeVariable(tn);
            }
        }
        this.addGenerated(builder).superclass((TypeName)ParameterizedTypeName.get((ClassName)TYPE_NAME_RELATIONSHIP_BASE, (TypeName[])new TypeName[]{expectedTypes.start, expectedTypes.end, typeName})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addFields(this.buildFields());
        (this.edges.isEmpty() ? Stream.of(new Edge((TypeName)S, (TypeName)E)) : this.edges.stream()).map(relation -> this.buildConstructor((Edge)relation, expectedTypes)).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        TypeSpec newType = builder.addMethod(this.buildCopyConstructor()).addMethod(this.buildNamedMethod(typeName)).addMethod(this.buildWithPropertiesMethod(typeName)).build();
        return this.prepareFileBuilder(newType).build();
    }

    private TypeName getTypeName(Edge expectedTypes) {
        return this.getTypeName(expectedTypes, null, null);
    }

    TypeName getTypeName(TypeName concreteStartType, TypeName concreteEndType) {
        return this.getTypeName(RelationshipImplBuilder.pickDefault(this.edges), concreteStartType, concreteEndType);
    }

    private TypeName getTypeName(Edge expectedEdge, TypeName concreteStartType, TypeName concreteEndType) {
        TypeVariableName concreteOrDefaultEnd;
        TypeVariableName concreteOrDefaultStart = concreteStartType == null ? S : concreteStartType;
        Object object = concreteOrDefaultEnd = concreteEndType == null ? E : concreteEndType;
        if (expectedEdge.start == S && expectedEdge.end == E) {
            return ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{concreteOrDefaultStart, concreteOrDefaultEnd});
        }
        if (expectedEdge.start == S) {
            return ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{concreteOrDefaultStart});
        }
        if (expectedEdge.end == E) {
            return ParameterizedTypeName.get((ClassName)this.className, (TypeName[])new TypeName[]{concreteOrDefaultEnd});
        }
        return this.className;
    }

    static Edge pickDefault(Collection<Edge> relations) {
        Set startNodes = relations.stream().map(edge -> edge.start).collect(Collectors.toSet());
        Set endNodes = relations.stream().map(edge -> edge.end).collect(Collectors.toSet());
        TypeVariableName expectedStartNode = startNodes.size() == 1 ? (TypeName)startNodes.iterator().next() : S;
        TypeVariableName expectedEndNode = endNodes.size() == 1 ? (TypeName)endNodes.iterator().next() : E;
        return new Edge((TypeName)expectedStartNode, (TypeName)expectedEndNode);
    }

    private static class Edge {
        TypeName start;
        TypeName end;

        private Edge(TypeName start, TypeName end) {
            this.start = start;
            this.end = end;
        }
    }
}

