/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.codegen.sdn6;

import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.codegen.core.Configuration;
import org.neo4j.cypherdsl.codegen.core.ModelBuilder;
import org.neo4j.cypherdsl.codegen.core.NodeModelBuilder;
import org.neo4j.cypherdsl.codegen.core.PropertyDefinition;
import org.neo4j.cypherdsl.codegen.core.RelationshipModelBuilder;
import org.neo4j.cypherdsl.codegen.core.RelationshipPropertyDefinition;
import org.neo4j.cypherdsl.codegen.sdn6.TypeElementVisitor;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.convert.Neo4jSimpleTypes;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.Property;
import org.springframework.data.neo4j.core.schema.Relationship;

@API(status=API.Status.EXPERIMENTAL, since="2021.1.0")
@SupportedAnnotationTypes(value={"org.springframework.data.neo4j.core.schema.Node", "org.springframework.data.neo4j.core.schema.RelationshipProperties"})
@SupportedOptions(value={"org.neo4j.cypherdsl.codegen.prefix", "org.neo4j.cypherdsl.codegen.suffix", "org.neo4j.cypherdsl.codegen.indent_style", "org.neo4j.cypherdsl.codegen.indent_size", "org.neo4j.cypherdsl.codegen.timestamp", "org.neo4j.cypherdsl.codegen.add_at_generated", "org.neo4j.cypherdsl.codegen.sdn.custom_converter_classes"})
public final class SDN6AnnotationProcessor
extends AbstractProcessor {
    static final String NODE_ANNOTATION = "org.springframework.data.neo4j.core.schema.Node";
    static final String RELATIONSHIP_PROPERTIES_ANNOTATION = "org.springframework.data.neo4j.core.schema.RelationshipProperties";
    static final String PROPERTY_CUSTOM_CONVERTER_CLASSES = "org.neo4j.cypherdsl.codegen.sdn.custom_converter_classes";
    private Types typeUtils;
    private Filer filer;
    private Messager messager;
    private TypeElement nodeAnnotationType;
    private TypeElement relationshipAnnotationType;
    private TypeElement compositePropertyAnnotationType;
    private TypeElement convertWithAnnotationType;
    private TypeElement targetNodeAnnotationType;
    private TypeElement relationshipPropertiesAnnotationType;
    private TypeElement sdnIdAnnotationType;
    private TypeElement sdcIdAnnotationType;
    private TypeElement generatedValueAnnotationType;
    private Configuration configuration;
    private Neo4jConversions conversions;

    private static void disableSpringConverterDebugLog() {
        try {
            Class<?> logback = Class.forName("ch.qos.logback.classic.Logger");
            logback.getMethod("setLevel", new Class[0]).invoke((Object)LoggerFactory.getLogger((String)"org.springframework.data.convert.CustomConversions"), Level.DEBUG);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.configuration = SDN6AnnotationProcessor.createConfiguration(processingEnv);
        this.conversions = this.createConversions(processingEnv);
        Elements elementUtils = processingEnv.getElementUtils();
        this.nodeAnnotationType = elementUtils.getTypeElement(NODE_ANNOTATION);
        this.relationshipPropertiesAnnotationType = elementUtils.getTypeElement(RELATIONSHIP_PROPERTIES_ANNOTATION);
        this.relationshipAnnotationType = elementUtils.getTypeElement("org.springframework.data.neo4j.core.schema.Relationship");
        this.compositePropertyAnnotationType = elementUtils.getTypeElement("org.springframework.data.neo4j.core.schema.CompositeProperty");
        this.convertWithAnnotationType = elementUtils.getTypeElement("org.springframework.data.neo4j.core.convert.ConvertWith");
        this.targetNodeAnnotationType = elementUtils.getTypeElement("org.springframework.data.neo4j.core.schema.TargetNode");
        this.sdnIdAnnotationType = elementUtils.getTypeElement("org.springframework.data.neo4j.core.schema.Id");
        this.sdcIdAnnotationType = elementUtils.getTypeElement("org.springframework.data.annotation.Id");
        this.generatedValueAnnotationType = elementUtils.getTypeElement("org.springframework.data.neo4j.core.schema.GeneratedValue");
    }

    private Neo4jConversions createConversions(ProcessingEnvironment processingEnv) {
        Map<String, String> options = processingEnv.getOptions();
        if (!options.containsKey(PROPERTY_CUSTOM_CONVERTER_CLASSES)) {
            return new Neo4jConversions();
        }
        String classNames = options.get(PROPERTY_CUSTOM_CONVERTER_CLASSES);
        ArrayList converters = new ArrayList();
        Arrays.stream(classNames.split(",")).map(String::trim).filter(cn -> !cn.isEmpty()).forEach(cn -> {
            try {
                Class<?> clazz = Class.forName(cn);
                if (Neo4jPersistentPropertyConverter.class.isAssignableFrom(clazz)) {
                    this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Cannot use dedicated Neo4j persistent property converter of type `" + cn + "` as Spring converter, it will be ignored.");
                    return;
                }
                converters.add(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (e instanceof ClassNotFoundException) {
                    message = "Class `" + cn + "` not found";
                }
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Cannot load converter of type `" + cn + "`, it will be ignored: " + message + ".");
            }
        });
        return new Neo4jConversions(converters);
    }

    private static Configuration createConfiguration(ProcessingEnvironment processingEnv) {
        Configuration.Builder builder = Configuration.newConfig();
        Map<String, String> options = processingEnv.getOptions();
        if (options.containsKey("org.neo4j.cypherdsl.codegen.prefix")) {
            builder.withPrefix(options.get("org.neo4j.cypherdsl.codegen.prefix"));
        }
        if (options.containsKey("org.neo4j.cypherdsl.codegen.suffix")) {
            builder.withSuffix(options.get("org.neo4j.cypherdsl.codegen.suffix"));
        }
        if (options.containsKey("org.neo4j.cypherdsl.codegen.indent_style")) {
            builder.withIndentStyle(Configuration.IndentStyle.valueOf((String)options.get("org.neo4j.cypherdsl.codegen.indent_style")));
        }
        if (options.containsKey("org.neo4j.cypherdsl.codegen.indent_size")) {
            builder.withIndentSize(Integer.parseInt(options.get("org.neo4j.cypherdsl.codegen.indent_size")));
        }
        return builder.withTimestamp((String)options.getOrDefault("org.neo4j.cypherdsl.codegen.timestamp", null)).withAddAtGenerated(Boolean.parseBoolean(options.getOrDefault("org.neo4j.cypherdsl.codegen.add_at_generated", "true"))).withTarget(processingEnv.getSourceVersion().equals((Object)SourceVersion.RELEASE_8) ? Configuration.JavaVersion.RELEASE_8 : Configuration.JavaVersion.RELEASE_11).build();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return false;
        }
        Map<TypeElement, NodeModelBuilder> nodeBuilders = this.populateListOfNodes(SDN6AnnotationProcessor.getTypesAnnotatedWith(this.nodeAnnotationType, roundEnv));
        Map<TypeElement, Map.Entry<TypeElement, List<PropertyDefinition>>> relationshipProperties = this.collectRelationshipProperties(roundEnv);
        Map<NodeModelBuilder, List<VariableElement>> relationshipFields = this.populateNodePropertiesAndCollectRelationshipFields(nodeBuilders);
        Map<String, List<RelationshipModelBuilder>> relationshipBuilders = this.populateListOfRelationships(this.computeRelationshipDefinitions(relationshipFields, relationshipProperties, nodeBuilders));
        ArrayList<NodeModelBuilder> allBuilders = new ArrayList<NodeModelBuilder>(nodeBuilders.values());
        relationshipBuilders.values().forEach(allBuilders::addAll);
        try {
            this.writeSourceFiles(allBuilders);
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Could not write source files: " + e.getMessage());
        }
        return true;
    }

    private void writeSourceFiles(Collection<ModelBuilder<?>> builders) throws IOException {
        for (ModelBuilder<?> nodeModelBuilder : builders) {
            JavaFileObject jfo = this.filer.createSourceFile(nodeModelBuilder.getCanonicalClassName(), new Element[0]);
            Writer writer = jfo.openWriter();
            try {
                nodeModelBuilder.writeTo((Appendable)writer);
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    private static Set<TypeElement> getTypesAnnotatedWith(TypeElement annotation, RoundEnvironment from) {
        return from.getElementsAnnotatedWith(annotation).stream().filter(e -> e.getKind().isClass()).map(TypeElement.class::cast).collect(Collectors.toSet());
    }

    private Map<TypeElement, NodeModelBuilder> populateListOfNodes(Set<TypeElement> classesAnnotatedWithNode) {
        HashMap result = new HashMap();
        classesAnnotatedWithNode.forEach(annotatedClass -> {
            Element enclosingElement;
            String qualifiedName = annotatedClass.getQualifiedName().toString();
            String suggestedTypeName = annotatedClass.getSimpleName().toString();
            String packageName = null;
            LinkedList<String> subpackages = new LinkedList<String>();
            for (enclosingElement = annotatedClass.getEnclosingElement(); enclosingElement != null && !enclosingElement.getKind().equals((Object)ElementKind.PACKAGE); enclosingElement = enclosingElement.getEnclosingElement()) {
                subpackages.add(0, enclosingElement.getSimpleName().toString().toLowerCase(Locale.ROOT));
            }
            if (enclosingElement == null) {
                int lastDot = qualifiedName.lastIndexOf(46);
                if (lastDot > 0) {
                    packageName = qualifiedName.substring(0, lastDot);
                }
            } else if (enclosingElement.getKind().equals((Object)ElementKind.PACKAGE)) {
                String q = ((PackageElement)enclosingElement).getQualifiedName().toString();
                packageName = q + (q.isEmpty() || subpackages.isEmpty() ? "" : ".") + String.join((CharSequence)".", subpackages);
            }
            NodeModelBuilder builder = NodeModelBuilder.create((Configuration)this.configuration, packageName, (String)suggestedTypeName).addLabels(this.getLabel((TypeElement)annotatedClass));
            result.put(annotatedClass, builder);
        });
        return Collections.unmodifiableMap(result);
    }

    private Collection<String> getLabel(TypeElement annotatedClass) {
        Node nodeAnnotation = annotatedClass.getAnnotation(Node.class);
        LinkedHashSet labels = new LinkedHashSet();
        Consumer<String> addLabel = label -> {
            if (!label.isEmpty()) {
                labels.add(label);
            }
        };
        addLabel.accept(nodeAnnotation.primaryLabel());
        Arrays.stream(nodeAnnotation.value()).forEach(addLabel);
        Arrays.stream(nodeAnnotation.labels()).forEach(addLabel);
        if (labels.isEmpty()) {
            addLabel.accept(annotatedClass.getSimpleName().toString());
        }
        return Collections.unmodifiableCollection(labels);
    }

    private Map<TypeElement, Map.Entry<TypeElement, List<PropertyDefinition>>> collectRelationshipProperties(RoundEnvironment roundEnvironment) {
        HashMap result = new HashMap();
        Set<TypeElement> relationshipProperties = SDN6AnnotationProcessor.getTypesAnnotatedWith(this.relationshipPropertiesAnnotationType, roundEnvironment);
        relationshipProperties.forEach(e -> {
            ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
            TypeElement actualTargetType = null;
            for (Element element : e.getEnclosedElements()) {
                if (!element.getKind().isField()) continue;
                Set declaredAnnotations = element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map(DeclaredType::asElement).collect(Collectors.toSet());
                if (declaredAnnotations.contains(this.targetNodeAnnotationType)) {
                    Element element2 = this.typeUtils.asElement(element.asType());
                    actualTargetType = (TypeElement)element2.accept(new TypeElementVisitor(Function.identity()), null);
                    if (actualTargetType != null) continue;
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Cannot resolve generic type, not generating a property for relationships referring to " + e.getQualifiedName(), element2);
                    continue;
                }
                properties.add(this.asPropertyDefinition(element));
            }
            if (actualTargetType != null) {
                result.put(e, new AbstractMap.SimpleEntry(actualTargetType, Collections.unmodifiableList(properties)));
            }
        });
        return Collections.unmodifiableMap(result);
    }

    private Map<NodeModelBuilder, List<VariableElement>> populateNodePropertiesAndCollectRelationshipFields(Map<TypeElement, NodeModelBuilder> nodeBuilders) {
        HashMap relationshipFields = new HashMap();
        nodeBuilders.forEach((type, nodeImplBuilder) -> {
            GroupPropertiesAndRelationships groupPropertiesAndRelationships = new GroupPropertiesAndRelationships();
            type.getEnclosedElements().forEach(groupPropertiesAndRelationships::apply);
            Map<FieldType, List<VariableElement>> fields = groupPropertiesAndRelationships.getResult();
            nodeImplBuilder.addProperties((Collection)fields.get((Object)FieldType.P).stream().map(this::asPropertyDefinition).collect(Collectors.toList()));
            relationshipFields.put(nodeImplBuilder, fields.get((Object)FieldType.R));
        });
        return Collections.unmodifiableMap(relationshipFields);
    }

    private Map<String, List<Map.Entry<NodeModelBuilder, RelationshipPropertyDefinition>>> computeRelationshipDefinitions(Map<NodeModelBuilder, List<VariableElement>> allRelationshipFields, Map<TypeElement, Map.Entry<TypeElement, List<PropertyDefinition>>> relationshipProperties, Map<TypeElement, NodeModelBuilder> nodeBuilders) {
        HashMap definitions = new HashMap();
        allRelationshipFields.forEach((start, l) -> l.forEach(f -> {
            RelationshipPropertyDefinition propertyDefinition = this.asRelationshipDefinition((NodeModelBuilder)start, (Element)f, relationshipProperties, nodeBuilders);
            if (propertyDefinition != null) {
                definitions.computeIfAbsent(propertyDefinition.getType(), k -> new ArrayList()).add(new AbstractMap.SimpleEntry<NodeModelBuilder, RelationshipPropertyDefinition>((NodeModelBuilder)start, propertyDefinition));
            }
        }));
        return Collections.unmodifiableMap(definitions);
    }

    private Map<String, List<RelationshipModelBuilder>> populateListOfRelationships(Map<String, List<Map.Entry<NodeModelBuilder, RelationshipPropertyDefinition>>> relationshipDefinitions) {
        HashMap result = new HashMap();
        relationshipDefinitions.forEach((type, definitions) -> {
            RelationshipModelBuilder relationshipBuilder = null;
            if (definitions.size() == 1) {
                NodeModelBuilder owner = (NodeModelBuilder)((Map.Entry)definitions.get(0)).getKey();
                Object definition = (RelationshipPropertyDefinition)((Map.Entry)definitions.get(0)).getValue();
                relationshipBuilder = RelationshipModelBuilder.create((Configuration)this.configuration, (String)owner.getPackageName(), (String)type);
                relationshipBuilder.setStartNode(definition.getStart());
                relationshipBuilder.setEndNode(definition.getEnd());
                relationshipBuilder.addProperties((Collection)definition.getProperties());
            } else {
                Set owners = definitions.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
                if (owners.size() == 1) {
                    NodeModelBuilder owner = (NodeModelBuilder)owners.stream().findFirst().get();
                    Map<Boolean, List<RelationshipPropertyDefinition>> ownerAtStartOrEnd = definitions.stream().map(Map.Entry::getValue).collect(Collectors.partitioningBy(p -> p.getStart() == owner));
                    if (SDN6AnnotationProcessor.sameOrNoProperties(definitions)) {
                        relationshipBuilder = RelationshipModelBuilder.create((Configuration)this.configuration, (String)owner.getPackageName(), (String)type);
                        relationshipBuilder.addProperties((Collection)((RelationshipPropertyDefinition)((Map.Entry)definitions.get(0)).getValue()).getProperties());
                        if (ownerAtStartOrEnd.get(true).isEmpty()) {
                            relationshipBuilder.setEndNode(owner);
                        } else if (ownerAtStartOrEnd.get(false).isEmpty()) {
                            relationshipBuilder.setStartNode(owner);
                        }
                    } else {
                        ArrayList<RelationshipModelBuilder> newBuilders = new ArrayList<RelationshipModelBuilder>();
                        for (Map.Entry definition : definitions) {
                            RelationshipPropertyDefinition propertyDefinition = (RelationshipPropertyDefinition)definition.getValue();
                            RelationshipModelBuilder newBuilder = RelationshipModelBuilder.create((Configuration)this.configuration, (String)owner.getPackageName(), (String)type, (String)(type + "_" + propertyDefinition.getEnd().getPlainClassName().toUpperCase(Locale.ROOT)));
                            newBuilder.addProperties((Collection)propertyDefinition.getProperties());
                            if (ownerAtStartOrEnd.get(true).isEmpty()) {
                                newBuilder.setStartNode(propertyDefinition.getStart());
                                newBuilder.setEndNode(owner);
                            } else if (ownerAtStartOrEnd.get(false).isEmpty()) {
                                newBuilder.setStartNode(owner);
                                newBuilder.setEndNode(propertyDefinition.getEnd());
                            }
                            ((NodeModelBuilder)definition.getKey()).addRelationshipDefinition(propertyDefinition.withBuilder(newBuilder));
                            newBuilders.add(newBuilder);
                        }
                        result.put(type, Collections.unmodifiableList(newBuilders));
                    }
                } else if (owners.size() > 1) {
                    List startNodes = definitions.stream().map(d -> ((RelationshipPropertyDefinition)d.getValue()).getStart()).distinct().collect(Collectors.toList());
                    List endNodes = definitions.stream().map(d -> ((RelationshipPropertyDefinition)d.getValue()).getStart()).distinct().collect(Collectors.toList());
                    relationshipBuilder = RelationshipModelBuilder.create((Configuration)this.configuration, (String)((NodeModelBuilder)owners.stream().findFirst().get()).getPackageName(), (String)type);
                    if (startNodes.size() == 1) {
                        relationshipBuilder.setStartNode((NodeModelBuilder)startNodes.get(0));
                    } else if (endNodes.size() == 1) {
                        relationshipBuilder.setStartNode((NodeModelBuilder)endNodes.get(0));
                    }
                }
            }
            if (relationshipBuilder != null) {
                for (Object definition : definitions) {
                    RelationshipPropertyDefinition finishedDefinition = ((RelationshipPropertyDefinition)definition.getValue()).withBuilder(relationshipBuilder);
                    ((NodeModelBuilder)definition.getKey()).addRelationshipDefinition(finishedDefinition);
                }
                result.put(type, Collections.singletonList(relationshipBuilder));
            }
        });
        return Collections.unmodifiableMap(result);
    }

    private static boolean sameOrNoProperties(List<Map.Entry<NodeModelBuilder, RelationshipPropertyDefinition>> definitions) {
        boolean same = true;
        Set properties = null;
        for (Map.Entry<NodeModelBuilder, RelationshipPropertyDefinition> definition : definitions) {
            Set newProperties = definition.getValue().getProperties();
            if (properties == null) {
                properties = newProperties;
                continue;
            }
            if (properties.size() == newProperties.size() && properties.containsAll(newProperties)) continue;
            same = false;
            break;
        }
        return same;
    }

    private PropertyDefinition asPropertyDefinition(Element e) {
        PropertyDefinition propertyDefinition;
        Optional<Property> optionalPropertyAnnotation = Optional.ofNullable(e.getAnnotation(Property.class));
        String fieldName = e.getSimpleName().toString();
        if (optionalPropertyAnnotation.isPresent()) {
            Property propertyAnnotation = optionalPropertyAnnotation.get();
            String nameValue = propertyAnnotation.name();
            String valueValue = propertyAnnotation.value();
            if (!nameValue.isEmpty() && !valueValue.isEmpty()) {
                if (!nameValue.equals(valueValue)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Different @AliasFor mirror values for annotation [org.springframework.data.neo4j.core.schema.Property]!", e);
                }
                propertyDefinition = PropertyDefinition.create((String)nameValue, (String)fieldName);
            } else {
                propertyDefinition = !nameValue.isEmpty() ? PropertyDefinition.create((String)nameValue, (String)fieldName) : (!valueValue.isEmpty() ? PropertyDefinition.create((String)valueValue, (String)fieldName) : PropertyDefinition.create((String)fieldName, null));
            }
        } else {
            propertyDefinition = PropertyDefinition.create((String)fieldName, null);
        }
        return propertyDefinition;
    }

    private RelationshipPropertyDefinition asRelationshipDefinition(NodeModelBuilder owner, Element e, Map<TypeElement, Map.Entry<TypeElement, List<PropertyDefinition>>> relationshipProperties, Map<TypeElement, NodeModelBuilder> nodeBuilders) {
        Map.Entry<TypeElement, List<PropertyDefinition>> typeAndProperties;
        String relationshipType;
        Optional<Relationship> optionalRelationshipAnnotation = Optional.ofNullable(e.getAnnotation(Relationship.class));
        String fieldName = e.getSimpleName().toString();
        boolean isIncoming = false;
        if (optionalRelationshipAnnotation.isPresent()) {
            Relationship relationshipAnnotation = optionalRelationshipAnnotation.get();
            String typeValue = relationshipAnnotation.type();
            String valueValue = relationshipAnnotation.value();
            boolean bl = isIncoming = relationshipAnnotation.direction() == Relationship.Direction.INCOMING;
            if (!typeValue.isEmpty() && !valueValue.isEmpty()) {
                if (!typeValue.equals(valueValue)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Different @AliasFor mirror values for annotation [org.springframework.data.neo4j.core.schema.Relationship]!", e);
                }
                relationshipType = typeValue;
            } else {
                relationshipType = !typeValue.isEmpty() ? typeValue : (!valueValue.isEmpty() ? valueValue : fieldName);
            }
        } else {
            relationshipType = fieldName;
        }
        DeclaredType declaredType = e.asType().accept(new SimpleTypeVisitor8<DeclaredType, Void>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void unused) {
                return t;
            }
        }, null);
        if (declaredType == null) {
            return null;
        }
        TypeMirror relatedType = null;
        if (declaredType.getTypeArguments().size() == 1) {
            relatedType = declaredType.getTypeArguments().get(0);
        } else if (declaredType.getTypeArguments().isEmpty()) {
            relatedType = declaredType;
        }
        Element key = this.typeUtils.asElement(relatedType);
        NodeModelBuilder end = key == null ? null : nodeBuilders.get(key);
        List<PropertyDefinition> properties = null;
        String optionalPropertyHolder = null;
        if (key == null) {
            return null;
        }
        if (end == null && (typeAndProperties = relationshipProperties.get(key)) != null) {
            optionalPropertyHolder = key.toString();
            end = nodeBuilders.get(typeAndProperties.getKey());
            properties = typeAndProperties.getValue();
        }
        if (end == null) {
            return null;
        }
        if (isIncoming) {
            return RelationshipPropertyDefinition.create((String)relationshipType, (String)optionalPropertyHolder, (String)fieldName, (NodeModelBuilder)end, (NodeModelBuilder)owner, properties);
        }
        return RelationshipPropertyDefinition.create((String)relationshipType, (String)optionalPropertyHolder, (String)fieldName, (NodeModelBuilder)owner, (NodeModelBuilder)end, properties);
    }

    static {
        SDN6AnnotationProcessor.disableSpringConverterDebugLog();
    }

    private static class TypeElementNameFunction
    implements Function<TypeElement, String> {
        private TypeElementNameFunction() {
        }

        @Override
        public String apply(TypeElement typeElement) {
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind.isNested()) {
                return (String)typeElement.getEnclosingElement().accept(new TypeElementVisitor<String>(this), null) + "$" + typeElement.getSimpleName();
            }
            return typeElement.getQualifiedName().toString();
        }
    }

    class GroupPropertiesAndRelationships
    extends ElementKindVisitor8<Map<FieldType, List<VariableElement>>, Void> {
        private final Map<FieldType, List<VariableElement>> result;

        GroupPropertiesAndRelationships() {
            HashMap hlp = new HashMap(2);
            hlp.put(FieldType.R, new ArrayList());
            hlp.put(FieldType.P, new ArrayList());
            this.result = Collections.unmodifiableMap(hlp);
        }

        void apply(Element element) {
            element.accept(this, null);
        }

        Map<FieldType, List<VariableElement>> getResult() {
            return this.result;
        }

        @Override
        public Map<FieldType, List<VariableElement>> visitVariableAsField(VariableElement e, Void unused) {
            Set<Element> declaredAnnotations = e.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map(DeclaredType::asElement).collect(Collectors.toSet());
            if (this.isInternalId(e, declaredAnnotations)) {
                return this.result;
            }
            this.result.get((Object)(this.isAssociation(declaredAnnotations, e) ? FieldType.R : FieldType.P)).add(e);
            return this.result;
        }

        private boolean isInternalId(VariableElement e, Set<Element> declaredAnnotations) {
            boolean idAnnotationPresent;
            boolean bl = idAnnotationPresent = declaredAnnotations.contains(SDN6AnnotationProcessor.this.sdcIdAnnotationType) || declaredAnnotations.contains(SDN6AnnotationProcessor.this.sdnIdAnnotationType);
            if (!idAnnotationPresent) {
                return false;
            }
            return e.getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().asElement().equals(SDN6AnnotationProcessor.this.generatedValueAnnotationType)).findFirst().map(generatedValue -> this.isUsingInternalIdGenerator(e, (AnnotationMirror)generatedValue)).orElse(false);
        }

        private boolean isUsingInternalIdGenerator(VariableElement e, AnnotationMirror generatedValue) {
            Map<String, AnnotationValue> values = generatedValue.getElementValues().entrySet().stream().collect(Collectors.toMap(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString(), Map.Entry::getValue));
            DeclaredType generatorClassValue = values.containsKey("generatorClass") ? (DeclaredType)values.get("generatorClass").getValue() : null;
            DeclaredType valueValue = values.containsKey("value") ? (DeclaredType)values.get("value").getValue() : null;
            String name = null;
            if (generatorClassValue != null && valueValue != null && !generatorClassValue.equals(valueValue)) {
                SDN6AnnotationProcessor.this.messager.printMessage(Diagnostic.Kind.ERROR, "Different @AliasFor mirror values for annotation [org.springframework.data.neo4j.core.schema.GeneratedValue]!", e);
            } else if (generatorClassValue != null) {
                name = generatorClassValue.toString();
            } else if (valueValue != null) {
                name = valueValue.toString();
            }
            return name == null || "org.springframework.data.neo4j.core.schema.GeneratedValue.InternalIdGenerator".equals(name);
        }

        private boolean isAssociation(Set<Element> declaredAnnotations, VariableElement field) {
            TypeMirror typeMirrorOfField = field.asType();
            boolean explicitRelationship = declaredAnnotations.contains(SDN6AnnotationProcessor.this.relationshipAnnotationType);
            boolean isTargetNodeOrComposite = declaredAnnotations.contains(SDN6AnnotationProcessor.this.targetNodeAnnotationType) || declaredAnnotations.contains(SDN6AnnotationProcessor.this.compositePropertyAnnotationType);
            BooleanSupplier simpleTypeOrCustomWriteTarget = () -> {
                try {
                    String className = typeMirrorOfField.accept(new SimpleTypeVisitor8<String, Void>(){

                        @Override
                        public String visitPrimitive(PrimitiveType t, Void unused) {
                            return SDN6AnnotationProcessor.this.typeUtils.boxedClass(t).getQualifiedName().toString();
                        }

                        @Override
                        public String visitDeclared(DeclaredType t, Void unused) {
                            return (String)t.asElement().accept(new TypeElementVisitor<String>(new TypeElementNameFunction()), null);
                        }
                    }, null);
                    Class<?> fieldType = Class.forName(className);
                    return Neo4jSimpleTypes.HOLDER.isSimpleType(fieldType) || SDN6AnnotationProcessor.this.conversions.hasCustomWriteTarget(fieldType);
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            };
            if (explicitRelationship) {
                return true;
            }
            if (this.describesEnum(typeMirrorOfField)) {
                return false;
            }
            return !isTargetNodeOrComposite && !declaredAnnotations.contains(SDN6AnnotationProcessor.this.convertWithAnnotationType) && !simpleTypeOrCustomWriteTarget.getAsBoolean();
        }

        private boolean describesEnum(TypeMirror typeMirror) {
            List<? extends TypeMirror> superTypes = SDN6AnnotationProcessor.this.typeUtils.directSupertypes(typeMirror);
            if (superTypes.size() != 1 || !superTypes.get(0).getKind().equals((Object)TypeKind.DECLARED)) {
                return false;
            }
            TypeMirror tm = superTypes.get(0);
            String name = (String)((DeclaredType)tm).asElement().accept(new TypeElementVisitor<String>(new TypeElementNameFunction()), null);
            return Enum.class.getName().equals(name);
        }
    }

    private static enum FieldType {
        P,
        R;

    }
}

