/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorBreakTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorContinueTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.OnErrorFailTxPipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TransactionPipeWrapper;
import org.neo4j.exceptions.InternalException;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.logging.InternalLog;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.java8.JFunction1;

public final class TransactionPipeWrapper$ {
    public static final TransactionPipeWrapper$ MODULE$ = new TransactionPipeWrapper$();

    public TransactionPipeWrapper apply(SubqueryCall.InTransactionsOnErrorBehaviour error, int outerId, Pipe inner, boolean concurrentAccess) {
        boolean bl = false;
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour = null;
        SubqueryCall.InTransactionsOnErrorBehaviour inTransactionsOnErrorBehaviour2 = error;
        if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorContinue$.MODULE$.equals(inTransactionsOnErrorBehaviour2)) {
            return new OnErrorContinueTxPipe(outerId, inner, concurrentAccess);
        }
        if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorBreak$.MODULE$.equals(inTransactionsOnErrorBehaviour2)) {
            return new OnErrorBreakTxPipe(outerId, inner, concurrentAccess);
        }
        if (SubqueryCall.InTransactionsOnErrorBehaviour$.OnErrorFail$.MODULE$.equals(inTransactionsOnErrorBehaviour2)) {
            bl = true;
            inTransactionsOnErrorBehaviour = inTransactionsOnErrorBehaviour2;
            if (concurrentAccess) {
                return new OnErrorBreakTxPipe(outerId, inner, concurrentAccess);
            }
        }
        if (bl) {
            return new OnErrorFailTxPipe(outerId, inner, concurrentAccess);
        }
        throw new UnsupportedOperationException("Unsupported error behaviour " + inTransactionsOnErrorBehaviour2);
    }

    public long evaluateBatchSize(Expression batchSize, QueryState state) {
        return PipeHelper$.MODULE$.evaluateStaticLongOrThrow(batchSize, (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 > 0L, state, "OF ... ROWS", " Must be a positive integer.");
    }

    public long evaluateConcurrency(Option<Expression> concurrency, QueryState state) {
        int effectiveConcurrency;
        block4: {
            long l;
            Option<Expression> option = concurrency;
            if (option instanceof Some) {
                Some some = (Some)option;
                Expression c = (Expression)some.value();
                l = PipeHelper$.MODULE$.evaluateStaticLongOrThrow(c, (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)x$4 -> true, state, "IN ... CONCURRENT TRANSACTIONS", "");
            } else if (None$.MODULE$.equals(option)) {
                l = 0L;
            } else {
                throw new MatchError(option);
            }
            long concurrencyLong = l;
            int numberOfProcessors = Runtime.getRuntime().availableProcessors();
            int maxConcurrency = numberOfProcessors * 20;
            effectiveConcurrency = (int)MathUtil.clamp((long)concurrencyLong, (long)Integer.MIN_VALUE, (long)maxConcurrency);
            if (effectiveConcurrency > 0) break block4;
            effectiveConcurrency = Math.max(numberOfProcessors + effectiveConcurrency, 1);
        }
        return effectiveConcurrency;
    }

    public void assertTransactionStateIsEmpty(QueryState state) {
        if (state.query().transactionalContext().dataRead().transactionStateHasChanges()) {
            throw new InternalException("Expected transaction state to be empty when calling transactional subquery.");
        }
    }

    public void org$neo4j$cypher$internal$runtime$interpreted$pipes$TransactionPipeWrapper$$logError(QueryState state, String innerTxId, Throwable t) {
        String outerTxId = state.query().transactionalContext().userTransactionId();
        InternalLog log = state.query().logProvider().getLog(this.getClass());
        log.info("Recover error in inner transaction " + innerTxId + " (outer transaction " + outerTxId + ")", t);
    }

    private TransactionPipeWrapper$() {
    }
}

