/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.NodeKeyConstraints$;
import org.neo4j.cypher.internal.ast.NodeLabelExistenceConstraints$;
import org.neo4j.cypher.internal.ast.NodePropExistsConstraints;
import org.neo4j.cypher.internal.ast.NodePropExistsConstraints$;
import org.neo4j.cypher.internal.ast.NodePropTypeConstraints$;
import org.neo4j.cypher.internal.ast.NodeUniqueConstraints;
import org.neo4j.cypher.internal.ast.NodeUniqueConstraints$;
import org.neo4j.cypher.internal.ast.RelKeyConstraints$;
import org.neo4j.cypher.internal.ast.RelPropExistsConstraints;
import org.neo4j.cypher.internal.ast.RelPropExistsConstraints$;
import org.neo4j.cypher.internal.ast.RelPropTypeConstraints$;
import org.neo4j.cypher.internal.ast.RelUniqueConstraints;
import org.neo4j.cypher.internal.ast.RelUniqueConstraints$;
import org.neo4j.cypher.internal.ast.RelationshipSourceLabelConstraints$;
import org.neo4j.cypher.internal.ast.RelationshipTargetLabelConstraints$;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.ast.ShowConstraintType;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowConstraintsCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowSchemaCommandHelper$;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.GraphTypeDependence;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;

public final class ShowConstraintsCommand$
implements Serializable {
    public static final ShowConstraintsCommand$ MODULE$ = new ShowConstraintsCommand$();

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement(String name, ShowConstraintType constraintType, List<String> labelsOrTypes, List<String> properties, Option<String> propertyType, GraphTypeDependence graphTypeDependence, boolean returnCypher5Values) {
        if (graphTypeDependence.equals((Object)GraphTypeDependence.DEPENDENT)) {
            return null;
        }
        ShowConstraintType showConstraintType = constraintType;
        if (showConstraintType instanceof NodeUniqueConstraints) {
            return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS UNIQUE");
        }
        if (showConstraintType instanceof RelUniqueConstraints) {
            return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS UNIQUE");
        }
        if (NodeKeyConstraints$.MODULE$.equals(showConstraintType)) {
            String predicate = returnCypher5Values ? "IS NODE KEY" : "IS KEY";
            return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, predicate);
        }
        if (RelKeyConstraints$.MODULE$.equals(showConstraintType)) {
            String predicate = returnCypher5Values ? "IS RELATIONSHIP KEY" : "IS KEY";
            return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, predicate);
        }
        if (showConstraintType instanceof NodePropExistsConstraints) {
            return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS NOT NULL");
        }
        if (showConstraintType instanceof RelPropExistsConstraints) {
            return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS NOT NULL");
        }
        if (NodePropTypeConstraints$.MODULE$.equals(showConstraintType)) {
            String typeString = (String)propertyType.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Expected a property type for " + constraintType + " constraint.");
            });
            return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS :: " + typeString);
        }
        if (RelPropTypeConstraints$.MODULE$.equals(showConstraintType)) {
            String typeString = (String)propertyType.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Expected a property type for " + constraintType + " constraint.");
            });
            return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS :: " + typeString);
        }
        if (RelationshipSourceLabelConstraints$.MODULE$.equals(showConstraintType)) {
            return null;
        }
        if (RelationshipTargetLabelConstraints$.MODULE$.equals(showConstraintType)) {
            return null;
        }
        if (NodeLabelExistenceConstraints$.MODULE$.equals(showConstraintType)) {
            return null;
        }
        throw new IllegalArgumentException("Did not expect constraint type " + constraintType.prettyPrint() + " for constraint create command.");
    }

    public ShowConstraintType org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$getConstraintType(ConstraintType internalConstraintType, EntityType entityType, Option<EndpointType> endpointType, boolean returnCypher5Values) {
        Tuple2 tuple2 = new Tuple2((Object)internalConstraintType, (Object)entityType);
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType2 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE.equals(constraintType) && EntityType.NODE.equals(entityType2)) {
                if (returnCypher5Values) {
                    return NodeUniqueConstraints$.MODULE$.cypher5();
                }
                return NodeUniqueConstraints$.MODULE$.cypher25();
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType3 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType3)) {
                if (returnCypher5Values) {
                    return RelUniqueConstraints$.MODULE$.cypher5();
                }
                return RelUniqueConstraints$.MODULE$.cypher25();
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType4 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE_EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType4)) {
                return NodeKeyConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType5 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE_EXISTS.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType5)) {
                return RelKeyConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType6 = (EntityType)tuple2._2();
            if (ConstraintType.EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType6)) {
                if (returnCypher5Values) {
                    return NodePropExistsConstraints$.MODULE$.cypher5();
                }
                return NodePropExistsConstraints$.MODULE$.cypher25();
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType7 = (EntityType)tuple2._2();
            if (ConstraintType.EXISTS.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType7)) {
                if (returnCypher5Values) {
                    return RelPropExistsConstraints$.MODULE$.cypher5();
                }
                return RelPropExistsConstraints$.MODULE$.cypher25();
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType8 = (EntityType)tuple2._2();
            if (ConstraintType.PROPERTY_TYPE.equals(constraintType) && EntityType.NODE.equals(entityType8)) {
                return NodePropTypeConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType9 = (EntityType)tuple2._2();
            if (ConstraintType.PROPERTY_TYPE.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType9)) {
                return RelPropTypeConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType10 = (EntityType)tuple2._2();
            if (ConstraintType.RELATIONSHIP_ENDPOINT_LABEL.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType10) && endpointType.isDefined()) {
                EndpointType endpointType2 = (EndpointType)endpointType.get();
                if (EndpointType.START.equals(endpointType2)) {
                    return RelationshipSourceLabelConstraints$.MODULE$;
                }
                if (EndpointType.END.equals(endpointType2)) {
                    return RelationshipTargetLabelConstraints$.MODULE$;
                }
                throw new MatchError((Object)endpointType2);
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType11 = (EntityType)tuple2._2();
            if (ConstraintType.NODE_LABEL_EXISTENCE.equals(constraintType) && EntityType.NODE.equals(entityType11)) {
                return NodeLabelExistenceConstraints$.MODULE$;
            }
        }
        throw new IllegalStateException("Invalid constraint combination: ConstraintType " + internalConstraintType + ", EntityType " + entityType + " and EndpointType " + endpointType + ".");
    }

    public ShowConstraintsCommand apply(ShowConstraintType constraintType, List<ShowColumn> columns, List<CommandResultItem> yieldColumns, CypherVersion cypherVersion) {
        return new ShowConstraintsCommand(constraintType, columns, yieldColumns, cypherVersion);
    }

    public Option<Tuple4<ShowConstraintType, List<ShowColumn>, List<CommandResultItem>, CypherVersion>> unapply(ShowConstraintsCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.constraintType(), x$0.columns(), x$0.yieldColumns(), (Object)x$0.cypherVersion()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShowConstraintsCommand$.class);
    }

    private ShowConstraintsCommand$() {
    }
}

