/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ir.v3_3;

import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.ir.v3_3.Cardinality;
import org.neo4j.cypher.internal.ir.v3_3.Cardinality$;
import org.neo4j.cypher.internal.ir.v3_3.Selectivity;
import org.neo4j.cypher.internal.ir.v3_3.Selectivity$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y1A!\u0001\u0002\u0001\u001f\ty1+\u001a7fGRLg/\u001b;z)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!aoM04\u0015\t)a!\u0001\u0002je*\u0011q\u0001C\u0001\tS:$XM\u001d8bY*\u0011\u0011BC\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005-a\u0011!\u00028f_RR'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0018\u001b\u0005\u0011\"BA\n\u0015\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t\u0019QC\u0003\u0002\u0017\r\u0005AaM]8oi\u0016tG-\u0003\u0002\u0019%\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u0003\u0001")
public class SelectivityTest
extends CypherFunSuite {
    public SelectivityTest() {
        this.test("negating a selectivity behaves as expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(((Selectivity)Selectivity$.MODULE$.of(0.1).get()).negate()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ONE(), Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((Selectivity)Selectivity$.MODULE$.of(5.6E-17).get()).negate()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ONE(), Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((Selectivity)Selectivity$.MODULE$.of(1.0E-300).get()).negate()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ONE(), Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.ZERO().negate()).should(this.$outer.equal(Selectivity$.MODULE$.ONE()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.ZERO().negate()).should(this.$outer.equal(Selectivity$.MODULE$.ONE()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.ONE().negate()).should(this.$outer.equal(Selectivity$.MODULE$.ZERO()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.ONE().negate()).should(this.$outer.equal(Selectivity$.MODULE$.ZERO()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.CLOSEST_TO_ONE().negate()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ONE(), Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("selectivity and cardinality should not be able to produce NaN or Infinity through multiplication", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(new Cardinality(Double.POSITIVE_INFINITY).$times(Selectivity$.MODULE$.ZERO())).should(this.$outer.equal(Cardinality$.MODULE$.EMPTY()), (Object)Equality$.MODULE$.default());
                Cardinality maxCardinality = new Cardinality(Double.MAX_VALUE);
                this.$outer.convertToAnyShouldWrapper(new Cardinality(Double.POSITIVE_INFINITY).$times(Cardinality$.MODULE$.SINGLE())).should(this.$outer.equal(maxCardinality), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(new Cardinality(Double.POSITIVE_INFINITY).$times(new Cardinality(12.0))).should(this.$outer.equal(maxCardinality), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(maxCardinality.$times(new Cardinality(1.00001))).should(this.$outer.equal(maxCardinality), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(new Cardinality(3223143.0).$up(50)).should(this.$outer.equal(maxCardinality), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

