/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.expressions.UnPositionedVariable$;
import org.neo4j.cypher.internal.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.logical.plans.Apply;
import org.neo4j.cypher.internal.logical.plans.CartesianProduct;
import org.neo4j.cypher.internal.logical.plans.IndexOrder;
import org.neo4j.cypher.internal.logical.plans.IndexOrderNone$;
import org.neo4j.cypher.internal.logical.plans.Limit;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.LogicalPlanTreeRenderer$;
import org.neo4j.cypher.internal.logical.plans.NodeByLabelScan;
import org.neo4j.cypher.internal.logical.plans.ProduceResult;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.attribution.IdGen;
import org.neo4j.cypher.internal.util.attribution.SameId;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.cypher.internal.util.test_helpers.WindowsStringSafe$;
import org.scalactic.Equality;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00153Aa\u0002\u0005\u0001+!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0007\u0019\u0003B\u0002\u0016\u0001A\u0003%A\u0005C\u0004,\u0001\t\u0007I1\u0001\u0017\t\rA\u0002\u0001\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0005maunZ5dC2\u0004F.\u00198Ue\u0016,'+\u001a8eKJ,'\u000fV3ti*\u0011\u0011BC\u0001\u0006a2\fgn\u001d\u0006\u0003\u00171\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u000e\u001d\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0010!\u000511-\u001f9iKJT!!\u0005\n\u0002\u000b9,w\u000e\u000e6\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u000e\r\u0003\u0011)H/\u001b7\n\u0005uA\"AD\"za\",'OR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003!\tQ!\u001b3HK:,\u0012\u0001\n\t\u0003K!j\u0011A\n\u0006\u0003Oi\t1\"\u0019;ue&\u0014W\u000f^5p]&\u0011\u0011F\n\u0002\u0007'\u0006lW-\u00133\u0002\r%$w)\u001a8!\u0003-9\u0018N\u001c3poN\u001c\u0016MZ3\u0016\u00035r!a\u0006\u0018\n\u0005=B\u0012!E,j]\u0012|wo]*ue&twmU1gK\u0006aq/\u001b8e_^\u001c8+\u00194fA\u00051!/\u001a8eKJ$\"a\r!\u0011\u0005QjdBA\u001b<!\t1\u0014(D\u00018\u0015\tAD#\u0001\u0004=e>|GO\u0010\u0006\u0002u\u0005)1oY1mC&\u0011A(O\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=s!)\u0011I\u0002a\u0001\u0005\u0006!\u0001\u000f\\1o!\t\t3)\u0003\u0002E\u0011\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0001")
public class LogicalPlanTreeRendererTest
extends CypherFunSuite {
    private final SameId idGen = new SameId(0);
    private final WindowsStringSafe$ windowsSafe = WindowsStringSafe$.MODULE$;

    public SameId idGen() {
        return this.idGen;
    }

    public WindowsStringSafe$ windowsSafe() {
        return this.windowsSafe;
    }

    public String render(LogicalPlan plan) {
        return LogicalPlanTreeRenderer$.MODULE$.render(plan, "| ", (Function1 & Serializable)x$1 -> x$1.productPrefix());
    }

    public LogicalPlanTreeRendererTest() {
        this.test("Should render plan with depth 0", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ProduceResult plan = new ProduceResult((LogicalPlan)new Limit((LogicalPlan)new AllNodesScan((LogicalVariable)UnPositionedVariable$.MODULE$.varFor("n"), Predef$.MODULE$.Set().empty(), (IdGen)this.idGen()), (Expression)new SignedDecimalIntegerLiteral("10", InputPosition$.MODULE$.NONE()), (IdGen)this.idGen()), (Seq)package$.MODULE$.Seq().empty(), (IdGen)this.idGen());
            return this.convertToStringShouldWrapper(this.render((LogicalPlan)plan), new Position("LogicalPlanTreeRendererTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45), Prettifier$.MODULE$.default()).shouldEqual((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("ProduceResult\n        #Limit\n        #AllNodesScan"), '#'), (Equality)this.windowsSafe());
        }, new Position("LogicalPlanTreeRendererTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("Should render plan with depth 1", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ProduceResult plan = new ProduceResult((LogicalPlan)new CartesianProduct((LogicalPlan)new AllNodesScan((LogicalVariable)UnPositionedVariable$.MODULE$.varFor("n"), Predef$.MODULE$.Set().empty(), (IdGen)this.idGen()), (LogicalPlan)new AllNodesScan((LogicalVariable)UnPositionedVariable$.MODULE$.varFor("m"), Predef$.MODULE$.Set().empty(), (IdGen)this.idGen()), (IdGen)this.idGen()), (Seq)package$.MODULE$.Seq().empty(), (IdGen)this.idGen());
            return this.convertToStringShouldWrapper(this.render((LogicalPlan)plan), new Position("LogicalPlanTreeRendererTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60), Prettifier$.MODULE$.default()).shouldEqual((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("ProduceResult\n        #CartesianProduct\n        #| AllNodesScan\n        #AllNodesScan"), '#'), (Equality)this.windowsSafe());
        }, new Position("LogicalPlanTreeRendererTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("Should render complex plan with depth >1", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CartesianProduct cp = new CartesianProduct((LogicalPlan)new AllNodesScan((LogicalVariable)UnPositionedVariable$.MODULE$.varFor("n"), Predef$.MODULE$.Set().empty(), (IdGen)this.idGen()), (LogicalPlan)new AllNodesScan((LogicalVariable)UnPositionedVariable$.MODULE$.varFor("m"), Predef$.MODULE$.Set().empty(), (IdGen)this.idGen()), (IdGen)this.idGen());
            Apply innerApply = new Apply((LogicalPlan)cp, (LogicalPlan)cp, (IdGen)this.idGen());
            ProduceResult plan = new ProduceResult((LogicalPlan)new Apply((LogicalPlan)new Limit((LogicalPlan)new Apply((LogicalPlan)new NodeByLabelScan((LogicalVariable)UnPositionedVariable$.MODULE$.varFor("x"), new LabelName("X", InputPosition$.MODULE$.NONE()), Predef$.MODULE$.Set().empty(), (IndexOrder)IndexOrderNone$.MODULE$, (IdGen)this.idGen()), (LogicalPlan)innerApply, (IdGen)this.idGen()), (Expression)new SignedDecimalIntegerLiteral("10", InputPosition$.MODULE$.NONE()), (IdGen)this.idGen()), (LogicalPlan)cp, (IdGen)this.idGen()), (Seq)new .colon.colon((Object)UnPositionedVariable$.MODULE$.varFor("n"), (List)Nil$.MODULE$), (IdGen)this.idGen());
            return this.convertToStringShouldWrapper(this.render((LogicalPlan)plan), new Position("LogicalPlanTreeRendererTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92), Prettifier$.MODULE$.default()).shouldEqual((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("ProduceResult\n        #Apply\n        #| CartesianProduct\n        #| | AllNodesScan\n        #| AllNodesScan\n        #Limit\n        #Apply\n        #| Apply\n        #| | CartesianProduct\n        #| | | AllNodesScan\n        #| | AllNodesScan\n        #| CartesianProduct\n        #| | AllNodesScan\n        #| AllNodesScan\n        #NodeByLabelScan"), '#'), (Equality)this.windowsSafe());
        }, new Position("LogicalPlanTreeRendererTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }
}

