/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.io.Serializable;
import org.neo4j.cypher.internal.logical.plans.NameValidator$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.exceptions.InvalidArgumentException;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005u1AAA\u0002\u0001!!)\u0011\u0004\u0001C\u00015\t\tb*Y7f-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005\u0011)\u0011!\u00029mC:\u001c(B\u0001\u0004\b\u0003\u001dawnZ5dC2T!\u0001C\u0005\u0002\u0011%tG/\u001a:oC2T!AC\u0006\u0002\r\rL\b\u000f[3s\u0015\taQ\"A\u0003oK>$$NC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013/5\t1C\u0003\u0002\u0015+\u0005aA/Z:u?\",G\u000e]3sg*\u0011acB\u0001\u0005kRLG.\u0003\u0002\u0019'\tq1)\u001f9iKJ4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0004\u0001")
public class NameValidatorTest
extends CypherFunSuite {
    public NameValidatorTest() {
        this.test("Should not get an error for a valid username", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcZ.sp & Serializable)() -> NameValidator$.MODULE$.assertValidUsername("myValidUser"), new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("Should get an error for an empty username", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            try {
                NameValidator$.MODULE$.assertValidUsername("");
                throw this.fail("Expected exception \"The provided username is empty.\" but succeeded.", new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            }
            catch (InvalidArgumentException e) {
                this.convertToStringShouldWrapper(e.getMessage(), new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39), Prettifier$.MODULE$.default()).should(this.be().apply((Object)"The provided username is empty."));
                try {
                    NameValidator$.MODULE$.assertValidUsername(null);
                    throw this.fail("Expected exception \"The provided username is empty.\" but succeeded.", new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
                }
                catch (InvalidArgumentException e2) {
                    return this.convertToStringShouldWrapper(e2.getMessage(), new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47), Prettifier$.MODULE$.default()).should(this.be().apply((Object)"The provided username is empty."));
                }
            }
        }, new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("Should get an error for a username with invalid characters", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            try {
                NameValidator$.MODULE$.assertValidUsername("user:");
                throw this.fail("Expected exception \"Username 'user:' contains illegal characters.\" but succeeded.", new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            }
            catch (InvalidArgumentException e) {
                return this.convertToStringShouldWrapper(e.getMessage(), new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58), Prettifier$.MODULE$.default()).should(this.be().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Username 'user:' contains illegal characters.\n            |Use ascii characters that are not ',', ':' or whitespaces."))));
            }
        }, new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("Should not get an error for a valid role name", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcZ.sp & Serializable)() -> NameValidator$.MODULE$.assertValidRoleName("my_ValidRole"), new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("Should get an error for an empty role name", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            try {
                NameValidator$.MODULE$.assertValidRoleName("");
                throw this.fail("Expected exception \"The provided role name is empty.\" but succeeded.", new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            }
            catch (InvalidArgumentException e) {
                this.convertToStringShouldWrapper(e.getMessage(), new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77), Prettifier$.MODULE$.default()).should(this.be().apply((Object)"The provided role name is empty."));
                try {
                    NameValidator$.MODULE$.assertValidRoleName(null);
                    throw this.fail("Expected exception \"The provided role name is empty.\" but succeeded.", new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                }
                catch (InvalidArgumentException e2) {
                    return this.convertToStringShouldWrapper(e2.getMessage(), new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85), Prettifier$.MODULE$.default()).should(this.be().apply((Object)"The provided role name is empty."));
                }
            }
        }, new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("Should get an error for a role name with invalid characters", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            try {
                NameValidator$.MODULE$.assertValidRoleName("role%");
                throw this.fail("Expected exception \"Role name 'role%' contains illegal characters.\" but succeeded.", new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            }
            catch (InvalidArgumentException e) {
                return this.convertToStringShouldWrapper(e.getMessage(), new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96), Prettifier$.MODULE$.default()).should(this.be().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Role name 'role%' contains illegal characters.\n            |Use simple ascii characters, numbers and underscores."))));
            }
        }, new Position("NameValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
    }
}

