/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.io.Serializable;
import org.neo4j.cypher.internal.logical.plans.RemoteUrlValidator$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.messages.MessageUtil;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.enablers.Messaging$;
import org.scalatest.matchers.TypeMatcherHelper$;
import org.scalatest.matchers.should.Matchers;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00014A\u0001E\t\u0001=!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00047\u0001\t\u0007I\u0011A\u001c\t\r\t\u0003\u0001\u0015!\u00039\u0011\u001d\u0019\u0005A1A\u0005\u0002]Ba\u0001\u0012\u0001!\u0002\u0013A\u0004bB#\u0001\u0005\u0004%\ta\u000e\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001d\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\"11\f\u0001Q\u0001\n%Cq\u0001\u0018\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004^\u0001\u0001\u0006I!\u0013\u0005\b=\u0002\u0011\r\u0011\"\u0001-\u0011\u0019y\u0006\u0001)A\u0005[\t1\"+Z7pi\u0016,&\u000f\u001c,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002\u0013'\u0005)\u0001\u000f\\1og*\u0011A#F\u0001\bY><\u0017nY1m\u0015\t1r#\u0001\u0005j]R,'O\\1m\u0015\tA\u0012$\u0001\u0004dsBDWM\u001d\u0006\u00035m\tQA\\3pi)T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u0011*\u0012\u0001B;uS2L!AJ\u0011\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011!E\u0001\u0004kJdW#A\u0017\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014\u0001\u00027b]\u001eT\u0011AM\u0001\u0005U\u00064\u0018-\u0003\u00025_\t11\u000b\u001e:j]\u001e\fA!\u001e:mA\u0005yQO\\:fGV\u0014XmU2iK6,7/F\u00019!\rI\u0004)L\u0007\u0002u)\u00111\bP\u0001\nS6lW\u000f^1cY\u0016T!!\u0010 \u0002\u0015\r|G\u000e\\3di&|gNC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\t%HA\u0002TKF\f\u0001#\u001e8tK\u000e,(/Z*dQ\u0016lWm\u001d\u0011\u0002\u001bM,7-\u001e:f'\u000eDW-\\3t\u00039\u0019XmY;sKN\u001b\u0007.Z7fg\u0002\nAB^1mS\u0012\u001c6\r[3nKN\fQB^1mS\u0012\u001c6\r[3nKN\u0004\u0013AC:fGV\u0014X-\u0016:mgV\t\u0011\nE\u0002K%Rs!a\u0013)\u000f\u00051{U\"A'\u000b\u00059k\u0012A\u0002\u001fs_>$h(C\u0001@\u0013\t\tf(A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u001b&BA)?!\t)\u0016L\u0004\u0002W/B\u0011AJP\u0005\u00031z\na\u0001\u0015:fI\u00164\u0017B\u0001\u001b[\u0015\tAf(A\u0006tK\u000e,(/Z+sYN\u0004\u0013\u0001D5og\u0016\u001cWO]3Ve2\u001c\u0018!D5og\u0016\u001cWO]3Ve2\u001c\b%A\u0006o_N\u001b\u0007.Z7f+Jd\u0017\u0001\u00048p'\u000eDW-\\3Ve2\u0004\u0003")
public class RemoteUrlValidatorTest
extends CypherFunSuite {
    private final String url;
    private final Seq<String> unsecureSchemes = new .colon.colon((Object)"neo4j", (List)Nil$.MODULE$);
    private final Seq<String> secureSchemes = new .colon.colon((Object)"neo4j+s", (List)new .colon.colon((Object)"neo4j+ssc", (List)Nil$.MODULE$));
    private final Seq<String> validSchemes = new .colon.colon((Object)"neo4j", (List)new .colon.colon((Object)"neo4j+s", (List)new .colon.colon((Object)"neo4j+ssc", (List)Nil$.MODULE$)));
    private final Seq<String> secureUrls = (Seq)this.secureSchemes().map((Function1 & Serializable)x$1 -> x$1 + this.url());
    private final Seq<String> insecureUrls = (Seq)this.unsecureSchemes().map((Function1 & Serializable)x$2 -> x$2 + this.url());
    private final String noSchemeUrl;

    public String url() {
        return this.url;
    }

    public Seq<String> unsecureSchemes() {
        return this.unsecureSchemes;
    }

    public Seq<String> secureSchemes() {
        return this.secureSchemes;
    }

    public Seq<String> validSchemes() {
        return this.validSchemes;
    }

    public Seq<String> secureUrls() {
        return this.secureUrls;
    }

    public Seq<String> insecureUrls() {
        return this.insecureUrls;
    }

    public String noSchemeUrl() {
        return this.noSchemeUrl;
    }

    public static final /* synthetic */ void $anonfun$new$8(RemoteUrlValidatorTest $this, String url) {
        $this.test("validator should throw exception for invalid url '" + url + "' with insecure schemes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Throwable exception = (Throwable)RemoteUrlValidator$.MODULE$.assertValidRemoteDatabaseUrl(url, true).getOrElse((Function0 & Serializable)() -> $this.fail(new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61)));
            Matchers.AnyShouldWrapper $org_scalatest_type_matcher_macro_left = $this.convertToAnyShouldWrapper(exception, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62), Prettifier$.MODULE$.default());
            TypeMatcherHelper$.MODULE$.assertAType($org_scalatest_type_matcher_macro_left.leftSideValue(), $this.a(ClassTag$.MODULE$.apply(InvalidArgumentException.class)), $org_scalatest_type_matcher_macro_left.prettifier(), $org_scalatest_type_matcher_macro_left.pos());
            return $this.convertToAnyShouldWrapper(exception, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63), Prettifier$.MODULE$.default()).should($this.have()).message(MessageUtil.invalidScheme((String)url, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava($this.validSchemes()).asJava()), Messaging$.MODULE$.messagingNatureOfThrowable());
        }, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        $this.test("validator should throw exception for invalid url '" + url + "' with insecure schemes and no security requirement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Throwable exception = (Throwable)RemoteUrlValidator$.MODULE$.assertValidRemoteDatabaseUrl(url, false).getOrElse((Function0 & Serializable)() -> $this.fail(new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69)));
            Matchers.AnyShouldWrapper $org_scalatest_type_matcher_macro_left = $this.convertToAnyShouldWrapper(exception, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70), Prettifier$.MODULE$.default());
            TypeMatcherHelper$.MODULE$.assertAType($org_scalatest_type_matcher_macro_left.leftSideValue(), $this.a(ClassTag$.MODULE$.apply(InvalidArgumentException.class)), $org_scalatest_type_matcher_macro_left.prettifier(), $org_scalatest_type_matcher_macro_left.pos());
            return $this.convertToAnyShouldWrapper(exception, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71), Prettifier$.MODULE$.default()).should($this.have()).message(MessageUtil.invalidScheme((String)url, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava($this.validSchemes()).asJava()), Messaging$.MODULE$.messagingNatureOfThrowable());
        }, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
    }

    public RemoteUrlValidatorTest() {
        this.url = "://localhost";
        this.noSchemeUrl = "localhost";
        this.insecureUrls().foreach((Function1 & Serializable)url -> {
            this.test("validator should throw exception for url '" + url + "' with insecure schemes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Throwable exception = (Throwable)RemoteUrlValidator$.MODULE$.assertValidRemoteDatabaseUrl(url, true).getOrElse((Function0 & Serializable)() -> $this.fail(new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40)));
                Matchers.AnyShouldWrapper $org_scalatest_type_matcher_macro_left = $this.convertToAnyShouldWrapper(exception, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41), Prettifier$.MODULE$.default());
                TypeMatcherHelper$.MODULE$.assertAType($org_scalatest_type_matcher_macro_left.leftSideValue(), $this.a(ClassTag$.MODULE$.apply(InvalidArgumentException.class)), $org_scalatest_type_matcher_macro_left.prettifier(), $org_scalatest_type_matcher_macro_left.pos());
                return $this.convertToAnyShouldWrapper(exception, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42), Prettifier$.MODULE$.default()).should($this.have()).message(MessageUtil.insecureScheme((String)url, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava($this.secureSchemes()).asJava()), Messaging$.MODULE$.messagingNatureOfThrowable());
            }, new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            return BoxedUnit.UNIT;
        });
        this.secureUrls().foreach((Function1 & Serializable)url -> {
            this.test("validator should return no exception for url '" + url + "' with secure schemes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> $this.convertToAnyShouldWrapper(RemoteUrlValidator$.MODULE$.assertValidRemoteDatabaseUrl(url, true), new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$), new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.insecureUrls().$plus$plus(this.secureUrls())).foreach((Function1 & Serializable)url -> {
            this.test("validator should return no exception for url '" + url + "' with no security requirement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> $this.convertToAnyShouldWrapper(RemoteUrlValidator$.MODULE$.assertValidRemoteDatabaseUrl(url, false), new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$), new Position("RemoteUrlValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)("http" + this.url()), (List)new .colon.colon((Object)("https" + this.url()), (List)new .colon.colon((Object)this.noSchemeUrl(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)url -> {
            RemoteUrlValidatorTest.$anonfun$new$8(this, url);
            return BoxedUnit.UNIT;
        });
    }
}

