/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.operations.CypherFunctions;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public class PathValueBuilder {
    private final List<NodeValue> nodes = new ArrayList<NodeValue>();
    private final List<RelationshipValue> rels = new ArrayList<RelationshipValue>();
    private final DbAccess dbAccess;
    private final RelationshipScanCursor cursor;
    private boolean seenNoValue;

    public PathValueBuilder(DbAccess dbAccess, RelationshipScanCursor cursor) {
        this.dbAccess = dbAccess;
        this.cursor = cursor;
    }

    public AnyValue build() {
        return this.seenNoValue ? Values.NO_VALUE : VirtualValues.path((NodeValue[])this.nodes.toArray(new NodeValue[0]), (RelationshipValue[])this.rels.toArray(new RelationshipValue[0]));
    }

    public void addNode(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addNode((NodeValue)value);
        }
    }

    public void addRelationship(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addRelationship((RelationshipValue)value);
        }
    }

    public void addRelationship(RelationshipValue value) {
        this.rels.add(value);
    }

    public void addNode(NodeValue nodeValue) {
        this.nodes.add(nodeValue);
    }

    public void addIncoming(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addIncoming((RelationshipValue)value);
        }
    }

    public void addIncoming(RelationshipValue relationship) {
        this.nodes.add(CypherFunctions.startNode((VirtualRelationshipValue)relationship, this.dbAccess, this.cursor));
        this.rels.add(relationship);
    }

    public void addOutgoing(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addOutgoing((RelationshipValue)value);
        }
    }

    public void addOutgoing(RelationshipValue relationship) {
        this.nodes.add(CypherFunctions.endNode((VirtualRelationshipValue)relationship, this.dbAccess, this.cursor));
        this.rels.add(relationship);
    }

    public void addUndirected(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addUndirected((RelationshipValue)value);
        }
    }

    public void addUndirected(RelationshipValue relationship) {
        long previous = this.nodes.get(this.nodes.size() - 1).id();
        if (previous == CypherFunctions.startNode((VirtualRelationshipValue)relationship, this.dbAccess, this.cursor).id()) {
            this.addOutgoing(relationship);
        } else if (previous == CypherFunctions.endNode((VirtualRelationshipValue)relationship, this.dbAccess, this.cursor).id()) {
            this.addIncoming(relationship);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void addMultipleIncoming(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleIncoming((ListValue)value, (NodeValue)target);
        }
    }

    public void addMultipleIncoming(ListValue relationships, NodeValue target) {
        int i;
        if (relationships.isEmpty()) {
            return;
        }
        for (i = 0; i < relationships.size() - 1; ++i) {
            AnyValue value = relationships.value(i);
            if (!this.notNoValue(value)) continue;
            RelationshipValue relationship = (RelationshipValue)value;
            this.nodes.add(relationship.startNode());
            this.rels.add(relationship);
        }
        AnyValue last = relationships.value(i);
        if (this.notNoValue(last)) {
            this.rels.add((RelationshipValue)last);
            this.nodes.add(target);
        }
    }

    public void addMultipleIncoming(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleIncoming((ListValue)value);
        }
    }

    public void addMultipleIncoming(ListValue relationships) {
        for (AnyValue value : relationships) {
            if (!this.notNoValue(value)) continue;
            RelationshipValue relationship = (RelationshipValue)value;
            this.nodes.add(relationship.startNode());
            this.rels.add(relationship);
        }
    }

    public void addMultipleOutgoing(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleOutgoing((ListValue)value, (NodeValue)target);
        }
    }

    public void addMultipleOutgoing(ListValue relationships, NodeValue target) {
        int i;
        if (relationships.isEmpty()) {
            return;
        }
        for (i = 0; i < relationships.size() - 1; ++i) {
            AnyValue value = relationships.value(i);
            if (!this.notNoValue(value)) continue;
            RelationshipValue relationship = (RelationshipValue)value;
            this.nodes.add(relationship.endNode());
            this.rels.add(relationship);
        }
        AnyValue last = relationships.value(i);
        if (this.notNoValue(last)) {
            this.rels.add((RelationshipValue)last);
            this.nodes.add(target);
        }
    }

    public void addMultipleOutgoing(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleOutgoing((ListValue)value);
        }
    }

    public void addMultipleOutgoing(ListValue relationships) {
        for (AnyValue value : relationships) {
            if (!this.notNoValue(value)) continue;
            RelationshipValue relationship = (RelationshipValue)value;
            this.nodes.add(relationship.endNode());
            this.rels.add(relationship);
        }
    }

    public void addMultipleUndirected(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleUndirected((ListValue)value, (NodeValue)target);
        }
    }

    public void addMultipleUndirected(ListValue relationships, NodeValue target) {
        AnyValue last;
        AnyValue value;
        int i;
        boolean correctDirection;
        if (relationships.isEmpty()) {
            return;
        }
        long previous = this.nodes.get(this.nodes.size() - 1).id();
        RelationshipValue first = (RelationshipValue)relationships.head();
        boolean bl = correctDirection = CypherFunctions.startNode((VirtualRelationshipValue)first, this.dbAccess, this.cursor).id() == previous || CypherFunctions.endNode((VirtualRelationshipValue)first, this.dbAccess, this.cursor).id() == previous;
        if (correctDirection) {
            for (i = 0; i < relationships.size() - 1; ++i) {
                value = relationships.value(i);
                if (!this.notNoValue(value)) continue;
                this.addUndirectedWhenRelationshipsAreFullyLoaded((RelationshipValue)value);
            }
        } else {
            for (i = relationships.size() - 1; i > 0; --i) {
                value = relationships.value(i);
                if (!this.notNoValue(value)) continue;
                this.addUndirectedWhenRelationshipsAreFullyLoaded((RelationshipValue)relationships.value(i));
            }
        }
        if (this.notNoValue(last = relationships.value(i))) {
            this.rels.add((RelationshipValue)last);
            this.nodes.add(target);
        }
    }

    public void addMultipleUndirected(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleUndirected((ListValue)value);
        }
    }

    public void addMultipleUndirected(ListValue relationships) {
        boolean correctDirection;
        if (relationships.isEmpty()) {
            return;
        }
        long previous = this.nodes.get(this.nodes.size() - 1).id();
        RelationshipValue first = (RelationshipValue)relationships.head();
        boolean bl = correctDirection = CypherFunctions.startNode((VirtualRelationshipValue)first, this.dbAccess, this.cursor).id() == previous || CypherFunctions.endNode((VirtualRelationshipValue)first, this.dbAccess, this.cursor).id() == previous;
        if (correctDirection) {
            for (AnyValue value : relationships) {
                if (!this.notNoValue(value)) continue;
                this.addUndirectedWhenRelationshipsAreFullyLoaded((RelationshipValue)value);
            }
        } else {
            ListValue reversed = relationships.reverse();
            for (AnyValue rel : reversed) {
                if (!this.notNoValue(rel)) continue;
                this.addUndirectedWhenRelationshipsAreFullyLoaded((RelationshipValue)rel);
            }
        }
    }

    private boolean notNoValue(AnyValue value) {
        if (!this.seenNoValue && value == Values.NO_VALUE) {
            this.seenNoValue = true;
        }
        return !this.seenNoValue;
    }

    private void addUndirectedWhenRelationshipsAreFullyLoaded(RelationshipValue relationship) {
        long previous = this.nodes.get(this.nodes.size() - 1).id();
        if (previous == relationship.startNode().id()) {
            this.addOutgoing(relationship);
        } else if (previous == relationship.endNode().id()) {
            this.addIncoming(relationship);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

