/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.cypher.result;

import org.neo4j.cypher.internal.runtime.QueryStatistics;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.QuerySubscription;

public abstract class EmptyQuerySubscription implements QuerySubscription
{
    private final QuerySubscriber subscriber;

    public abstract QueryStatistics queryStatistics();

    public EmptyQuerySubscription( QuerySubscriber subscriber )
    {
        this.subscriber = subscriber;
    }

    @Override
    public void request( long numberOfRecords ) throws Exception
    {
        subscriber.onResult( 0 );
        subscriber.onResultCompleted( queryStatistics() );
    }

    @Override
    public void cancel()
    {
        //do nothing
    }

    @Override
    public boolean await()
    {
        return false;
    }
}
