/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public class InCache
implements AutoCloseable {
    private final LinkedHashMap<ListValue, InCacheChecker> seen;

    public InCache() {
        this(16);
    }

    public InCache(final int maxSize) {
        this.seen = new LinkedHashMap<ListValue, InCacheChecker>(maxSize >> 2, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ListValue, InCacheChecker> eldest) {
                return super.size() > maxSize;
            }
        };
    }

    public Value check(AnyValue value, ListValue list, MemoryTracker memoryTracker) {
        if (list.isEmpty()) {
            return Values.FALSE;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        InCacheChecker checker = this.seen.computeIfAbsent(list, k -> new InCacheChecker(list.iterator(), memoryTracker));
        return checker.check(value);
    }

    @Override
    public void close() {
        this.seen.values().forEach(InCacheChecker::close);
    }

    private static class InCacheChecker
    implements AutoCloseable {
        private final HeapTrackingUnifiedSet<AnyValue> seen;
        private final Iterator<AnyValue> iterator;
        private boolean seenUndefined;

        private InCacheChecker(Iterator<AnyValue> iterator, MemoryTracker memoryTracker) {
            this.iterator = iterator;
            this.seen = HeapTrackingCollections.newSet((MemoryTracker)memoryTracker);
        }

        private Value check(AnyValue value) {
            assert (value != Values.NO_VALUE);
            if (this.seen.contains((Object)value)) {
                return Values.TRUE;
            }
            while (this.iterator.hasNext()) {
                AnyValue next = this.iterator.next();
                if (next == Values.NO_VALUE) {
                    this.seenUndefined = true;
                    continue;
                }
                this.seen.add((Object)next);
                if (next.ternaryEquals(value) != Equality.TRUE) continue;
                return Values.TRUE;
            }
            if (this.seenUndefined) {
                return Values.NO_VALUE;
            }
            if (value instanceof SequenceValue || value instanceof MapValue) {
                boolean undefinedEquality = this.seen.stream().anyMatch(seenValue -> value.ternaryEquals(seenValue) == Equality.UNDEFINED);
                return undefinedEquality ? Values.NO_VALUE : Values.FALSE;
            }
            return Values.FALSE;
        }

        @Override
        public void close() {
            this.seen.close();
        }
    }
}

