/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.kernel.api.helpers;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.github.jamm.MemoryMeter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.CachingExpandInto;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipSelection;

class CachingExpandIntoTest {
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();

    CachingExpandIntoTest() {
    }

    @AfterEach
    void tearDown() {
        this.memoryTracker.reset();
    }

    @Test
    void shouldComputeDegreeOfStartAndEndNode() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.OUTGOING, this.memoryTracker);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.assertEstimatesCorrectly(expandInto);
        this.findConnections(expandInto, cursor, 42L, 43L, new int[0]);
        ((NodeCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)2))).degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class));
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldComputeDegreeOnceIfStartAndEndNodeAreTheSameAndDirectionBoth() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.BOTH, this.memoryTracker);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 42L, new int[0]);
        ((NodeCursor)Mockito.verify((Object)cursor)).degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class));
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldComputeDegreeOnceIfStartAndEndNodeAreTheSameAndDirectionOutgoing() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.OUTGOING, this.memoryTracker);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 42L, new int[0]);
        ((NodeCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)2))).degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class));
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldComputeDegreeOnceIfStartAndEndNodeAreTheSameAndDirectionIncoming() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.INCOMING, this.memoryTracker);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 42L, new int[0]);
        ((NodeCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)2))).degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class));
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldComputeDegreeOfStartAndEndNodeOnlyOnceIfDirectionBoth() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.BOTH, this.memoryTracker);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 43L, 3);
        this.findConnections(expandInto, cursor, 43L, 42L, 4);
        this.findConnections(expandInto, cursor, 42L, 43L, 5);
        ((NodeCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)2))).degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class));
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldComputeDegreeOfStartAndEndNodeTwiceIfDirectionOutgoing() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.OUTGOING, this.memoryTracker);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 43L, 3);
        this.findConnections(expandInto, cursor, 43L, 42L, 4);
        this.findConnections(expandInto, cursor, 42L, 43L, 5);
        ((NodeCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)4))).degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class));
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldComputeDegreeOfStartAndEndNodeTwiceIfDirectionIncoming() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.INCOMING, this.memoryTracker);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 43L, 3);
        this.findConnections(expandInto, cursor, 43L, 42L, 4);
        this.findConnections(expandInto, cursor, 42L, 43L, 5);
        ((NodeCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)4))).degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class));
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldComputeDegreeOfStartAndEndNodeEveryTimeIfCacheIsFull() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.OUTGOING, this.memoryTracker, 0);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 43L, new int[0]);
        this.findConnections(expandInto, cursor, 42L, 43L, new int[0]);
        this.findConnections(expandInto, cursor, 42L, 43L, new int[0]);
        this.findConnections(expandInto, cursor, 42L, 43L, new int[0]);
        this.findConnections(expandInto, cursor, 42L, 43L, new int[0]);
        ((NodeCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)10))).degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class));
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldNotRecomputeAnythingIfSameNodesAndTypes() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.OUTGOING, this.memoryTracker);
        this.findConnections(expandInto, CachingExpandIntoTest.mockCursor(), 42L, 43L, 100, 101);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 43L, 100, 101);
        ((NodeCursor)Mockito.verify((Object)cursor)).supportsFastRelationshipsTo();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{cursor});
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldRecomputeIfSameNodesAndTypesIfCacheIsFull() {
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.OUTGOING, this.memoryTracker, 0);
        this.findConnections(expandInto, CachingExpandIntoTest.mockCursor(), 42L, 43L, 100, 101);
        NodeCursor cursor = CachingExpandIntoTest.mockCursor();
        this.findConnections(expandInto, cursor, 42L, 43L, 100, 101);
        ((NodeCursor)Mockito.verify((Object)cursor, (VerificationMode)Mockito.atLeastOnce())).next();
        this.assertReleasesHeap(expandInto);
    }

    @Test
    void shouldUseFastPathOnCursorIfAvailable() {
        long fromNodeId = 3L;
        long toNodeId = 6L;
        int type = 8;
        TestRelationshipChain fromNodeRelationships = new TestRelationshipChain(fromNodeId).outgoing(0L, 99L, type).outgoing(1L, 999L, type).outgoing(2L, toNodeId, type).outgoing(3L, 9999L, type).outgoing(4L, toNodeId, type);
        TestRelationshipChain toNodeRelationships = new TestRelationshipChain(toNodeId).incoming(2L, fromNodeId, type).incoming(4L, fromNodeId, type);
        StubRelationshipCursor relationshipCursor = new StubRelationshipCursor(Arrays.asList(fromNodeRelationships, toNodeRelationships));
        StubNodeCursor nodeCursor = new StubNodeCursor(false, true).withNode(fromNodeId).withNode(toNodeId);
        CachingExpandInto expandInto = new CachingExpandInto((QueryContext)Mockito.mock(QueryContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS), Direction.OUTGOING, this.memoryTracker, 100);
        long nativeMemoryBefore = this.memoryTracker.usedNativeMemory();
        long heapMemoryBefore = this.memoryTracker.estimatedHeapMemory();
        expandInto.connectingRelationships((NodeCursor)nodeCursor, (RelationshipTraversalCursor)relationshipCursor, fromNodeId, new int[]{type}, toNodeId);
        Assertions.assertThat((long)this.memoryTracker.usedNativeMemory()).isEqualTo(nativeMemoryBefore);
        Assertions.assertThat((long)this.memoryTracker.estimatedHeapMemory()).isEqualTo(heapMemoryBefore);
        Assertions.assertThat((boolean)relationshipCursor.next()).isTrue();
        Assertions.assertThat((long)relationshipCursor.relationshipReference()).isEqualTo(2L);
        Assertions.assertThat((boolean)relationshipCursor.next()).isTrue();
        Assertions.assertThat((long)relationshipCursor.relationshipReference()).isEqualTo(4L);
        Assertions.assertThat((boolean)relationshipCursor.next()).isFalse();
    }

    private void findConnections(CachingExpandInto expandInto, NodeCursor cursor, long from, long to, int ... types) {
        RelationshipTraversalCursor traversal = (RelationshipTraversalCursor)Mockito.mock(RelationshipTraversalCursor.class);
        Mockito.when((Object)traversal.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, true, true, false});
        RelationshipTraversalCursor relationships = expandInto.connectingRelationships(cursor, traversal, from, types, to);
        this.assertEstimatesCorrectly(relationships);
        while (relationships.next()) {
            this.assertEstimatesCorrectly(relationships);
        }
        this.assertEstimatesCorrectly(expandInto);
        relationships.next();
        this.assertEstimatesCorrectly(expandInto);
    }

    private static NodeCursor mockCursor() {
        NodeCursor mock = (NodeCursor)Mockito.mock(NodeCursor.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mock.next()).thenReturn((Object)true);
        Mockito.when((Object)mock.supportsFastDegreeLookup()).thenReturn((Object)true);
        Mockito.when((Object)mock.degree((RelationshipSelection)ArgumentMatchers.any(RelationshipSelection.class))).thenReturn((Object)7);
        return mock;
    }

    private void assertEstimatesCorrectly(Object toMeasure) {
        long actualSize = this.meter.measureDeep(toMeasure) - this.meter.measureDeep((Object)this.memoryTracker);
        MatcherAssert.assertThat((Object)this.memoryTracker.estimatedHeapMemory(), (Matcher)CoreMatchers.equalTo((Object)actualSize));
    }

    private void assertReleasesHeap(CachingExpandInto expandInto) {
        expandInto.close();
        MatcherAssert.assertThat((Object)this.memoryTracker.estimatedHeapMemory(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }
}

