/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.profiling;

import java.io.Serializable;
import org.mockito.Answers;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.internal.profiling.KernelStatisticProvider;
import org.neo4j.cypher.internal.profiling.NoKernelStatisticProvider$;
import org.neo4j.cypher.internal.profiling.OperatorProfileEvent;
import org.neo4j.cypher.internal.profiling.ProfilingTracer;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.cypher.internal.util.attribution.Id$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.cypher.result.OperatorProfile;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0005\n\u0001;!)a\u0005\u0001C\u0001O\u0019!!\u0006\u0001\u0001,\u0011\u00151#\u0001\"\u0001;\u0011\u001di$\u00011A\u0005\u0002yBq!\u0012\u0002A\u0002\u0013\u0005a\t\u0003\u0004M\u0005\u0001\u0006Ka\u0010\u0005\u0006\u001b\n!\tA\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019I\u0006\u0001)A\u0005'\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u00023\u0001A\u0003%AL\u0002\u0003f\u0001\u00011\u0007\u0002C7\r\u0005\u0003\u0005\u000b\u0011\u00028\t\u000b\u0019bA\u0011\u0001<\t\u000bedA\u0011\t \t\u000bidA\u0011\t \u0003'A\u0013xNZ5mS:<GK]1dKJ$Vm\u001d;\u000b\u0005M!\u0012!\u00039s_\u001aLG.\u001b8h\u0015\t)b#\u0001\u0005j]R,'O\\1m\u0015\t9\u0002$\u0001\u0004dsBDWM\u001d\u0006\u00033i\tQA\\3pi)T\u0011aG\u0001\u0004_J<7\u0001A\n\u0003\u0001y\u0001\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\r\"\u0012\u0001B;uS2L!!\n\u0011\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011A\u0005\u0002\u0006\u00072|7m[\n\u0004\u00051\"\u0004CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UBdBA\u00157\u0013\t9$#A\bQe>4\u0017\u000e\\5oOR\u0013\u0018mY3s\u0013\tQ\u0013H\u0003\u00028%Q\t1\b\u0005\u0002=\u00055\t\u0001!\u0001\u0005oC:|G+[7f+\u0005y\u0004C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%\u0001\u0002'p]\u001e\fAB\\1o_RKW.Z0%KF$\"a\u0012&\u0011\u0005\u0001C\u0015BA%B\u0005\u0011)f.\u001b;\t\u000f-+\u0011\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\u0002\u00139\fgn\u001c+j[\u0016\u0004\u0013\u0001\u00039s_\u001e\u0014Xm]:\u0015\u0005\u001d{\u0005\"\u0002)\b\u0001\u0004y\u0014!\u00028b]>\u001c\u0018AA5e+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,#\u0003-\tG\u000f\u001e:jEV$\u0018n\u001c8\n\u0005a+&AA%e\u0003\rIG\rI\u0001\bg^\f\u0007\u000f]3s+\u0005a\u0006CA/c\u001b\u0005q&BA0a\u0003%\u0001\u0018mZ3dC\u000eDWM\u0003\u0002b1\u0005\u0011\u0011n\\\u0005\u0003Gz\u00131\u0002U1hKN;\u0018\r\u001d9fe\u0006A1o^1qa\u0016\u0014\bEA\u0011EK2,w-\u0019;j]\u001e\\UM\u001d8fYN#\u0018\r^5ti&\u001c\u0007K]8wS\u0012,'oE\u0002\rO*\u0004\"\u0001\u00115\n\u0005%\f%AB!osJ+g\r\u0005\u0002*W&\u0011AN\u0005\u0002\u0018\u0017\u0016\u0014h.\u001a7Ti\u0006$\u0018n\u001d;jGB\u0013xN^5eKJ\fa\u0001\u001e:bG\u0016\u0014\bCA8u\u001b\u0005\u0001(BA9s\u0003\u0019\u0019WO]:pe*\u00111OX\u0001\biJ\f7-\u001b8h\u0013\t)\bOA\fEK\u001a\fW\u000f\u001c;QC\u001e,7)\u001e:t_J$&/Y2feR\u0011q\u000f\u001f\t\u0003y1AQ!\u001c\bA\u00029\f\u0001cZ3u!\u0006<WmQ1dQ\u0016D\u0015\u000e^:\u0002%\u001d,G\u000fU1hK\u000e\u000b7\r[3NSN\u001cXm\u001d")
public class ProfilingTracerTest
extends CypherFunSuite {
    private final int id = Id$.MODULE$.INVALID_ID();
    private final PageSwapper swapper = (PageSwapper)this.mock((Answer)Answers.RETURNS_MOCKS, ClassTag$.MODULE$.apply(PageSwapper.class));

    private int id() {
        return this.id;
    }

    private PageSwapper swapper() {
        return this.swapper;
    }

    public ProfilingTracerTest() {
        this.test("shouldReportExecutionTimeOfQueryExecution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Clock clock = new Clock();
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((ProfilingTracer.Clock)clock, (KernelStatisticProvider)NoKernelStatisticProvider$.MODULE$);
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            clock.progress(516L);
            event.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.timeOf(new Id(operatorId))), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)516)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("multiple uses of the same Id should aggregate spent time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Clock clock = new Clock();
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((ProfilingTracer.Clock)clock, (KernelStatisticProvider)NoKernelStatisticProvider$.MODULE$);
            OperatorProfileEvent event1 = tracer.executeOperator(new Id(operatorId));
            clock.progress(12L);
            event1.close();
            OperatorProfileEvent event2 = tracer.executeOperator(new Id(operatorId));
            clock.progress(45L);
            event2.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.timeOf(new Id(operatorId))), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)57)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("multiple uses of the same Id with NO_DATA should produce NO_DATA", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Clock clock = new Clock();
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((ProfilingTracer.Clock)clock, (KernelStatisticProvider)NoKernelStatisticProvider$.MODULE$);
            OperatorProfileEvent event1 = tracer.executeOperator(new Id(operatorId), false);
            clock.progress(12L);
            event1.dbHits((long)((int)-1L));
            event1.rows((long)((int)-1L));
            event1.close();
            OperatorProfileEvent event2 = tracer.executeOperator(new Id(operatorId), false);
            clock.progress(45L);
            event2.dbHits((long)((int)-1L));
            event2.rows((long)((int)-1L));
            event2.close();
            OperatorProfile profile = tracer.operatorProfile(operatorId);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.time()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.dbHits()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.rows()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.pageCacheHits()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.pageCacheMisses()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("shouldReportDbHitsOfQueryExecution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((KernelStatisticProvider)NoKernelStatisticProvider$.MODULE$);
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 516).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> event.dbHit());
            event.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.dbHitsOf(new Id(operatorId))), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)516)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("shouldReportRowsOfQueryExecution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((KernelStatisticProvider)NoKernelStatisticProvider$.MODULE$);
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 516).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> event.row());
            event.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.rowsOf(new Id(operatorId))), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)516)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("report page cache hits as part of profiling statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int operatorId = this.id();
            DefaultPageCursorTracer cursorTracer = new DefaultPageCursorTracer((PageCacheTracer)new DefaultPageCacheTracer(), "test");
            ProfilingTracer tracer = new ProfilingTracer((KernelStatisticProvider)new DelegatingKernelStatisticProvider(this, cursorTracer));
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
                PinEvent pin = cursorTracer.beginPin(false, 1L, this.swapper());
                pin.hit();
                pin.done();
            });
            event.close();
            OperatorProfile information = tracer.operatorProfile(operatorId);
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)information.pageCacheHits()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)100)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("report page cache misses as part of profiling statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int operatorId = this.id();
            DefaultPageCursorTracer cursorTracer = new DefaultPageCursorTracer((PageCacheTracer)new DefaultPageCacheTracer(), "test");
            ProfilingTracer tracer = new ProfilingTracer((KernelStatisticProvider)new DelegatingKernelStatisticProvider(this, cursorTracer));
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 17).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> {
                PinEvent pin = cursorTracer.beginPin(false, 1L, this.swapper());
                PageFaultEvent pageFault = pin.beginPageFault(1L, this.swapper());
                pageFault.done();
                pin.done();
            });
            event.close();
            OperatorProfile information = tracer.operatorProfile(operatorId);
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)information.pageCacheMisses()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)17)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
    }

    public class Clock
    implements ProfilingTracer.Clock {
        private long nanoTime;

        public long nanoTime() {
            return this.nanoTime;
        }

        public void nanoTime_$eq(long x$1) {
            this.nanoTime = x$1;
        }

        public void progress(long nanos) {
            long $org_scalatest_assert_macro_left = nanos;
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.org$neo4j$cypher$internal$profiling$ProfilingTracerTest$Clock$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"time must move forwards", Prettifier$.MODULE$.default(), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
            this.nanoTime_$eq(this.nanoTime() + nanos);
        }

        public /* synthetic */ ProfilingTracerTest org$neo4j$cypher$internal$profiling$ProfilingTracerTest$Clock$$$outer() {
            return ProfilingTracerTest.this;
        }

        public Clock() {
            if (ProfilingTracerTest.this == null) {
                throw null;
            }
            this.nanoTime = 0L;
        }
    }

    public class DelegatingKernelStatisticProvider
    implements KernelStatisticProvider {
        private final DefaultPageCursorTracer tracer;
        public final /* synthetic */ ProfilingTracerTest $outer;

        public long getPageCacheHits() {
            return this.tracer.hits();
        }

        public long getPageCacheMisses() {
            return this.tracer.faults();
        }

        public /* synthetic */ ProfilingTracerTest org$neo4j$cypher$internal$profiling$ProfilingTracerTest$DelegatingKernelStatisticProvider$$$outer() {
            return this.$outer;
        }

        public DelegatingKernelStatisticProvider(ProfilingTracerTest $outer, DefaultPageCursorTracer tracer) {
            this.tracer = tracer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

