/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.runtime.ArrayBackedMap;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001\u001d!)q\u0003\u0001C\u00011\t\u0011\u0012I\u001d:bs\n\u000b7m[3e\u001b\u0006\u0004H+Z:u\u0015\t!Q!A\u0004sk:$\u0018.\\3\u000b\u0005\u00199\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005!I\u0011AB2za\",'O\u0003\u0002\u000b\u0017\u0005)a.Z85U*\tA\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001#F\u0007\u0002#)\u0011!cE\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003)\u0015\tA!\u001e;jY&\u0011a#\u0005\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t1\u0001")
public class ArrayBackedMapTest
extends CypherFunSuite {
    public ArrayBackedMapTest() {
        this.test("updating and getting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$1 = "name";
            String x$2 = "id";
            String x$3 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1, x$2}));
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$1, x$2}), (Object)x$3, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"neo", "123"});
            this.convertToAnyShouldWrapper(map.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(map.get((Object)"id"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(map.get((Object)"other"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("+ operator with existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$4 = "name";
            String x$5 = "id";
            String x$6 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$4, x$5}));
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$4, x$5}), (Object)x$6, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"neo", "123"});
            Map updatedMap = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"oen"));
            this.convertToAnyShouldWrapper(map.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(map.get((Object)"id"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(updatedMap.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"oen")), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(updatedMap.get((Object)"id"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("+ operator with non-existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$7 = "name";
            String x$8 = "id";
            String x$9 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$7, x$8}));
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$7, x$8}), (Object)x$9, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"neo", "123"});
            Map updatedMap = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"age"), (Object)"35"));
            this.convertToAnyShouldWrapper(map.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(map.get((Object)"id"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(map.get((Object)"age"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(updatedMap.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(updatedMap.get((Object)"id"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(updatedMap.get((Object)"age"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"35")), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("- operator on existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$10 = "name";
            String x$11 = "id";
            String x$12 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$10, x$11}));
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$10, x$11}), (Object)x$12, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"neo", "123"});
            Map updatedMap = map.$minus((Object)"name");
            this.convertToAnyShouldWrapper(map.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(map.get((Object)"id"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(updatedMap.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(updatedMap.get((Object)"id"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("iterating over map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$13 = "name";
            String x$14 = "id";
            String x$15 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$13, x$14}));
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$13, x$14}), (Object)x$15, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"neo", "123"});
            return this.convertToAnyShouldWrapper(map.iterator().toSet(), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74), Prettifier$.MODULE$.default()).should(this.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"name", (Object)"neo"), new Tuple2((Object)"id", (Object)"123")}))), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("support one null key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$16 = "name";
            Object x$17 = null;
            String[] stringArray = new String[2];
            stringArray[0] = x$16;
            stringArray[1] = null;
            String x$18 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
            String[] stringArray2 = new String[2];
            stringArray2[0] = x$16;
            stringArray2[1] = null;
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray2), (Object)x$18, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"neo", "123"});
            this.convertToAnyShouldWrapper(map.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(map.get(null), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("support for null values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$19 = "a";
            String x$20 = "b";
            String x$21 = "c";
            String x$22 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$19, x$20, x$21}));
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$19, x$20, x$21}), (Object)x$22, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{null, "123", null});
            this.convertToAnyShouldWrapper(map.get((Object)"a"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89), Prettifier$.MODULE$.default()).should(this.equal(new Some(null)), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(map.get((Object)"b"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(map.get((Object)"c"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91), Prettifier$.MODULE$.default()).should(this.equal(new Some(null)), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("support for missing values as null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$23 = "a";
            String x$24 = "b";
            String x$25 = "c";
            String x$26 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$23, x$24, x$25}));
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$23, x$24, x$25}), (Object)x$26, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"123"});
            this.convertToAnyShouldWrapper(map.get((Object)"a"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(map.get((Object)"b"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99), Prettifier$.MODULE$.default()).should(this.equal(new Some(null)), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(map.get((Object)"c"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default()).should(this.equal(new Some(null)), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("support for missing values as null with given nullValue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}), (Object)"<null>", ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"123"});
            this.convertToAnyShouldWrapper(map.get((Object)"a"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(map.get((Object)"b"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"<null>")), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(map.get((Object)"c"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"<null>")), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("support one null key mapped to null value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            String x$27 = "name";
            Object x$28 = null;
            String[] stringArray = new String[2];
            stringArray[0] = x$27;
            stringArray[1] = null;
            String x$29 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
            String[] stringArray2 = new String[2];
            stringArray2[0] = x$27;
            stringArray2[1] = null;
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray2), (Object)x$29, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"neo", null});
            this.convertToAnyShouldWrapper(map.get((Object)"name"), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(map.get(null), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117), Prettifier$.MODULE$.default()).should(this.equal(new Some(null)), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("having multiple nulls means that the last null is mapped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            Object x$30 = null;
            Object x$31 = null;
            Object x$32 = null;
            String[] stringArray = new String[3];
            stringArray[0] = null;
            stringArray[1] = null;
            stringArray[2] = null;
            String x$33 = (String)ArrayBackedMap$.MODULE$.apply$default$2((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
            String[] stringArray2 = new String[3];
            stringArray2[0] = null;
            stringArray2[1] = null;
            stringArray2[2] = null;
            ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray2), (Object)x$33, ClassTag$.MODULE$.apply(String.class));
            map.putValues((Object)new String[]{"v1", "v2", "v3"});
            return this.convertToAnyShouldWrapper(map.get(null), new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)"v3")), (Object)Equality$.MODULE$.default());
        }, new Position("ArrayBackedMapTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }
}

