/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.ClosingIteratorTest$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M4AAD\b\u00015!)1\u0005\u0001C\u0001I\u001d)qe\u0004E\u0001Q\u0019)ab\u0004E\u0001S!)1e\u0001C\u0001g\u0019)AgAA\u0001k!)1%\u0002C\u0001\u000b\"9\u0001*\u0002a\u0001\n\u0003I\u0005bB'\u0006\u0001\u0004%\tA\u0014\u0005\u0007)\u0016\u0001\u000b\u0015\u0002&\t\u000bU+A\u0011\t,\t\u000b]\u001bA\u0011\u0001-\t\u000b\u0005\u001cA\u0011\u00012\t\u000f%\u001c\u0011\u0011!C\u0005U\n\u00192\t\\8tS:<\u0017\n^3sCR|'\u000fV3ti*\u0011\u0001#E\u0001\beVtG/[7f\u0015\t\u00112#\u0001\u0005j]R,'O\\1m\u0015\t!R#\u0001\u0004dsBDWM\u001d\u0006\u0003-]\tQA\\3pi)T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u0001\n\u0012\u0001B;uS2L!AI\u000f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011aD\u0001\u0014\u00072|7/\u001b8h\u0013R,'/\u0019;peR+7\u000f\u001e\t\u0003M\r\u00192a\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u00111&M\u0005\u0003e1\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\u0012\u0001\u000b\u0002\u0014)\u0016\u001cHo\u00117pg&tw-\u0013;fe\u0006$xN]\u000b\u0003mq\u001a\"!B\u001c\u0011\u0007\u0019B$(\u0003\u0002:\u001f\ty1\t\\8tS:<\u0017\n^3sCR|'\u000f\u0005\u0002<y1\u0001AAB\u001f\u0006\t\u000b\u0007aHA\u0001U#\ty$\t\u0005\u0002,\u0001&\u0011\u0011\t\f\u0002\b\u001d>$\b.\u001b8h!\tY3)\u0003\u0002EY\t\u0019\u0011I\\=\u0015\u0003\u0019\u00032aR\u0003;\u001b\u0005\u0019\u0011AB2m_N,G-F\u0001K!\tY3*\u0003\u0002MY\t9!i\\8mK\u0006t\u0017AC2m_N,Gm\u0018\u0013fcR\u0011qJ\u0015\t\u0003WAK!!\u0015\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b'\"\t\t\u00111\u0001K\u0003\rAH%M\u0001\bG2|7/\u001a3!\u0003%\u0019Gn\\:f\u001b>\u0014X\rF\u0001P\u0003\u00191\u0018\r\\;fgV\u0011\u0011\f\u0018\u000b\u00035v\u00032aR\u0003\\!\tYD\fB\u0003>\u0017\t\u0007a\bC\u0003X\u0017\u0001\u0007a\fE\u0002,?nK!\u0001\u0019\u0017\u0003\u0015q\u0012X\r]3bi\u0016$g(A\u0004g_J,g/\u001a:\u0016\u0005\r4GC\u00013h!\r9U!\u001a\t\u0003w\u0019$Q!\u0010\u0007C\u0002yBQ\u0001\u001b\u0007A\u0002\u0015\fQA^1mk\u0016\f1B]3bIJ+7o\u001c7wKR\t1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006!A.\u00198h\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\r=\u0013'.Z2u\u0001")
public class ClosingIteratorTest
extends CypherFunSuite {
    public static <T> TestClosingIterator<T> forever(T t) {
        return ClosingIteratorTest$.MODULE$.forever(t);
    }

    public static <T> TestClosingIterator<T> values(Seq<T> seq) {
        return ClosingIteratorTest$.MODULE$.values(seq);
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("closed", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("closed", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public static Method reflMethod$Method3(Class x$1) {
        CallSite methodCache3 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method3 = methodCache3.find(x$1);
        if (method3 != null) {
            return method3;
        }
        method3 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("closeCount", methodCache3.parameterTypes()));
        methodCache3.add(x$1, method3);
        return method3;
    }

    public static Method reflMethod$Method4(Class x$1) {
        CallSite methodCache4 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method4 = methodCache4.find(x$1);
        if (method4 != null) {
            return method4;
        }
        method4 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("closeCount", methodCache4.parameterTypes()));
        methodCache4.add(x$1, method4);
        return method4;
    }

    public static final /* synthetic */ TestClosingIterator $anonfun$new$10(Iterator nextInner$1, int x$3) {
        return (TestClosingIterator)((Object)nextInner$1.next());
    }

    public static final /* synthetic */ GenTraversableOnce $anonfun$new$12(Iterator nextInner$2, int x$4) {
        return (GenTraversableOnce)nextInner$2.next();
    }

    private static final TestClosingIterator countingValues$1(Seq v, IntRef c$1) {
        ++c$1.elem;
        return ClosingIteratorTest$.MODULE$.values(v);
    }

    private static final TestClosingIterator rememberingValues$1(Seq v, BooleanRef created$1) {
        created$1.elem = true;
        return ClosingIteratorTest$.MODULE$.values(v);
    }

    public ClosingIteratorTest() {
        this.test("closes resources when depleted", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            AutoCloseable resource = new AutoCloseable(null){
                private boolean closed;

                public boolean closed() {
                    return this.closed;
                }

                public void closed_$eq(boolean x$1) {
                    this.closed = x$1;
                }

                public void close() {
                    this.closed_$eq(true);
                }
                {
                    this.closed = false;
                }
            };
            ClosingIterator iter = ClosingIterator$.MODULE$.empty().closing(resource);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)iter.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            AutoCloseable qual1 = resource;
            try {
                object = ClosingIteratorTest.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return this.convertToAnyShouldWrapper((Boolean)object, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("closeMore when depleted", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            ClosingIterator<Object> iter = new ClosingIterator<Object>(null){
                private boolean closed;

                public boolean closed() {
                    return this.closed;
                }

                public void closed_$eq(boolean x$1) {
                    this.closed = x$1;
                }

                public boolean innerHasNext() {
                    return false;
                }

                public void closeMore() {
                    this.closed_$eq(true);
                }

                public int next() {
                    return 0;
                }
                {
                    this.closed = false;
                }
            };
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)iter.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            ClosingIterator<Object> qual2 = iter;
            try {
                object = ClosingIteratorTest.reflMethod$Method2(qual2.getClass()).invoke((Object)qual2, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return this.convertToAnyShouldWrapper((Boolean)object, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("closes resources only once", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            AutoCloseable resource = new AutoCloseable(null){
                private int closeCount;

                public int closeCount() {
                    return this.closeCount;
                }

                public void closeCount_$eq(int x$1) {
                    this.closeCount = x$1;
                }

                public void close() {
                    this.closeCount_$eq(this.closeCount() + 1);
                }
                {
                    this.closeCount = 0;
                }
            };
            ClosingIterator iter = ClosingIterator$.MODULE$.empty().closing(resource);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)iter.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            iter.close();
            iter.close();
            AutoCloseable qual3 = resource;
            try {
                object = ClosingIteratorTest.reflMethod$Method3(qual3.getClass()).invoke((Object)qual3, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return this.convertToAnyShouldWrapper((Integer)object, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("closeMore only once", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            ClosingIterator<Object> iter = new ClosingIterator<Object>(null){
                private int closeCount;

                public int closeCount() {
                    return this.closeCount;
                }

                public void closeCount_$eq(int x$1) {
                    this.closeCount = x$1;
                }

                public boolean innerHasNext() {
                    return false;
                }

                public void closeMore() {
                    this.closeCount_$eq(this.closeCount() + 1);
                }

                public int next() {
                    return 0;
                }
                {
                    this.closeCount = 0;
                }
            };
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)iter.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            iter.close();
            iter.close();
            ClosingIterator<Object> qual4 = iter;
            try {
                object = ClosingIteratorTest.reflMethod$Method4(qual4.getClass()).invoke((Object)qual4, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return this.convertToAnyShouldWrapper((Integer)object, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("toIterator returns self", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClosingIterator iter = ClosingIterator$.MODULE$.empty();
            return this.convertToAnyShouldWrapper(iter.toIterator(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86), Prettifier$.MODULE$.default()).shouldBe(this.theSameInstanceAs().apply((Object)iter), Predef$.MODULE$.$conforms());
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("flatMap explicit close closes current inner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator<Integer> outer = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)0));
            TestClosingIterator<Integer> inner = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)1));
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> inner);
            package$.MODULE$.Range().apply(0, 10).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$2 -> {
                flatMapped.hasNext();
                return BoxesRunTime.unboxToInt((Object)flatMapped.next());
            });
            flatMapped.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("flatMap inner iterators are closed when depleted", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator<Integer> outer = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)0));
            TestClosingIterator inner1 = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1}));
            TestClosingIterator<Integer> inner2 = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)2));
            Iterator nextInner = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TestClosingIterator[]{inner1, inner2}));
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> ClosingIteratorTest.$anonfun$new$10(nextInner, BoxesRunTime.unboxToInt((Object)x$3)));
            flatMapped.hasNext();
            flatMapped.next();
            flatMapped.hasNext();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner1.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("flatMap inner iterators of mixed types are closed when depleted and on explicit closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator<Integer> outer = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)0));
            TestClosingIterator inner1 = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1}));
            Option inner2 = Option$.MODULE$.empty();
            Seq inner3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 3}));
            TestClosingIterator<Integer> inner4 = ClosingIteratorTest$.MODULE$.forever(BoxesRunTime.boxToInteger((int)4));
            Iterator nextInner = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{inner1, Option$.MODULE$.option2Iterable(inner2), inner3, inner4}));
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> ClosingIteratorTest.$anonfun$new$12(nextInner, BoxesRunTime.unboxToInt((Object)x$4)));
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(flatMapped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner1.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(flatMapped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(flatMapped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(flatMapped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner4.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            flatMapped.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner4.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("flatMap outer and inner iterators are closed when depleted", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1}));
            TestClosingIterator inner = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1}));
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> inner);
            flatMapped.hasNext();
            flatMapped.next();
            flatMapped.hasNext();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("flatMap with empty outer should not call inner lambda", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ClosingIterator outer = ClosingIterator$.MODULE$.empty();
            ClosingIterator flatMapped = outer.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> this.fail("should not call inner lambda", new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161)));
            return flatMapped.hasNext();
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("filter should close when depleted", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1}));
            ClosingIterator filtered = outer.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$7 -> false);
            filtered.hasNext();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("filter should not close in the middle", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5}));
            ClosingIterator filtered = outer.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> i % 2 == 0);
            filtered.hasNext();
            filtered.next();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            filtered.hasNext();
            filtered.next();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            filtered.hasNext();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("map should close on explicit close", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator outer = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            ClosingIterator mapped = outer.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> i + 1);
            mapped.hasNext();
            mapped.next();
            mapped.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)outer.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("++ closes when depleted and returns correct results", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            TestClosingIterator second = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{3, 4}));
            ClosingIterator concatted = first.$plus$plus((Function0 & Serializable & scala.Serializable)() -> second);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("++ when first is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(Nil$.MODULE$);
            TestClosingIterator second = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{3, 4}));
            ClosingIterator concatted = first.$plus$plus((Function0 & Serializable & scala.Serializable)() -> second);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("++ when second is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{3, 4}));
            TestClosingIterator second = ClosingIteratorTest$.MODULE$.values(Nil$.MODULE$);
            ClosingIterator concatted = first.$plus$plus((Function0 & Serializable & scala.Serializable)() -> second);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(concatted.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("++ closes on explicit close while iterating over first", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            TestClosingIterator second = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{3, 4}));
            ClosingIterator concatted = first.$plus$plus((Function0 & Serializable & scala.Serializable)() -> second);
            concatted.next();
            concatted.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("++ closes on explicit close while iterating over second", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator first = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            TestClosingIterator second = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{3, 4}));
            ClosingIterator concatted = first.$plus$plus((Function0 & Serializable & scala.Serializable)() -> second);
            concatted.next();
            concatted.next();
            concatted.next();
            concatted.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)first.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)second.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("++ close should not regenerate iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IntRef c = IntRef.create((int)0);
            ClosingIterator concatted = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1})).$plus$plus((Function0 & Serializable & scala.Serializable)() -> ClosingIteratorTest.countingValues$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}), c));
            concatted.next();
            concatted.next();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298), Prettifier$.MODULE$.default()).should(this.be().apply(false));
            concatted.close();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)concatted.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303), Prettifier$.MODULE$.default()).should(this.be().apply(false));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)c.elem), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("++ close should not eagerize second iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BooleanRef created = BooleanRef.create((boolean)false);
            ClosingIterator concatted = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1})).$plus$plus((Function0 & Serializable & scala.Serializable)() -> ClosingIteratorTest.rememberingValues$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}), created));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)created.elem), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            concatted.next();
            concatted.hasNext();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)created.elem), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        this.test("single returns one element", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClosingIterator single = ClosingIterator$.MODULE$.single((Object)BoxesRunTime.boxToInteger((int)1));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)single.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(single.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)single.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        this.test("grouped size -1 should fail", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClosingIterator single = ClosingIterator$.MODULE$.single((Object)BoxesRunTime.boxToInteger((int)1));
            return this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339)).thrownBy((Function0 & Serializable & scala.Serializable)() -> single.grouped(-1L));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        this.test("grouped size 0 should fail", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ClosingIterator single = ClosingIterator$.MODULE$.single((Object)BoxesRunTime.boxToInteger((int)1));
            return this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344)).thrownBy((Function0 & Serializable & scala.Serializable)() -> single.grouped(0L));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("grouped size 1 should return sequences of 1 element", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator input = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            ClosingIterator grouped = input.grouped(1L);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)grouped.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(grouped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355), Prettifier$.MODULE$.default()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)grouped.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(grouped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358), Prettifier$.MODULE$.default()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)grouped.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            this.convertToAnyShouldWrapper(grouped.next(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361), Prettifier$.MODULE$.default()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)grouped.hasNext()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("grouped when Iterator has a multiple size of argument size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator input = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}));
            ClosingIterator grouped = input.grouped(3L);
            this.convertToAnyShouldWrapper(grouped.toSeq(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372), Prettifier$.MODULE$.default()).should(this.equal(new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))), (List)Nil$.MODULE$)))), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.test("grouped when Iterator does not have a multiple size of argument size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator input = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8}));
            ClosingIterator grouped = input.grouped(3L);
            this.convertToAnyShouldWrapper(grouped.toSeq(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382), Prettifier$.MODULE$.default()).should(this.equal(new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8}))), (List)Nil$.MODULE$)))), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("grouped with just one batch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator input = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8}));
            ClosingIterator grouped = input.grouped(30L);
            this.convertToAnyShouldWrapper(grouped.toSeq(), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392), Prettifier$.MODULE$.default()).should(this.equal(new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8}))), (List)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("grouped closes on explicit close", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestClosingIterator input = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8}));
            ClosingIterator grouped = input.grouped(3L);
            grouped.next();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            grouped.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)input.closed()), new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }, new Position("ClosingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
    }

    public static abstract class TestClosingIterator<T>
    extends ClosingIterator<T> {
        private boolean closed = false;

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void closeMore() {
            this.closed_$eq(true);
        }
    }
}

