/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import org.neo4j.cypher.internal.logical.plans.IndexOrder;
import org.neo4j.cypher.internal.logical.plans.IndexOrderAscending$;
import org.neo4j.cypher.internal.logical.plans.IndexOrderDescending$;
import org.neo4j.cypher.internal.logical.plans.IndexOrderNone$;
import org.neo4j.cypher.internal.runtime.CompositeValueIndexCursor$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.helpers.StubNodeValueIndexCursor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.enablers.Size$;
import org.scalatest.enablers.Sortable$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r4AAB\u0004\u0001%!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0005A!)Q\u0007\u0001C\u0005m!)Q\t\u0001C\u0005\r\"9q\u000bAI\u0001\n\u0013A&!H\"p[B|7/\u001b;f-\u0006dW/Z%oI\u0016D8)\u001e:t_J$Vm\u001d;\u000b\u0005!I\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0015-\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00195\taaY=qQ\u0016\u0014(B\u0001\b\u0010\u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0019\u0013\u0005!Q\u000f^5m\u0013\tQRC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u00059\u0011!C2veN|'OR8s)\t\t#\u0006\u0005\u0002#Q5\t1E\u0003\u0002%K\u0005\u0019\u0011\r]5\u000b\u0005\u0019:\u0013AB6fe:,GN\u0003\u0002\u000b\u001b%\u0011\u0011f\t\u0002\u0015\u001d>$WMV1mk\u0016Le\u000eZ3y\u0007V\u00148o\u001c:\t\u000b-\u0012\u0001\u0019\u0001\u0017\u0002\rY\fG.^3t!\ri\u0003GM\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\tQAH]3qK\u0006$X\r\u001a \u0011\u00055\u001a\u0014B\u0001\u001b/\u0005\rIe\u000e^\u0001\u0007CNd\u0015n\u001d;\u0015\u0005]\u001a\u0005c\u0001\u001dAe9\u0011\u0011H\u0010\b\u0003uuj\u0011a\u000f\u0006\u0003yE\ta\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0005}r\u0013a\u00029bG.\fw-Z\u0005\u0003\u0003\n\u00131aU3r\u0015\tyd\u0006C\u0003E\u0007\u0001\u0007\u0011%\u0001\u0004dkJ\u001cxN]\u0001\u000ee\u0006tGm\\7DkJ\u001cxN]:\u0015\u0005\u001dk\u0005\u0003B\u0017I\u0015JJ!!\u0013\u0018\u0003\rQ+\b\u000f\\33!\ri3*I\u0005\u0003\u0019:\u0012Q!\u0011:sCfDqA\u0014\u0003\u0011\u0002\u0003\u0007q*\u0001\u0006j]\u0012,\u0007p\u0014:eKJ\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\u000bAd\u0017M\\:\u000b\u0005QK\u0011a\u00027pO&\u001c\u0017\r\\\u0005\u0003-F\u0013!\"\u00138eKb|%\u000fZ3s\u0003]\u0011\u0018M\u001c3p[\u000e+(o]8sg\u0012\"WMZ1vYR$\u0013'F\u0001ZU\ty%lK\u0001\\!\ta\u0016-D\u0001^\u0015\tqv,A\u0005v]\u000eDWmY6fI*\u0011\u0001ML\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00012^\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class CompositeValueIndexCursorTest
extends CypherFunSuite {
    /*
     * WARNING - void declaration
     */
    private NodeValueIndexCursor cursorFor(Seq<Object> values) {
        void var2_2;
        StubNodeValueIndexCursor stub = new StubNodeValueIndexCursor();
        ((IterableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int v = tuple2._1$mcI$sp();
            int i = tuple2._2$mcI$sp();
            StubNodeValueIndexCursor stubNodeValueIndexCursor = stub.withNode((long)i, new Value[]{Values.intValue((int)v)});
            return stubNodeValueIndexCursor;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Object> asList(NodeValueIndexCursor cursor) {
        void var2_2;
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (cursor.next()) {
            values.append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)cursor.propertyValue(0).asObject())}));
        }
        return var2_2;
    }

    private Tuple2<NodeValueIndexCursor[], Object> randomCursors(IndexOrder indexOrder) {
        NodeValueIndexCursor[] randomArray = new NodeValueIndexCursor[Random$.MODULE$.nextInt(1000)];
        int totalSize = 0;
        for (int i = 0; i < randomArray.length; ++i) {
            Seq seq;
            IndexOrder indexOrder2 = indexOrder;
            if (IndexOrderNone$.MODULE$.equals(indexOrder2)) {
                seq = (Seq)Seq$.MODULE$.fill(Random$.MODULE$.nextInt(100), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Random$.MODULE$.nextInt());
            } else if (IndexOrderAscending$.MODULE$.equals(indexOrder2)) {
                seq = (Seq)((SeqLike)Seq$.MODULE$.fill(Random$.MODULE$.nextInt(100), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Random$.MODULE$.nextInt())).sorted((Ordering)Ordering.Int$.MODULE$);
            } else if (IndexOrderDescending$.MODULE$.equals(indexOrder2)) {
                seq = (Seq)((SeqLike)Seq$.MODULE$.fill(Random$.MODULE$.nextInt(100), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Random$.MODULE$.nextInt())).sorted(Ordering.Int$.MODULE$.reverse());
            } else {
                throw new MatchError((Object)indexOrder2);
            }
            Seq randomInts = seq;
            randomArray[i] = this.cursorFor((Seq<Object>)randomInts);
            totalSize += randomInts.size();
        }
        return new Tuple2((Object)randomArray, (Object)BoxesRunTime.boxToInteger((int)totalSize));
    }

    private IndexOrder randomCursors$default$1() {
        return IndexOrderNone$.MODULE$;
    }

    public CompositeValueIndexCursorTest() {
        this.test("should create unordered cursor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.unordered((NodeValueIndexCursor[])((Object[])new NodeValueIndexCursor[]{this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{10, 11, 12})), this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{5})), this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{11, 15}))}));
            Seq<Object> list = this.asList(cursor);
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52), Prettifier$.MODULE$.default()).should(this.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 11, 12, 5, 11, 15}))), (Object)Equality$.MODULE$.default());
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("randomized unordered cursor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2<NodeValueIndexCursor[], Object> tuple2 = this.randomCursors(this.randomCursors$default$1());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            NodeValueIndexCursor[] cursors = (NodeValueIndexCursor[])tuple2._1();
            int totalSize = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)cursors, (Object)BoxesRunTime.boxToInteger((int)totalSize));
            Tuple2 tuple23 = tuple22;
            NodeValueIndexCursor[] cursors2 = (NodeValueIndexCursor[])tuple23._1();
            int totalSize2 = tuple23._2$mcI$sp();
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.unordered(cursors2);
            Seq<Object> list = this.asList(cursor);
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).should(this.have()).size((long)totalSize2, Size$.MODULE$.sizeOfGenTraversable());
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("should create ascending cursor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.ascending((NodeValueIndexCursor[])((Object[])new NodeValueIndexCursor[]{this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{10, 11, 12})), this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{5})), this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{11, 15}))}));
            Seq<Object> list = this.asList(cursor);
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80), Prettifier$.MODULE$.default()).should(this.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 10, 11, 11, 12, 15}))), (Object)Equality$.MODULE$.default());
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("randomized ascending cursor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2<NodeValueIndexCursor[], Object> tuple2 = this.randomCursors((IndexOrder)IndexOrderAscending$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            NodeValueIndexCursor[] cursors = (NodeValueIndexCursor[])tuple2._1();
            int totalSize = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)cursors, (Object)BoxesRunTime.boxToInteger((int)totalSize));
            Tuple2 tuple23 = tuple22;
            NodeValueIndexCursor[] cursors2 = (NodeValueIndexCursor[])tuple23._1();
            int totalSize2 = tuple23._2$mcI$sp();
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.ascending(cursors2);
            Seq<Object> list = this.asList(cursor);
            this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92), Prettifier$.MODULE$.default()).should(this.have()).size((long)totalSize2, Size$.MODULE$.sizeOfGenTraversable());
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93), Prettifier$.MODULE$.default()).shouldBe(this.sorted(), Sortable$.MODULE$.sortableNatureOfSeq((Ordering)Ordering.Int$.MODULE$));
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("should create descending cursor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.descending((NodeValueIndexCursor[])((Object[])new NodeValueIndexCursor[]{this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{12, 11, 10})), this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{5})), this.cursorFor((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{15, 11}))}));
            Seq<Object> list = this.asList(cursor);
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109), Prettifier$.MODULE$.default()).should(this.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{15, 12, 11, 11, 10, 5}))), (Object)Equality$.MODULE$.default());
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("randomized descending cursor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2<NodeValueIndexCursor[], Object> tuple2 = this.randomCursors((IndexOrder)IndexOrderDescending$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            NodeValueIndexCursor[] cursors = (NodeValueIndexCursor[])tuple2._1();
            int totalSize = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)cursors, (Object)BoxesRunTime.boxToInteger((int)totalSize));
            Tuple2 tuple23 = tuple22;
            NodeValueIndexCursor[] cursors2 = (NodeValueIndexCursor[])tuple23._1();
            int totalSize2 = tuple23._2$mcI$sp();
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.descending(cursors2);
            Seq<Object> list = this.asList(cursor);
            this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121), Prettifier$.MODULE$.default()).should(this.have()).size((long)totalSize2, Size$.MODULE$.sizeOfGenTraversable());
            return this.convertToAnyShouldWrapper(list.reverse(), new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122), Prettifier$.MODULE$.default()).shouldBe(this.sorted(), Sortable$.MODULE$.sortableNatureOfSeq((Ordering)Ordering.Int$.MODULE$));
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }
}

