/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.GrowingArray;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.HeapMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001\u001d!)q\u0003\u0001C\u00011\t\u0001rI]8xS:<\u0017I\u001d:bsR+7\u000f\u001e\u0006\u0003\t\u0015\tqA];oi&lWM\u0003\u0002\u0007\u000f\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\t\u0013\u000511-\u001f9iKJT!AC\u0006\u0002\u000b9,w\u000e\u000e6\u000b\u00031\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A)R\"A\t\u000b\u0005I\u0019\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(B\u0001\u000b\u0006\u0003\u0011)H/\u001b7\n\u0005Y\t\"AD\"za\",'OR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\r\u0001")
public class GrowingArrayTest
extends CypherFunSuite {
    public GrowingArrayTest() {
        this.test("empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            GrowingArray x = new GrowingArray((HeapMemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)x.hasNeverSeenData()), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            x.foreach((Function1 & Serializable & scala.Serializable)l -> this.fail("There should not be any elements", new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31)));
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("set and get", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GrowingArray x = new GrowingArray((HeapMemoryTracker)EmptyMemoryTracker.INSTANCE);
            x.set(0, (Object)"a");
            this.convertToStringShouldWrapper((String)x.get(0), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37), Prettifier$.MODULE$.default()).shouldBe((Object)"a");
            x.set(0, (Object)"b");
            this.convertToStringShouldWrapper((String)x.get(0), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40), Prettifier$.MODULE$.default()).shouldBe((Object)"b");
            x.set(1, (Object)"c");
            this.convertToStringShouldWrapper((String)x.get(0), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43), Prettifier$.MODULE$.default()).shouldBe((Object)"b");
            return this.convertToStringShouldWrapper((String)x.get(1), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44), Prettifier$.MODULE$.default()).shouldBe((Object)"c");
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("set a lot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GrowingArray x = new GrowingArray((HeapMemoryTracker)EmptyMemoryTracker.INSTANCE);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> x.set(i, (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i))));
            this.convertToStringShouldWrapper((String)x.get(265), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54), Prettifier$.MODULE$.default()).shouldBe((Object)"265");
            this.convertToStringShouldWrapper((String)x.get(42), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55), Prettifier$.MODULE$.default()).shouldBe((Object)"42");
            return this.convertToStringShouldWrapper((String)x.get(999), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56), Prettifier$.MODULE$.default()).shouldBe((Object)"999");
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("foreach", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GrowingArray x = new GrowingArray((HeapMemoryTracker)EmptyMemoryTracker.INSTANCE);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> x.set(i, (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i))));
            Builder builder = Seq$.MODULE$.newBuilder();
            x.foreach((Function1 & Serializable & scala.Serializable)str -> {
                builder.$plus$eq((Object)str);
                return BoxedUnit.UNIT;
            });
            return this.convertToAnyShouldWrapper(builder, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67), Prettifier$.MODULE$.default()).shouldBe((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"})));
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("foreach ignores gaps and nulls", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GrowingArray x = new GrowingArray((HeapMemoryTracker)EmptyMemoryTracker.INSTANCE);
            x.set(0, (Object)"0");
            x.set(2, (Object)"2");
            x.set(3, null);
            x.set(4, (Object)"4");
            Builder builder = Seq$.MODULE$.newBuilder();
            x.foreach((Function1 & Serializable & scala.Serializable)str -> {
                builder.$plus$eq((Object)str);
                return BoxedUnit.UNIT;
            });
            return this.convertToAnyShouldWrapper(builder, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79), Prettifier$.MODULE$.default()).shouldBe((Object)new .colon.colon((Object)"0", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$))));
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("hasNeverSeenData", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GrowingArray x = new GrowingArray((HeapMemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)x.hasNeverSeenData()), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            x.set(0, (Object)"a");
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)x.hasNeverSeenData()), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            x.set(0, null);
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)x.hasNeverSeenData()), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("set on an large out-of-bounds index", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GrowingArray x = new GrowingArray((HeapMemoryTracker)EmptyMemoryTracker.INSTANCE);
            x.set(1234, (Object)"a");
            return this.convertToStringShouldWrapper((String)x.get(1234), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96), Prettifier$.MODULE$.default()).shouldBe((Object)"a");
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("isDefinedAt", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GrowingArray x = new GrowingArray((HeapMemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)x.isDefinedAt(1234)), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
            x.set(1234, (Object)"a");
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)x.isDefinedAt(1234)), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)x.isDefinedAt(0)), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("should allocate memory on creation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LocalMemoryTracker memoryTracking = new LocalMemoryTracker();
            new GrowingArray((HeapMemoryTracker)memoryTracking);
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)memoryTracking.estimatedHeapMemory()), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112), Prettifier$.MODULE$.default()).shouldBe(this.$greater(BoxesRunTime.boxToLong((long)0L), (Ordering)Ordering.Long$.MODULE$));
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("should allocate when adding objects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LocalMemoryTracker memoryTracking = new LocalMemoryTracker();
            GrowingArray x = new GrowingArray((HeapMemoryTracker)memoryTracking);
            long initMemory = memoryTracking.estimatedHeapMemory();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 16).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> x.set(i, (Object)Integer.toString(i)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)memoryTracking.estimatedHeapMemory()), new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125), Prettifier$.MODULE$.default()).should(this.be().$greater((Object)BoxesRunTime.boxToLong((long)initMemory), (Ordering)Ordering.Long$.MODULE$));
        }, new Position("GrowingArrayTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }
}

