/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.util.NoSuchElementException;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.ClosingIteratorTest;
import org.neo4j.cypher.internal.runtime.ClosingIteratorTest$;
import org.neo4j.cypher.internal.runtime.PeekingIterator;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001\u001d!)q\u0003\u0001C\u00011\t\u0019\u0002+Z3lS:<\u0017\n^3sCR|'\u000fV3ti*\u0011A!B\u0001\beVtG/[7f\u0015\t1q!\u0001\u0005j]R,'O\\1m\u0015\tA\u0011\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u0015-\tQA\\3pi)T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0003\u0001=\u0001\"\u0001E\u000b\u000e\u0003EQ!AE\n\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005Q)\u0011\u0001B;uS2L!AF\t\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011a\u0001")
public class PeekingIteratorTest
extends CypherFunSuite {
    public PeekingIteratorTest() {
        this.test("peek on empty iterator throws", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> this.a(ClassTag$.MODULE$.apply(NoSuchElementException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28)).thrownBy((Function0 & java.io.Serializable & Serializable)() -> (Nothing$)new PeekingIterator(ClosingIterator$.MODULE$.empty()).peek()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("one element iterator, no peek", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            PeekingIterator i = new PeekingIterator(ClosingIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.next(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35), Prettifier$.MODULE$.default()).should(this.be().apply(false));
        }, new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("one element iterator, peek", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            PeekingIterator i = new PeekingIterator(ClosingIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.peek(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.next(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44), Prettifier$.MODULE$.default()).should(this.be().apply(false));
        }, new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("two element iterator, no peek", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            PeekingIterator i = new PeekingIterator(ClosingIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.next(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.next(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Prettifier$.MODULE$.default()).should(this.be().apply(false));
        }, new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("two element iterator, peek", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            PeekingIterator i = new PeekingIterator(ClosingIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.peek(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.next(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.peek(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).should(this.be().apply(true));
            this.convertToAnyShouldWrapper(i.next(), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)i.hasNext()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66), Prettifier$.MODULE$.default()).should(this.be().apply(false));
        }, new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("closes inner iterator on close", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            ClosingIteratorTest.TestClosingIterator inner = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            PeekingIterator peeking = new PeekingIterator(inner);
            peeking.peek();
            peeking.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner.closed()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75), Prettifier$.MODULE$.default()).should(this.be().apply(true));
        }, new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("closes inner iterator on depletion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            ClosingIteratorTest.TestClosingIterator inner = ClosingIteratorTest$.MODULE$.values(Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
            PeekingIterator peeking = new PeekingIterator(inner);
            peeking.toList();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)inner.closed()), new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83), Prettifier$.MODULE$.default()).should(this.be().apply(true));
        }, new Position("PeekingIteratorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }
}

