/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.ResourceManager$;
import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.runtime.SingleThreadedResourcePool;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Containing$;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001\u0002\u000e\u001c\u0001\u0019BQa\f\u0001\u0005\u0002ABQa\r\u0001\u0005\nQBQa\r\u0001\u0005\nACq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u0002\u001a\u0001!I!!\t\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011q\u0005\u0001\u0005\n\u0005=b\u0001\u0002+\u0001\u0001UCQa\f\u0005\u0005\u0002yC\u0011b\u0018\u0005A\u0002\u0003\u0007I\u0011\u00021\t\u0013\u0011D\u0001\u0019!a\u0001\n\u0013)\u0007\"\u00035\t\u0001\u0004\u0005\t\u0015)\u0003b\u0011\u001dI\u0007\u00021A\u0005\n)DqA\u001c\u0005A\u0002\u0013%q\u000e\u0003\u0004r\u0011\u0001\u0006Ka\u001b\u0005\be\"\u0001\r\u0011\"\u0003t\u0011\u001d9\b\u00021A\u0005\naDaA\u001f\u0005!B\u0013!\b\"B>\t\t\u0003b\b\"B?\t\t\u0003b\b\"\u0002@\t\t\u0003z\bbBA\u0001\u0011\u0011\u0005\u00131\u0001\u0005\u0007\u0003\u0013AA\u0011\u00011\t\u000f\u0005-\u0001\u0002\"\u0011\u0002\u000e!9\u0011\u0011\u0003\u0005\u0005B\u0005M!a\u0005*fg>,(oY3NC:\fw-\u001a:UKN$(B\u0001\u000f\u001e\u0003\u001d\u0011XO\u001c;j[\u0016T!AH\u0010\u0002\u0011%tG/\u001a:oC2T!\u0001I\u0011\u0002\r\rL\b\u000f[3s\u0015\t\u00113%A\u0003oK>$$NC\u0001%\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0005\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005aA/Z:u?\",G\u000e]3sg*\u0011A&H\u0001\u0005kRLG.\u0003\u0002/S\tq1)\u001f9iKJ4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u00012!\t\u0011\u0004!D\u0001\u001c\u0003-1XM]5gsR\u0013\u0018mY3\u0015\tUZdi\u0013\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0005+:LG\u000fC\u0003=\u0005\u0001\u0007Q(\u0001\u0005sKN|WO]2f!\tqD)D\u0001@\u0015\t\u0001\u0015)A\u0002ba&T!AQ\"\u0002\r-,'O\\3m\u0015\tq\u0012%\u0003\u0002F\u007f\t\t\u0012)\u001e;p\u00072|7/Z1cY\u0016\u0004F.^:\t\u000b\u001d\u0013\u0001\u0019\u0001%\u0002\u000f5|g.\u001b;peB\u0011!'S\u0005\u0003\u0015n\u0011qBU3t_V\u00148-Z'p]&$xN\u001d\u0005\u0006\u0019\n\u0001\r!T\u0001\ne\u0016\u001cx.\u001e:dKN\u0004\"A\r(\n\u0005=[\"a\u0004*fg>,(oY3NC:\fw-\u001a:\u0015\rU\n\u0016QCA\f\u0011\u0015a4\u00011\u0001S!\t\u0019\u0006\"D\u0001\u0001\u00055!U/\\7z%\u0016\u001cx.\u001e:dKN\u0019\u0001BV\u001f\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u00027b]\u001eT\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n1qJ\u00196fGR$\u0012AU\u0001\tY&\u001cH/\u001a8feV\t\u0011\r\u0005\u0002?E&\u00111m\u0010\u0002\u000e\u00072|7/\u001a'jgR,g.\u001a:\u0002\u00191L7\u000f^3oKJ|F%Z9\u0015\u0005U2\u0007bB4\f\u0003\u0003\u0005\r!Y\u0001\u0004q\u0012\n\u0014!\u00037jgR,g.\u001a:!\u0003\u0015!xn[3o+\u0005Y\u0007C\u0001\u001cm\u0013\tiwGA\u0002J]R\f\u0011\u0002^8lK:|F%Z9\u0015\u0005U\u0002\bbB4\u000f\u0003\u0003\u0005\ra[\u0001\u0007i>\\WM\u001c\u0011\u0002\r\rdwn]3e+\u0005!\bC\u0001\u001cv\u0013\t1xGA\u0004C_>dW-\u00198\u0002\u0015\rdwn]3e?\u0012*\u0017\u000f\u0006\u00026s\"9q-EA\u0001\u0002\u0004!\u0018aB2m_N,G\rI\u0001\u0006G2|7/\u001a\u000b\u0002k\u0005i1\r\\8tK&sG/\u001a:oC2\f\u0001\"[:DY>\u001cX\r\u001a\u000b\u0002i\u0006\u00012/\u001a;DY>\u001cX\rT5ti\u0016tWM\u001d\u000b\u0004k\u0005\u0015\u0001BBA\u0004-\u0001\u0007\u0011-A\u0007dY>\u001cX\rT5ti\u0016tWM]\u0001\u0011O\u0016$8\t\\8tK2K7\u000f^3oKJ\f\u0001b]3u)>\\WM\u001c\u000b\u0004k\u0005=\u0001\"B5\u0019\u0001\u0004Y\u0017\u0001C4fiR{7.\u001a8\u0015\u0003-DQaR\u0002A\u0002!CQ\u0001T\u0002A\u00025\u000b!C^3sS\u001aLXj\u001c8ji>\u00148\t\\8tKR)Q'!\b\u0002 !)A\b\u0002a\u0001{!)q\t\u0002a\u0001\u0011R)Q'a\t\u0002&!)A(\u0002a\u0001%\")q)\u0002a\u0001\u0011\u0006Ya/\u001a:jMf\u001cEn\\:f)\u0015)\u00141FA\u0017\u0011\u0015ad\u00011\u0001>\u0011\u00159e\u00011\u0001I)\u0015)\u0014\u0011GA\u001a\u0011\u0015at\u00011\u0001S\u0011\u00159u\u00011\u0001I\u0001")
public class ResourceManagerTest
extends CypherFunSuite {
    private void verifyTrace(AutoCloseablePlus resource, ResourceMonitor monitor, ResourceManager resources) {
        resources.trace(resource);
        ((AutoCloseablePlus)Mockito.verify((Object)resource)).setCloseListener((CloseListener)resources);
        ((AutoCloseablePlus)Mockito.verify((Object)resource)).setToken(ArgumentMatchers.anyInt());
        ((ResourceMonitor)Mockito.verify((Object)monitor)).trace(resource);
    }

    private void verifyTrace(DummyResource resource, ResourceMonitor monitor, ResourceManager resources) {
        resources.trace((AutoCloseablePlus)resource);
        this.convertToAnyShouldWrapper(resource.getCloseListener(), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268), Prettifier$.MODULE$.default()).should(this.equal(resources), (Object)Equality$.MODULE$.default());
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)resource.getToken()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269), Prettifier$.MODULE$.default()).should(this.be().$greater$eq((Object)BoxesRunTime.boxToInteger((int)0), (Ordering)Ordering.Int$.MODULE$));
        ((ResourceMonitor)Mockito.verify((Object)monitor)).trace((AutoCloseablePlus)resource);
    }

    private void verifyMonitorClose(AutoCloseablePlus resource, ResourceMonitor monitor) {
        ((ResourceMonitor)Mockito.verify((Object)monitor)).close(resource);
        ((AutoCloseablePlus)Mockito.verify((Object)resource)).setCloseListener(null);
    }

    private void verifyMonitorClose(DummyResource resource, ResourceMonitor monitor) {
        ((ResourceMonitor)Mockito.verify((Object)monitor)).close((AutoCloseablePlus)resource);
        this.convertToAnyShouldWrapper(resource.getCloseListener(), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280), Prettifier$.MODULE$.default()).shouldBe(null, Predef$.MODULE$.$conforms());
    }

    private void verifyClose(AutoCloseablePlus resource, ResourceMonitor monitor) {
        this.verifyMonitorClose(resource, monitor);
        ((AutoCloseablePlus)Mockito.verify((Object)resource)).setCloseListener(null);
        ((AutoCloseablePlus)Mockito.verify((Object)resource)).close();
    }

    private void verifyClose(DummyResource resource, ResourceMonitor monitor) {
        this.verifyMonitorClose(resource, monitor);
        this.convertToAnyShouldWrapper(resource.getCloseListener(), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291), Prettifier$.MODULE$.default()).shouldBe(null, Predef$.MODULE$.$conforms());
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)resource.isClosed()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public static final /* synthetic */ Assertion $anonfun$new$11(ResourceManagerTest $this, DummyResource[] resources$2, int i) {
        SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)$this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resources$2)).foreach((Function1 & Serializable & scala.Serializable)resource -> {
            pool.add(resource);
            return BoxedUnit.UNIT;
        });
        DummyResource toRemove = resources$2[i];
        pool.remove((AutoCloseablePlus)toRemove);
        List closeables = pool.all().toList();
        $this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)closeables.size()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
        return $this.convertToAnyShouldWrapper(closeables, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179), Prettifier$.MODULE$.default()).shouldNot($this.contain().apply((Object)toRemove), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
    }

    public static final /* synthetic */ Assertion $anonfun$new$17(ResourceManagerTest $this, int i$1, DummyResource[] resources$3, int j) {
        return i$1 == j ? $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)resources$3[j].isClosed()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false)) : $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)resources$3[j].isClosed()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public ResourceManagerTest() {
        this.test("should be able to trace and release a resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AutoCloseablePlus resource = (AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class));
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            this.verifyTrace(resource, monitor, resources);
            resources.onClosed(resource);
            this.verifyMonitorClose(resource, monitor);
            resources.close();
            ((AutoCloseablePlus)Mockito.verify((Object)resource)).getToken();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource, monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("should close the unreleased resource when closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AutoCloseablePlus resource = (AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class));
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            this.verifyTrace(resource, monitor, resources);
            resources.close();
            this.verifyClose(resource, monitor);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource, monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("should not close resources multiple times when closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AutoCloseablePlus resource = (AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class));
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            this.verifyTrace(resource, monitor, resources);
            resources.close();
            this.verifyClose(resource, monitor);
            resources.close();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource, monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("should be able to trace and release multiple resources", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyResource resource1 = new DummyResource();
            DummyResource resource2 = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            this.verifyTrace(resource1, monitor, resources);
            this.verifyTrace(resource2, monitor, resources);
            resources.onClosed((AutoCloseablePlus)resource1);
            this.verifyMonitorClose(resource1, monitor);
            resources.onClosed((AutoCloseablePlus)resource2);
            this.verifyMonitorClose(resource2, monitor);
            resources.close();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("should close the unreleased resources when closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AutoCloseablePlus resource1 = (AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class));
            AutoCloseablePlus resource2 = (AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class));
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            this.verifyTrace(resource1, monitor, resources);
            this.verifyTrace(resource2, monitor, resources);
            resources.close();
            this.verifyClose(resource1, monitor);
            this.verifyClose(resource2, monitor);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource1, resource2, monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("should close only the unreleased resources when closed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyResource resource1 = new DummyResource();
            DummyResource resource2 = new DummyResource();
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            this.verifyTrace(resource1, monitor, resources);
            this.verifyTrace(resource2, monitor, resources);
            resources.onClosed((AutoCloseablePlus)resource2);
            this.verifyMonitorClose(resource2, monitor);
            resources.close();
            this.verifyClose(resource1, monitor);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("should close all the resources even in case of exceptions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            AutoCloseablePlus resource1 = (AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class));
            AutoCloseablePlus resource2 = (AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class));
            AutoCloseablePlus resource3 = (AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class));
            ResourceMonitor monitor = (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class));
            ResourceManager resources = new ResourceManager(monitor, ResourceManager$.MODULE$.$lessinit$greater$default$2());
            this.verifyTrace(resource1, monitor, resources);
            this.verifyTrace(resource2, monitor, resources);
            this.verifyTrace(resource3, monitor, resources);
            RuntimeException exception1 = new RuntimeException();
            resource1.close();
            Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{exception1});
            RuntimeException exception2 = new RuntimeException();
            resource2.close();
            Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{exception2});
            Throwable throwable = (Throwable)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resources.close()).failed().get();
            this.verifyClose(resource1, monitor);
            this.verifyClose(resource2, monitor);
            this.verifyClose(resource3, monitor);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{resource1, resource2, resource3, monitor});
            return this.convertToAnyShouldWrapper(((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{throwable}))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])throwable.getSuppressed()))), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143), Prettifier$.MODULE$.default()).shouldBe((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RuntimeException[]{exception1, exception2})));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("Resource pool should be able to grow beyond initial capacity", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.all().size()), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)5));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("Should be able to remove resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DummyResource[] resources = (DummyResource[])((Object[])new DummyResource[]{new DummyResource(), new DummyResource(), new DummyResource(), new DummyResource(), new DummyResource()});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resources)).indices().foreach((Function1 & Serializable & scala.Serializable)i -> ResourceManagerTest.$anonfun$new$11(this, resources, BoxesRunTime.unboxToInt((Object)i)));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("Should be able to clear", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.add((AutoCloseablePlus)this.mock(ClassTag$.MODULE$.apply(AutoCloseablePlus.class)));
            pool.clear();
            return this.convertToAnyShouldWrapper(pool.all(), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196), Prettifier$.MODULE$.default()).shouldBe(this.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test("Should not call close on removed item", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            DummyResource[] resources = (DummyResource[])((Object[])new DummyResource[]{new DummyResource(), new DummyResource(), new DummyResource(), new DummyResource(), new DummyResource()});
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resources)).foreach((Function1 & Serializable & scala.Serializable)resource -> {
                pool.add(resource);
                return BoxedUnit.UNIT;
            });
            pool.remove((AutoCloseablePlus)resources[i]);
            pool.closeAll();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)j -> ResourceManagerTest.$anonfun$new$17(this, i, resources, BoxesRunTime.unboxToInt((Object)j)));
        }), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("Resource pool new size should not overflow", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)this.mock(ClassTag$.MODULE$.apply(MemoryTracker.class)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(1)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(2)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(5)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)10));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(0x3FFFFFFF)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0x7FFFFFFE));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(0x40000000)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)0x40000001));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)pool.computeNewSize(0x7FFFFFFE)), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.test("Resource pool attempt not to create holes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(4, (ResourceMonitor)this.mock(ClassTag$.MODULE$.apply(ResourceMonitor.class)), (MemoryTracker)this.mock(ClassTag$.MODULE$.apply(MemoryTracker.class)));
            DummyResource r1 = new DummyResource();
            DummyResource r2 = new DummyResource();
            DummyResource r3 = new DummyResource();
            DummyResource r4 = new DummyResource();
            pool.add((AutoCloseablePlus)r1);
            pool.add((AutoCloseablePlus)r2);
            pool.add((AutoCloseablePlus)r3);
            pool.add((AutoCloseablePlus)r4);
            pool.remove((AutoCloseablePlus)r3);
            pool.remove((AutoCloseablePlus)r4);
            pool.add((AutoCloseablePlus)r4);
            pool.add((AutoCloseablePlus)r3);
            return this.convertToAnyShouldWrapper(pool.allIncludingNullValues(), new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256), Prettifier$.MODULE$.default()).should(this.equal(new .colon.colon((Object)r1, (List)new .colon.colon((Object)r2, (List)new .colon.colon((Object)r4, (List)new .colon.colon((Object)r3, (List)Nil$.MODULE$))))), (Object)Equality$.MODULE$.default());
        }, new Position("ResourceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
    }

    public class DummyResource
    implements AutoCloseablePlus {
        private CloseListener listener;
        private int token;
        private boolean closed;

        private CloseListener listener() {
            return this.listener;
        }

        private void listener_$eq(CloseListener x$1) {
            this.listener = x$1;
        }

        private int token() {
            return this.token;
        }

        private void token_$eq(int x$1) {
            this.token = x$1;
        }

        private boolean closed() {
            return this.closed;
        }

        private void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void close() {
            this.closed_$eq(true);
        }

        public void closeInternal() {
            this.close();
        }

        public boolean isClosed() {
            return this.closed();
        }

        public void setCloseListener(CloseListener closeListener) {
            this.listener_$eq(closeListener);
        }

        public CloseListener getCloseListener() {
            return this.listener();
        }

        public void setToken(int token) {
            this.token_$eq(token);
        }

        public int getToken() {
            return this.token();
        }

        public /* synthetic */ ResourceManagerTest org$neo4j$cypher$internal$runtime$ResourceManagerTest$DummyResource$$$outer() {
            return ResourceManagerTest.this;
        }

        public DummyResource() {
            if (ResourceManagerTest.this == null) {
                throw null;
            }
            this.token = -1;
            this.closed = false;
        }
    }
}

