/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.github.jamm.MemoryMeter;
import org.neo4j.cypher.internal.runtime.ResourceMonitor$;
import org.neo4j.cypher.internal.runtime.SingleThreadedResourcePool;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M4A\u0001E\t\u00019!)Q\u0005\u0001C\u0001M!9\u0011\u0006\u0001b\u0001\n\u0013Q\u0003B\u0002\u001b\u0001A\u0003%1fB\u00036#!\u0005aGB\u0003\u0011#!\u0005q\u0007C\u0003&\u000b\u0011\u0005\u0011I\u0002\u0003C\u000b\u0001\u0019\u0005\"B\u0013\b\t\u0003\u0019\u0006\"\u0002,\b\t\u0003:\u0006\"B.\b\t\u0003:\u0006\"\u0002/\b\t\u0003j\u0006\"B1\b\t\u0003\u0012\u0007\"\u00025\b\t\u0003J\u0007\"B8\b\t\u0003\u0002\bbB9\u0006\u0003\u0003%IA\u001d\u0002''&tw\r\\3UQJ,\u0017\rZ3e%\u0016\u001cx.\u001e:dKB{w\u000e\u001c+sC\u000e\\\u0017N\\4UKN$(B\u0001\n\u0014\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001F\u000b\u0002\u0011%tG/\u001a:oC2T!AF\f\u0002\r\rL\b\u000f[3s\u0015\tA\u0012$A\u0003oK>$$NC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005aA/Z:u?\",G\u000e]3sg*\u0011!eE\u0001\u0005kRLG.\u0003\u0002%?\tq1)\u001f9iKJ4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\u0012\u0003\u0019\u0011\u0018M\u001c3p[V\t1\u0006\u0005\u0002-e5\tQF\u0003\u0002/_\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\t\u0002$\"A\u0019\u0002\t)\fg/Y\u0005\u0003g5\u0012\u0011\u0003\u00165sK\u0006$Gj\\2bYJ\u000bg\u000eZ8n\u0003\u001d\u0011\u0018M\u001c3p[\u0002\naeU5oO2,G\u000b\u001b:fC\u0012,GMU3t_V\u00148-\u001a)p_2$&/Y2lS:<G+Z:u!\tASaE\u0002\u0006qy\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012a!\u00118z%\u00164\u0007CA\u001d@\u0013\t\u0001%H\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u00017\u00051!Vm\u001d;SKN|WO]2f'\r9AI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fB\nA\u0001\\1oO&\u0011\u0011J\u0012\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005-\u000bV\"\u0001'\u000b\u00055s\u0015aA1qS*\u0011q\nU\u0001\u0007W\u0016\u0014h.\u001a7\u000b\u0005Q9\u0012B\u0001*M\u0005E\tU\u000f^8DY>\u001cX-\u00192mKBcWo\u001d\u000b\u0002)B\u0011QkB\u0007\u0002\u000b\u0005)1\r\\8tKR\t\u0001\f\u0005\u0002:3&\u0011!L\u000f\u0002\u0005+:LG/A\u0007dY>\u001cX-\u00138uKJt\u0017\r\\\u0001\tSN\u001cEn\\:fIR\ta\f\u0005\u0002:?&\u0011\u0001M\u000f\u0002\b\u0005>|G.Z1o\u0003A\u0019X\r^\"m_N,G*[:uK:,'\u000f\u0006\u0002YG\")A\r\u0004a\u0001K\u0006i1\r\\8tK2K7\u000f^3oKJ\u0004\"a\u00134\n\u0005\u001dd%!D\"m_N,G*[:uK:,'/\u0001\u0005tKR$vn[3o)\tA&\u000eC\u0003l\u001b\u0001\u0007A.A\u0003u_.,g\u000e\u0005\u0002:[&\u0011aN\u000f\u0002\u0004\u0013:$\u0018\u0001C4fiR{7.\u001a8\u0015\u00031\f1B]3bIJ+7o\u001c7wKR\tA\t")
public class SingleThreadedResourcePoolTrackingTest
extends CypherFunSuite {
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    private ThreadLocalRandom random() {
        return this.random;
    }

    public SingleThreadedResourcePoolTrackingTest() {
        this.test("add and measure", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MemoryMeter meter = new MemoryMeter();
            LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
            SingleThreadedResourcePool pool = new SingleThreadedResourcePool(16, ResourceMonitor$.MODULE$.NOOP(), (MemoryTracker)memoryTracker);
            int iterations = this.random().nextInt(10, 1000);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), iterations).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> pool.add((AutoCloseablePlus)new TestResource()));
            long itemSize = meter.measure((Object)new TestResource()) * (long)iterations;
            long actualSize = meter.measureDeep((Object)pool) - meter.measureDeep((Object)memoryTracker) - meter.measureDeep((Object)ResourceMonitor$.MODULE$.NOOP()) - itemSize;
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)actualSize), new Position("SingleThreadedResourcePoolTrackingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)memoryTracker.estimatedHeapMemory())), (Object)Equality$.MODULE$.default());
            pool.closeAll();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)memoryTracker.estimatedHeapMemory()), new Position("SingleThreadedResourcePoolTrackingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToLong((long)0L));
        }, new Position("SingleThreadedResourcePoolTrackingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
    }

    public static class TestResource
    implements AutoCloseablePlus {
        public void close() {
        }

        public void closeInternal() {
        }

        public boolean isClosed() {
            return false;
        }

        public void setCloseListener(CloseListener closeListener) {
        }

        public void setToken(int token) {
        }

        public int getToken() {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
    }
}

