/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.memory;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.memory.MemoryTrackerForOperatorProvider;
import org.neo4j.cypher.internal.runtime.memory.TrackingQueryMemoryTracker;
import org.neo4j.cypher.internal.runtime.memory.TrackingQueryMemoryTrackerTest$;
import org.neo4j.cypher.internal.runtime.memory.TrackingQueryMemoryTrackerTest$TestMemoryTracker$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%t!\u0002\u0011\"\u0011\u0003qc!\u0002\u0019\"\u0011\u0003\t\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0006\u0001\u000b\u0011B \t\u000f\r\u000b\u0011\u0011!C\u0005\t\u001a!\u0001'\t\u0001N\u0011\u0015Yd\u0001\"\u0001W\r\u0011Af\u0001Q-\t\u0011\tD!Q3A\u0005\u0002yB\u0001b\u0019\u0005\u0003\u0012\u0003\u0006Ia\u0010\u0005\u0006w!!\t\u0001\u001a\u0005\bQ\"\t\t\u0011\"\u0001j\u0011\u001dY\u0007\"%A\u0005\u00021Dqa\u001e\u0005\u0002\u0002\u0013\u0005\u0003\u0010C\u0004}\u0011\u0005\u0005I\u0011A?\t\u0013\u0005\r\u0001\"!A\u0005\u0002\u0005\u0015\u0001\"CA\t\u0011\u0005\u0005I\u0011IA\n\u0011%\t\t\u0003CA\u0001\n\u0003\t\u0019\u0003C\u0005\u0002.!\t\t\u0011\"\u0011\u00020!I\u0011\u0011\u0007\u0005\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003kA\u0011\u0011!C!\u0003o9\u0011\"a\u000f\u0007\u0003\u0003E\t!!\u0010\u0007\u0011a3\u0011\u0011!E\u0001\u0003\u007fAaaO\f\u0005\u0002\u0005-\u0003\"CA\u0019/\u0005\u0005IQIA\u001a\u0011%\tieFA\u0001\n\u0003\u000by\u0005\u0003\u0005\u0002T]\t\n\u0011\"\u0001m\u0011%\t)fFA\u0001\n\u0003\u000b9\u0006\u0003\u0005\u0002d]\t\n\u0011\"\u0001m\u0011!\t)G\u0002b\u0001\n\u0013q\u0004bBA4\r\u0001\u0006IaP\u0001\u001f)J\f7m[5oOF+XM]=NK6|'/\u001f+sC\u000e\\WM\u001d+fgRT!AI\u0012\u0002\r5,Wn\u001c:z\u0015\t!S%A\u0004sk:$\u0018.\\3\u000b\u0005\u0019:\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005!J\u0013AB2za\",'O\u0003\u0002+W\u0005)a.Z85U*\tA&A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00020\u00035\t\u0011E\u0001\u0010Ue\u0006\u001c7.\u001b8h#V,'/_'f[>\u0014\u0018\u0010\u0016:bG.,'\u000fV3tiN\u0019\u0011A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g!\t\u0019\u0014(\u0003\u0002;i\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012AL\u0001\u001e\t\u00163\u0015)\u0016'U?NK%,R0P\r~;%kT,J\u001d\u001e{\u0016I\u0015*B3V\tq\b\u0005\u00024\u0001&\u0011\u0011\t\u000e\u0002\u0005\u0019>tw-\u0001\u0010E\u000b\u001a\u000bU\u000b\u0014+`'&SViX(G?\u001e\u0013vjV%O\u000f~\u000b%KU!ZA\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005)\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0011a\u0017M\\4\u000b\u0003)\u000bAA[1wC&\u0011Aj\u0012\u0002\u0007\u001f\nTWm\u0019;\u0014\u0005\u0019q\u0005CA(U\u001b\u0005\u0001&BA)S\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t\u0019V%\u0001\u0003vi&d\u0017BA+Q\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016$\u0012a\u0016\t\u0003_\u0019\u0011\u0011\u0003V3ti6+Wn\u001c:z)J\f7m[3s'\u0011A!l\u0018\u001d\u0011\u0005mkV\"\u0001/\u000b\u0005\tJ\u0013B\u00010]\u0005IaunY1m\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:\u0011\u0005M\u0002\u0017BA15\u0005\u001d\u0001&o\u001c3vGR\f\u0001\"\\1y\u0005f$Xm]\u0001\n[\u0006D()\u001f;fg\u0002\"\"!Z4\u0011\u0005\u0019DQ\"\u0001\u0004\t\u000f\t\\\u0001\u0013!a\u0001\u007f\u0005!1m\u001c9z)\t)'\u000eC\u0004c\u0019A\u0005\t\u0019A \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tQN\u000b\u0002@].\nq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003iR\n!\"\u00198o_R\fG/[8o\u0013\t1\u0018OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A=\u0011\u0005\u0019S\u0018BA>H\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\ta\u0010\u0005\u00024\u007f&\u0019\u0011\u0011\u0001\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0011Q\u0002\t\u0004g\u0005%\u0011bAA\u0006i\t\u0019\u0011I\\=\t\u0011\u0005=\u0001#!AA\u0002y\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u000b!\u0019\t9\"!\b\u0002\b5\u0011\u0011\u0011\u0004\u0006\u0004\u00037!\u0014AC2pY2,7\r^5p]&!\u0011qDA\r\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\u00121\u0006\t\u0004g\u0005\u001d\u0012bAA\u0015i\t9!i\\8mK\u0006t\u0007\"CA\b%\u0005\u0005\t\u0019AA\u0004\u0003!A\u0017m\u001d5D_\u0012,G#\u0001@\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u0012\u0011\b\u0005\n\u0003\u001f)\u0012\u0011!a\u0001\u0003\u000f\t\u0011\u0003V3ti6+Wn\u001c:z)J\f7m[3s!\t1wc\u0005\u0003\u0018\u0003\u0003B\u0004CBA\"\u0003\u000fzT-\u0004\u0002\u0002F)\u0011A\u0005N\u0005\u0005\u0003\u0013\n)EA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!!\u0010\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u0015\f\t\u0006C\u0004c5A\u0005\t\u0019A \u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002Z\u0005}\u0003\u0003B\u001a\u0002\\}J1!!\u00185\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011\r\u000f\u0002\u0002\u0003\u0007Q-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014AE:ju\u0016|em\u0012:po&tw-\u0011:sCf\f1c]5{K>3wI]8xS:<\u0017I\u001d:bs\u0002\u0002")
public class TrackingQueryMemoryTrackerTest
extends CypherFunSuite {
    private volatile TrackingQueryMemoryTrackerTest$TestMemoryTracker$ TestMemoryTracker$module;
    private final long sizeOfGrowingArray = TrackingQueryMemoryTrackerTest$.MODULE$.DEFAULT_SIZE_OF_GROWING_ARRAY();

    public static long DEFAULT_SIZE_OF_GROWING_ARRAY() {
        return TrackingQueryMemoryTrackerTest$.MODULE$.DEFAULT_SIZE_OF_GROWING_ARRAY();
    }

    public TrackingQueryMemoryTrackerTest$TestMemoryTracker$ TestMemoryTracker() {
        if (this.TestMemoryTracker$module == null) {
            this.TestMemoryTracker$lzycompute$1();
        }
        return this.TestMemoryTracker$module;
    }

    private long sizeOfGrowingArray() {
        return this.sizeOfGrowingArray;
    }

    private final void TestMemoryTracker$lzycompute$1() {
        TrackingQueryMemoryTrackerTest trackingQueryMemoryTrackerTest = this;
        synchronized (trackingQueryMemoryTrackerTest) {
            if (this.TestMemoryTracker$module == null) {
                this.TestMemoryTracker$module = new TrackingQueryMemoryTrackerTest$TestMemoryTracker$(this);
            }
        }
    }

    public TrackingQueryMemoryTrackerTest() {
        this.test("Tracks overall memory high water mark: Single transaction, single operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker txMemoryTracker = new TestMemoryTracker(this, this.TestMemoryTracker().apply$default$1());
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)txMemoryTracker);
            MemoryTracker operator0Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(0);
            operator0Tracker.allocateHeap(10L);
            operator0Tracker.allocateHeap(5L);
            operator0Tracker.releaseHeap(6L);
            operator0Tracker.allocateHeap(4L);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)(15L + this.sizeOfGrowingArray()))));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)txMemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)15L)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(0)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)15L)));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("Tracks overall memory high water mark with AnyValues: Single transaction, single operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker txMemoryTracker = new TestMemoryTracker(this, this.TestMemoryTracker().apply$default$1());
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)txMemoryTracker);
            MemoryTracker operator0Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(0);
            IntValue v1 = Values.intValue((int)5);
            BooleanValue v2 = Values.booleanValue((boolean)true);
            TextValue v3 = Values.stringValue((String)"foo");
            BooleanValue v4 = Values.booleanValue((boolean)false);
            operator0Tracker.allocateHeap(v1.estimatedHeapUsage());
            operator0Tracker.allocateHeap(v3.estimatedHeapUsage());
            operator0Tracker.releaseHeap(v2.estimatedHeapUsage());
            operator0Tracker.allocateHeap(v4.estimatedHeapUsage());
            long expected = Math.max(v1.estimatedHeapUsage() + v3.estimatedHeapUsage(), v1.estimatedHeapUsage() + v3.estimatedHeapUsage() - v2.estimatedHeapUsage() + v4.estimatedHeapUsage());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)(expected + this.sizeOfGrowingArray()))));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)txMemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)expected)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(0)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)expected)));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("Throws exception if operator allocations exceed threshold: Single transaction, single operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker txMemoryTracker = new TestMemoryTracker(this, 20L);
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)txMemoryTracker);
            MemoryTracker operator0Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(0);
            operator0Tracker.allocateHeap(10L);
            operator0Tracker.allocateHeap(5L);
            operator0Tracker.releaseHeap(6L);
            operator0Tracker.allocateHeap(9L);
            return this.a(ClassTag$.MODULE$.apply(MemoryLimitExceededException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> operator0Tracker.allocateHeap(3L));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("Tracks individual memory per operator plus overall: Single transaction, multiple operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker txMemoryTracker = new TestMemoryTracker(this, this.TestMemoryTracker().apply$default$1());
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)txMemoryTracker);
            MemoryTracker operator0Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(0);
            MemoryTracker operator1Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(1);
            MemoryTracker operator2Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(2);
            operator0Tracker.allocateHeap(1L);
            operator2Tracker.allocateHeap(10L);
            operator1Tracker.allocateHeap(2L);
            operator0Tracker.allocateHeap(6L);
            operator0Tracker.releaseHeap(5L);
            operator2Tracker.allocateHeap(3L);
            operator2Tracker.allocateHeap(13L);
            operator2Tracker.allocateHeap(2L);
            operator2Tracker.releaseHeap(21L);
            operator0Tracker.allocateHeap(8L);
            operator1Tracker.allocateHeap(4L);
            operator1Tracker.releaseHeap(2L);
            operator1Tracker.allocateHeap(7L);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(0)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)10L)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(1)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)11L)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(2)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)28L)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)txMemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)32L)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)(32L + this.sizeOfGrowingArray()))));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("Throws exception if operator allocations exceed threshold: Single transaction, multiple operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker txMemoryTracker = new TestMemoryTracker(this, 20L);
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)txMemoryTracker);
            MemoryTracker operator0Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(0);
            MemoryTracker operator1Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(1);
            MemoryTracker operator2Tracker = memoryTrackerForOperatorProvider.memoryTrackerForOperator(2);
            operator0Tracker.allocateHeap(10L);
            operator1Tracker.allocateHeap(5L);
            operator0Tracker.releaseHeap(6L);
            operator1Tracker.allocateHeap(9L);
            return this.a(ClassTag$.MODULE$.apply(MemoryLimitExceededException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> operator2Tracker.allocateHeap(3L));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("Tracks overall memory high water mark and memory per transaction: Multiple transactions, single operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker tx0MemoryTracker = new TestMemoryTracker(this, this.TestMemoryTracker().apply$default$1());
            TestMemoryTracker tx1MemoryTracker = new TestMemoryTracker(this, this.TestMemoryTracker().apply$default$1());
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider0 = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)tx0MemoryTracker);
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider1 = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)tx1MemoryTracker);
            MemoryTracker operator0Tx0Tracker = memoryTrackerForOperatorProvider0.memoryTrackerForOperator(0);
            MemoryTracker operator0Tx1Tracker = memoryTrackerForOperatorProvider1.memoryTrackerForOperator(0);
            operator0Tx0Tracker.allocateHeap(10L);
            operator0Tx1Tracker.allocateHeap(5L);
            operator0Tx0Tracker.releaseHeap(6L);
            operator0Tx1Tracker.allocateHeap(4L);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)(15L + this.sizeOfGrowingArray()))));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(0)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)15L)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tx0MemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)10L)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tx1MemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)9L)));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("Throws exception if operator allocations exceed threshold: Multiple transactions, single operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker tx0MemoryTracker = new TestMemoryTracker(this, 20L);
            TestMemoryTracker tx1MemoryTracker = new TestMemoryTracker(this, 15L);
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider0 = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)tx0MemoryTracker);
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider1 = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)tx1MemoryTracker);
            MemoryTracker operator0Tx0Tracker = memoryTrackerForOperatorProvider0.memoryTrackerForOperator(0);
            MemoryTracker operator0Tx1Tracker = memoryTrackerForOperatorProvider1.memoryTrackerForOperator(0);
            operator0Tx0Tracker.allocateHeap(10L);
            operator0Tx0Tracker.allocateHeap(5L);
            operator0Tx0Tracker.releaseHeap(6L);
            operator0Tx0Tracker.allocateHeap(9L);
            this.a(ClassTag$.MODULE$.apply(MemoryLimitExceededException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> operator0Tx0Tracker.allocateHeap(3L));
            operator0Tx1Tracker.allocateHeap(10L);
            operator0Tx1Tracker.allocateHeap(4L);
            operator0Tx1Tracker.releaseHeap(6L);
            return this.a(ClassTag$.MODULE$.apply(MemoryLimitExceededException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> operator0Tx1Tracker.allocateHeap(9L));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("Throws exception if operator allocations exceed threshold: Multiple transactions, multiple operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker tx0MemoryTracker = new TestMemoryTracker(this, 20L);
            TestMemoryTracker tx1MemoryTracker = new TestMemoryTracker(this, 15L);
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider0 = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)tx0MemoryTracker);
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider1 = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)tx1MemoryTracker);
            MemoryTracker operator0Tx0Tracker = memoryTrackerForOperatorProvider0.memoryTrackerForOperator(0);
            MemoryTracker operator0Tx1Tracker = memoryTrackerForOperatorProvider1.memoryTrackerForOperator(0);
            MemoryTracker operator1Tx0Tracker = memoryTrackerForOperatorProvider0.memoryTrackerForOperator(1);
            MemoryTracker operator1Tx1Tracker = memoryTrackerForOperatorProvider1.memoryTrackerForOperator(1);
            operator0Tx0Tracker.allocateHeap(10L);
            operator1Tx0Tracker.allocateHeap(5L);
            operator0Tx0Tracker.releaseHeap(6L);
            operator1Tx0Tracker.allocateHeap(9L);
            this.a(ClassTag$.MODULE$.apply(MemoryLimitExceededException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> operator0Tx0Tracker.allocateHeap(3L));
            operator0Tx1Tracker.allocateHeap(10L);
            operator1Tx1Tracker.allocateHeap(4L);
            operator0Tx1Tracker.releaseHeap(6L);
            return this.a(ClassTag$.MODULE$.apply(MemoryLimitExceededException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> operator1Tx1Tracker.allocateHeap(9L));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        this.test("Tracks individual memory per operator and per transaction plus overall: Multiple transactions, multiple operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TrackingQueryMemoryTracker queryMemoryTracker = new TrackingQueryMemoryTracker();
            TestMemoryTracker tx0MemoryTracker = new TestMemoryTracker(this, this.TestMemoryTracker().apply$default$1());
            TestMemoryTracker tx1MemoryTracker = new TestMemoryTracker(this, this.TestMemoryTracker().apply$default$1());
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider0 = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)tx0MemoryTracker);
            MemoryTrackerForOperatorProvider memoryTrackerForOperatorProvider1 = queryMemoryTracker.newMemoryTrackerForOperatorProvider((MemoryTracker)tx1MemoryTracker);
            MemoryTracker operator0Tx0Tracker = memoryTrackerForOperatorProvider0.memoryTrackerForOperator(0);
            MemoryTracker operator1Tx0Tracker = memoryTrackerForOperatorProvider0.memoryTrackerForOperator(1);
            MemoryTracker operator2Tx0Tracker = memoryTrackerForOperatorProvider0.memoryTrackerForOperator(2);
            MemoryTracker operator0Tx1Tracker = memoryTrackerForOperatorProvider1.memoryTrackerForOperator(0);
            MemoryTracker operator1Tx1Tracker = memoryTrackerForOperatorProvider1.memoryTrackerForOperator(1);
            MemoryTracker operator2Tx1Tracker = memoryTrackerForOperatorProvider1.memoryTrackerForOperator(2);
            operator0Tx0Tracker.allocateHeap(1L);
            operator2Tx1Tracker.allocateHeap(10L);
            operator1Tx1Tracker.allocateHeap(2L);
            operator0Tx1Tracker.allocateHeap(6L);
            operator0Tx1Tracker.releaseHeap(5L);
            operator2Tx0Tracker.allocateHeap(3L);
            operator2Tx0Tracker.allocateHeap(13L);
            operator2Tx1Tracker.allocateHeap(2L);
            operator2Tx0Tracker.releaseHeap(14L);
            operator0Tx1Tracker.allocateHeap(8L);
            operator1Tx0Tracker.allocateHeap(4L);
            operator1Tx0Tracker.releaseHeap(2L);
            operator1Tx1Tracker.allocateHeap(7L);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(0)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)10L)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(1)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)11L)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMarkOfOperator(2)), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)28L)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tx0MemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)17L)));
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tx1MemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)30L)));
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)queryMemoryTracker.heapHighWaterMark()), new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)(35L + this.sizeOfGrowingArray()))));
        }, new Position("TrackingQueryMemoryTrackerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
    }

    public class TestMemoryTracker
    extends LocalMemoryTracker
    implements Product,
    scala.Serializable {
        private final long maxBytes;
        public final /* synthetic */ TrackingQueryMemoryTrackerTest $outer;

        public long maxBytes() {
            return this.maxBytes;
        }

        public TestMemoryTracker copy(long maxBytes) {
            return new TestMemoryTracker(this.org$neo4j$cypher$internal$runtime$memory$TrackingQueryMemoryTrackerTest$TestMemoryTracker$$$outer(), maxBytes);
        }

        public long copy$default$1() {
            return this.maxBytes();
        }

        public String productPrefix() {
            return "TestMemoryTracker";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return BoxesRunTime.boxToLong((long)this.maxBytes());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestMemoryTracker;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.maxBytes()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestMemoryTracker)) return false;
            if (((TestMemoryTracker)((Object)object)).org$neo4j$cypher$internal$runtime$memory$TrackingQueryMemoryTrackerTest$TestMemoryTracker$$$outer() != this.org$neo4j$cypher$internal$runtime$memory$TrackingQueryMemoryTrackerTest$TestMemoryTracker$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestMemoryTracker testMemoryTracker = (TestMemoryTracker)((Object)x$1);
            if (this.maxBytes() != testMemoryTracker.maxBytes()) return false;
            if (!testMemoryTracker.canEqual((Object)this)) return false;
            return true;
        }

        public /* synthetic */ TrackingQueryMemoryTrackerTest org$neo4j$cypher$internal$runtime$memory$TrackingQueryMemoryTrackerTest$TestMemoryTracker$$$outer() {
            return this.$outer;
        }

        public TestMemoryTracker(TrackingQueryMemoryTrackerTest $outer, long maxBytes) {
            this.maxBytes = maxBytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super((MemoryPool)MemoryPools.NO_TRACKING, maxBytes, 0L, null);
            Product.$init$((Product)this);
        }
    }
}

