/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.neo4j.cypher.operations.InCache;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

class InCacheTest {
    InCacheTest() {
    }

    @Test
    void shouldHandleListWithNoNulls() {
        InCache cache = new InCache();
        ListValue list = VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"a"), Values.stringValue((String)"b"), Values.stringValue((String)"c")});
        Map<Value, Value> expected = Map.of(Values.stringValue((String)"a"), Values.TRUE, Values.stringValue((String)"b"), Values.TRUE, Values.stringValue((String)"c"), Values.TRUE, Values.stringValue((String)"d"), Values.FALSE, Values.NO_VALUE, Values.NO_VALUE);
        for (Map.Entry<Value, Value> entry : InCacheTest.shuffled(expected)) {
            Assertions.assertThat((Object)cache.check((AnyValue)entry.getKey(), list, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEqualTo((Object)entry.getValue());
        }
    }

    @Test
    void shouldHandleListContainingNulls() {
        InCache cache = new InCache();
        ListValue list = VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"a"), Values.NO_VALUE, Values.stringValue((String)"c"), Values.NO_VALUE});
        Map<Value, Value> expected = Map.of(Values.stringValue((String)"a"), Values.TRUE, Values.stringValue((String)"b"), Values.NO_VALUE, Values.stringValue((String)"c"), Values.TRUE, Values.stringValue((String)"d"), Values.NO_VALUE, Values.NO_VALUE, Values.NO_VALUE);
        for (Map.Entry<Value, Value> entry : InCacheTest.shuffled(expected)) {
            Assertions.assertThat((Object)cache.check((AnyValue)entry.getKey(), list, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEqualTo((Object)entry.getValue());
        }
    }

    @Test
    void shouldHandleEmptyListAndNull() {
        InCache cache = new InCache();
        Value check = cache.check((AnyValue)Values.NO_VALUE, VirtualValues.EMPTY_LIST, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((Object)check).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void shouldTrackMemory() {
        InCache cache = new InCache();
        ListValue list = VirtualValues.range((long)1L, (long)256L, (long)1L);
        MemoryTracker memoryTracker = (MemoryTracker)Mockito.mock(MemoryTracker.class);
        cache.check((AnyValue)Values.longValue((long)1L), list, memoryTracker);
        cache.check((AnyValue)Values.longValue((long)2L), list, memoryTracker);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Long.class);
        ((MemoryTracker)Mockito.verify((Object)memoryTracker)).allocateHeap(((Long)arg.capture()).longValue());
        Assertions.assertThat((Long)((Long)arg.getValue())).isGreaterThan(0L);
    }

    @Test
    void shouldHandleArraysWithNulls() {
        InCache cache = new InCache();
        ListValue list = VirtualValues.list((AnyValue[])new AnyValue[]{VirtualValues.list((AnyValue[])new AnyValue[]{Values.intValue((int)1), Values.intValue((int)2)}), VirtualValues.list((AnyValue[])new AnyValue[]{Values.intValue((int)3), Values.intValue((int)4)})});
        org.junit.jupiter.api.Assertions.assertEquals((Object)BooleanValue.FALSE, (Object)cache.check((AnyValue)Values.intValue((int)0), list, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)cache.check((AnyValue)VirtualValues.list((AnyValue[])new AnyValue[]{Values.intValue((int)1), Values.NO_VALUE}), list, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
    }

    @Test
    void shouldHandleMapsWithNulls() {
        InCache cache = new InCache();
        ListValue list = VirtualValues.list((AnyValue[])new AnyValue[]{VirtualValues.map((String[])new String[]{"a"}, (AnyValue[])new AnyValue[]{Values.intValue((int)1)})});
        org.junit.jupiter.api.Assertions.assertEquals((Object)BooleanValue.FALSE, (Object)cache.check((AnyValue)Values.intValue((int)0), list, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.NO_VALUE, (Object)cache.check((AnyValue)VirtualValues.map((String[])new String[]{"a"}, (AnyValue[])new AnyValue[]{Values.NO_VALUE}), list, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
    }

    @Test
    void shouldCloseCacheThatIsNeverUsed() {
        new InCache().close();
    }

    @Test
    void shouldCloseCacheThatIsUsedOnce() {
        InCache cache = new InCache();
        ListValue list = VirtualValues.range((long)1L, (long)256L, (long)1L);
        cache.check((AnyValue)Values.intValue((int)0), list, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        cache.close();
    }

    private static <K, V> Iterable<Map.Entry<K, V>> shuffled(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.shuffle(list);
        return list;
    }
}

