/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.cypher.operations.SimpleIdentityCache;

class SimpleIdentityCacheTest {
    SimpleIdentityCacheTest() {
    }

    @Test
    void shouldCacheAndGet() {
        SimpleIdentityCache cache = new SimpleIdentityCache(5);
        Object k1 = new Object();
        Object k2 = new Object();
        Object k3 = new Object();
        CountingSupplier<String> v1 = new CountingSupplier<String>("hello");
        CountingSupplier<String> v2 = new CountingSupplier<String>("there");
        CountingSupplier<String> v3 = new CountingSupplier<String>("again");
        Object notThere = new Object();
        Assertions.assertThat((String)((String)cache.getOrCache(k1, v1))).isEqualTo("hello");
        Assertions.assertThat((String)((String)cache.getOrCache(k2, v2))).isEqualTo("there");
        Assertions.assertThat((String)((String)cache.getOrCache(k3, v3))).isEqualTo("again");
        Assertions.assertThat((String)((String)cache.get(notThere))).isNull();
        Assertions.assertThat((int)v1.count).isEqualTo(1);
        Assertions.assertThat((int)v2.count).isEqualTo(1);
        Assertions.assertThat((int)v3.count).isEqualTo(1);
    }

    @Test
    void shouldCache() {
        SimpleIdentityCache cache = new SimpleIdentityCache(5);
        Object k1 = new Object();
        CountingSupplier<String> v1 = new CountingSupplier<String>("hello");
        Assertions.assertThat((String)((String)cache.getOrCache(k1, v1))).isEqualTo("hello");
        Assertions.assertThat((String)((String)cache.getOrCache(k1, v1))).isEqualTo("hello");
        Assertions.assertThat((String)((String)cache.getOrCache(k1, v1))).isEqualTo("hello");
        Assertions.assertThat((int)v1.count).isEqualTo(1);
    }

    @Test
    void shouldOnlyCompareKeysByIdentity() {
        List<Integer> key1 = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        List<Integer> copy = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        SimpleIdentityCache cache = new SimpleIdentityCache(5);
        cache.getOrCache(key1, v -> "hello");
        Assertions.assertThat(key1).isEqualTo(copy);
        Assertions.assertThat((String)((String)cache.get(key1))).isEqualTo("hello");
        Assertions.assertThat((String)((String)cache.get(copy))).isNull();
    }

    @Test
    void shouldEvictOldest() {
        Object k1 = new Object();
        Object k2 = new Object();
        Object k3 = new Object();
        Object k4 = new Object();
        SimpleIdentityCache cache = new SimpleIdentityCache(3);
        cache.getOrCache(k1, v -> "a");
        cache.getOrCache(k2, v -> "b");
        cache.getOrCache(k3, v -> "c");
        cache.getOrCache(k4, v -> "d");
        Assertions.assertThat((String)((String)cache.get(k1))).isNull();
        Assertions.assertThat((String)((String)cache.get(k2))).isEqualTo("b");
        Assertions.assertThat((String)((String)cache.get(k3))).isEqualTo("c");
        Assertions.assertThat((String)((String)cache.get(k4))).isEqualTo("d");
    }

    @Test
    void shouldSeePreviousValueWhenEvicting() {
        Object k1 = new Object();
        Object k2 = new Object();
        Object k3 = new Object();
        Object k4 = new Object();
        SimpleIdentityCache cache = new SimpleIdentityCache(3);
        cache.getOrCache(k1, v -> "a");
        cache.getOrCache(k2, v -> "b");
        cache.getOrCache(k3, v -> "c");
        cache.getOrCache(k4, v -> {
            Assertions.assertThat((String)v).isEqualTo("a");
            return "d";
        });
        cache.getOrCache(k1, v -> {
            Assertions.assertThat((String)v).isEqualTo("b");
            return "e";
        });
        cache.getOrCache(k2, v -> {
            Assertions.assertThat((String)v).isEqualTo("c");
            return "f";
        });
    }

    @Test
    void shouldForeach() {
        Object k1 = new Object();
        Object k2 = new Object();
        Object k3 = new Object();
        SimpleIdentityCache cache = new SimpleIdentityCache(7);
        cache.getOrCache(k1, v -> "a");
        cache.getOrCache(k2, v -> "b");
        cache.getOrCache(k3, v -> "c");
        cache.foreach((k, v) -> {
            if (k == k1) {
                Assertions.assertThat((String)v).isEqualTo("a");
            } else if (k == k2) {
                Assertions.assertThat((String)v).isEqualTo("b");
            } else if (k == k3) {
                Assertions.assertThat((String)v).isEqualTo("c");
            } else {
                Assertions.fail((String)"Unknown key and value, k=%s, v=%s", (Object[])new Object[]{k, v});
            }
        });
    }

    static class CountingSupplier<V>
    implements Function<V, V> {
        private final V value;
        private int count;

        CountingSupplier(V value) {
            this.value = value;
        }

        @Override
        public V apply(V ignore) {
            ++this.count;
            return this.value;
        }
    }
}

