/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.cypher.operations.CypherFunctions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

class WithinBBoxTest {
    private final Random random = ThreadLocalRandom.current();
    private static final int ITERATIONS = 1000;

    WithinBBoxTest() {
    }

    @Test
    void testInclusivePoints() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{this.random.nextDouble(), this.random.nextDouble()}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        }
    }

    @Test
    void testBoundaryPoints() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, this.random.nextDouble()}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
            Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, this.random.nextDouble()}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
            Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{this.random.nextDouble(), 0.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
            Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{this.random.nextDouble(), 1.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        }
    }

    @Test
    void testPointsOutsideBBox() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{2.0, 2.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{3.0, 3.0});
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{this.random.nextDouble(), this.random.nextDouble()}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        }
    }

    @Test
    void testNullInNullOut() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((AnyValue)Values.NO_VALUE, (AnyValue)lowerLeft, (AnyValue)upperRight)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((AnyValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{this.random.nextDouble(), this.random.nextDouble()}), (AnyValue)Values.NO_VALUE, (AnyValue)upperRight)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((AnyValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{this.random.nextDouble(), this.random.nextDouble()}), (AnyValue)lowerLeft, (AnyValue)Values.NO_VALUE)).isEqualTo((Object)Values.NO_VALUE);
    }

    @Test
    void testInvalidTypes() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((AnyValue)Values.longValue((long)15L), (AnyValue)lowerLeft, (AnyValue)upperRight)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((AnyValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{this.random.nextDouble(), this.random.nextDouble()}), (AnyValue)Values.stringValue((String)"I'm a point"), (AnyValue)upperRight)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((AnyValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{this.random.nextDouble(), this.random.nextDouble()}), (AnyValue)lowerLeft, (AnyValue)Values.TRUE)).isEqualTo((Object)Values.NO_VALUE);
    }

    @Test
    void testDifferentCRS() {
        PointValue a = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.0, 0.0});
        PointValue b = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 1.0});
        PointValue c = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.0, 1.0, 1.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)a, (PointValue)a)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)a, (PointValue)b)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)a, (PointValue)c)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)b, (PointValue)a)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)b, (PointValue)b)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)b, (PointValue)c)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)c, (PointValue)a)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)c, (PointValue)b)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)a, (PointValue)c, (PointValue)c)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)a, (PointValue)a)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)a, (PointValue)b)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)a, (PointValue)c)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)b, (PointValue)a)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)b, (PointValue)b)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)b, (PointValue)c)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)c, (PointValue)a)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)c, (PointValue)b)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)b, (PointValue)c, (PointValue)c)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)a, (PointValue)a)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)a, (PointValue)b)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)a, (PointValue)c)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)b, (PointValue)a)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)b, (PointValue)b)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)b, (PointValue)c)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)c, (PointValue)a)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)c, (PointValue)b)).isEqualTo((Object)Values.NO_VALUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)c, (PointValue)c, (PointValue)c)).isEqualTo((Object)Values.TRUE);
    }

    @Test
    void handleCrossing0thMeridian() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-1.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 66.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-1.5, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-1.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.5, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.5, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.5, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleCrossing180thMeridian() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{179.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-179.0, 66.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{178.5, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{179.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{179.5, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{180.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-179.5, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-179.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-178.5, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleCrossingTheEquator() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{10.0, -1.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{20.0, 1.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.0, -1.5}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.0, -1.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.0, -0.5}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.0, 0.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.0, 0.5}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.0, 1.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{15.0, 1.5}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftWestOfUpperRightWesternHemisphere() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{10.0, 66.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{11.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{10.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{9.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{5.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-1.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftEastOfUpperRightWesternHemisphere() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{10.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 66.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{11.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{10.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{9.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{5.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-1.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
    }

    @Test
    void handleLowerWestOfUpperRightEasternHemisphere() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-160.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-150.0, 66.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-140.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-150.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-151.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-155.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-159.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-160.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-170.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftEastOfUpperRightEasternHemisphere() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-150.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-160.0, 66.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-140.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-150.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-151.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-155.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-159.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-160.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-170.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
    }

    @Test
    void handleLowerWestOfUpperRightCrossingHemispheres() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{175.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-175.0, 66.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{170.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{175.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{180.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-175.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-170.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftEastOfUpperRightCrossingHemispheres() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-175.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{175.0, 66.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{170.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{175.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{180.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-175.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-170.0, 63.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
    }

    @Test
    void handleLowerLeftSouthOfUpperRightNorthernHemisphere() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{40.0, 70.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 55.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 60.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 65.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 70.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 75.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftNorthOfUpperNorthernHemisphere() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 70.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{40.0, 60.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 55.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 60.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 65.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 70.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 75.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftSouthOfUpperRightSouthernHemisphere() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, -70.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{40.0, -60.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -55.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -60.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -65.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -70.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -75.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftNorthOfUpperRightSouthernHemisphere() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, -60.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{40.0, -70.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 55.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -55.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -60.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -65.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -70.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -75.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftSouthOfUpperRightCrossingEquator() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, -10.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{40.0, 10.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -15.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -10.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 0.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 10.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.TRUE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 15.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleLowerLeftNorthOfUpperRightCrossingEquator() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 10.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{40.0, -10.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -15.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, -10.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 0.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 10.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 15.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }

    @Test
    void handleBothDirectionsShifted() {
        PointValue lowerLeft = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{40.0, 40.0});
        PointValue upperRight = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 30.0});
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{45.0, 30.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{40.0, 30.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{35.0, 30.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 30.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{25.0, 30.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 45.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 40.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 35.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 30.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
        Assertions.assertThat((Object)CypherFunctions.withinBBox((PointValue)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{30.0, 25.0}), (PointValue)lowerLeft, (PointValue)upperRight)).isEqualTo((Object)Values.FALSE);
    }
}

