/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.function.Consumer;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public class PathValueBuilder
implements Consumer<RelationshipVisitor> {
    private final MutableLongList nodes = LongLists.mutable.empty();
    private final MutableLongList rels = LongLists.mutable.empty();
    private final DbAccess dbAccess;
    private final RelationshipScanCursor cursor;
    private boolean seenNoValue;

    public PathValueBuilder(DbAccess dbAccess, RelationshipScanCursor cursor) {
        this.dbAccess = dbAccess;
        this.cursor = cursor;
    }

    public AnyValue build() {
        return this.seenNoValue ? Values.NO_VALUE : VirtualValues.pathReference((long[])this.nodes.toArray(), (long[])this.rels.toArray());
    }

    public void addNodeFromList(AnyValue value, int offset) {
        if (this.notNoValue(value)) {
            if (value instanceof ListValue) {
                this.addNode(((ListValue)value).value(offset));
            } else {
                throw new CypherTypeException("Expected list but found: " + value);
            }
        }
    }

    public void addNode(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addNode((VirtualNodeValue)value);
        }
    }

    public void addRelationshipFromList(AnyValue value, int offset) {
        if (this.notNoValue(value)) {
            if (value instanceof ListValue) {
                this.addRelationship(((ListValue)value).value(offset));
            } else {
                throw new CypherTypeException("Expected list but found: " + value);
            }
        }
    }

    public void addRelationship(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addRelationship((VirtualRelationshipValue)value);
        }
    }

    public void addRelationship(VirtualRelationshipValue value) {
        this.rels.add(value.id());
    }

    public void addNode(VirtualNodeValue nodeValue) {
        this.nodes.add(nodeValue.id());
    }

    public void addIncoming(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addIncoming((VirtualRelationshipValue)value);
        }
    }

    public void addIncoming(VirtualRelationshipValue relationship) {
        this.nodes.add(relationship.startNodeId((Consumer)this));
        this.rels.add(relationship.id());
    }

    public void addOutgoing(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addOutgoing((VirtualRelationshipValue)value);
        }
    }

    public void addOutgoing(VirtualRelationshipValue relationship) {
        this.nodes.add(relationship.endNodeId((Consumer)this));
        this.rels.add(relationship.id());
    }

    private void add(long relationship, long nextNode) {
        this.rels.add(relationship);
        this.nodes.add(nextNode);
    }

    public void addUndirected(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addUndirected((VirtualRelationshipValue)value);
        }
    }

    public void addUndirected(VirtualRelationshipValue relationship) {
        long previous = this.nodes.get(this.nodes.size() - 1);
        long start = relationship.startNodeId((Consumer)this);
        long end = relationship.endNodeId((Consumer)this);
        if (previous == start) {
            this.add(relationship.id(), end);
        } else {
            this.add(relationship.id(), start);
        }
    }

    public void addMultipleIncoming(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleIncoming((ListValue)value, (VirtualNodeValue)target);
        }
    }

    public void addMultipleIncoming(ListValue relationships, VirtualNodeValue target) {
        int i;
        if (relationships.isEmpty()) {
            return;
        }
        for (i = 0; i < relationships.size() - 1; ++i) {
            AnyValue value = relationships.value(i);
            if (!this.notNoValue(value)) continue;
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)value;
            this.nodes.add(relationship.startNodeId((Consumer)this));
            this.rels.add(relationship.id());
        }
        AnyValue last = relationships.value(i);
        if (this.notNoValue(last)) {
            this.nodes.add(target.id());
            this.rels.add(((VirtualRelationshipValue)last).id());
        }
    }

    public void addMultipleIncoming(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleIncoming((ListValue)value);
        }
    }

    public void addMultipleIncoming(ListValue relationships) {
        for (AnyValue value : relationships) {
            if (!this.notNoValue(value)) continue;
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)value;
            this.nodes.add(relationship.startNodeId((Consumer)this));
            this.rels.add(relationship.id());
        }
    }

    public void addMultipleOutgoing(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleOutgoing((ListValue)value, (VirtualNodeValue)target);
        }
    }

    public void addMultipleOutgoing(ListValue relationships, VirtualNodeValue target) {
        int i;
        if (relationships.isEmpty()) {
            return;
        }
        for (i = 0; i < relationships.size() - 1; ++i) {
            AnyValue value = relationships.value(i);
            if (!this.notNoValue(value)) continue;
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)value;
            this.nodes.add(relationship.endNodeId((Consumer)this));
            this.rels.add(relationship.id());
        }
        AnyValue last = relationships.value(i);
        if (this.notNoValue(last)) {
            this.rels.add(((VirtualRelationshipValue)last).id());
            this.nodes.add(target.id());
        }
    }

    public void addMultipleOutgoing(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleOutgoing((ListValue)value);
        }
    }

    public void addMultipleOutgoing(ListValue relationships) {
        for (AnyValue value : relationships) {
            if (!this.notNoValue(value)) continue;
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)value;
            this.nodes.add(relationship.endNodeId((Consumer)this));
            this.rels.add(relationship.id());
        }
    }

    public void addMultipleUndirected(AnyValue value, AnyValue target) {
        if (this.notNoValue(value) && this.notNoValue(target)) {
            this.addMultipleUndirected((ListValue)value, (VirtualNodeValue)target);
        }
    }

    public void addMultipleUndirected(ListValue relationships, VirtualNodeValue target) {
        if (relationships.isEmpty()) {
            return;
        }
        for (int i = 0; i < relationships.size() - 1; ++i) {
            AnyValue value = relationships.value(i);
            if (!this.notNoValue(value)) continue;
            this.addUndirected((VirtualRelationshipValue)value);
        }
        AnyValue last = relationships.value(relationships.size() - 1);
        if (this.notNoValue(last)) {
            this.rels.add(((VirtualRelationshipValue)last).id());
            this.nodes.add(target.id());
        }
    }

    public void addMultipleUndirected(AnyValue value) {
        if (this.notNoValue(value)) {
            this.addMultipleUndirected((ListValue)value);
        }
    }

    public void addMultipleUndirected(ListValue relationships) {
        if (relationships.isEmpty()) {
            return;
        }
        long previous = this.nodes.get(this.nodes.size() - 1);
        VirtualRelationshipValue first = (VirtualRelationshipValue)relationships.head();
        for (AnyValue value : relationships) {
            if (!this.notNoValue(value)) continue;
            this.addUndirected((VirtualRelationshipValue)value);
        }
    }

    @Override
    public void accept(RelationshipVisitor relationshipVisitor) {
        this.dbAccess.singleRelationship(relationshipVisitor.id(), this.cursor);
        this.cursor.next();
        relationshipVisitor.visit(this.cursor.sourceNodeReference(), this.cursor.targetNodeReference(), this.cursor.type());
    }

    private boolean notNoValue(AnyValue value) {
        if (!this.seenNoValue && value == Values.NO_VALUE) {
            this.seenNoValue = true;
        }
        return !this.seenNoValue;
    }
}

