/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongHashSet;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.helpers.traversal.PathTracingIterator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.PathReference;

public class BiDirectionalBFS
implements AutoCloseable {
    final int maxDepth;
    private final BFS sourceBFS;
    private final BFS targetBFS;
    private State algorithmState;

    public BiDirectionalBFS(long sourceNodeId, long targetNodeId, int[] types, SemanticDirection direction, int maxDepth, boolean stopAsapAtIntersect, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter, boolean needOnlyOnePath) {
        this.maxDepth = maxDepth;
        if (needOnlyOnePath) {
            this.sourceBFS = new SinglePathBFS(sourceNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath);
            this.targetBFS = new SinglePathBFS(targetNodeId, types, direction.reversed(), read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath);
        } else if (stopAsapAtIntersect) {
            this.sourceBFS = new LazyBFS(sourceNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath);
            this.targetBFS = new LazyBFS(targetNodeId, types, direction.reversed(), read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath);
        } else {
            this.sourceBFS = new EagerBFS(sourceNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath);
            this.targetBFS = new EagerBFS(targetNodeId, types, direction.reversed(), read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath);
        }
        this.sourceBFS.setOther(this.targetBFS);
        this.targetBFS.setOther(this.sourceBFS);
        this.algorithmState = State.CAN_SEARCH_FOR_INTERSECTION;
    }

    private BiDirectionalBFS(int[] types, SemanticDirection direction, int maxDepth, boolean stopAsapAtIntersect, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, Boolean needOnlyOnePath) {
        this(-1L, -1L, types, direction, maxDepth, stopAsapAtIntersect, read, nodeCursor, relCursor, memoryTracker, null, null, needOnlyOnePath);
        this.algorithmState = State.NOT_INITIALIZED_WITH_NODES;
    }

    public static BiDirectionalBFS newEmptyBiDirectionalBFS(int[] types, SemanticDirection direction, int maxDepth, boolean stopAsapAtIntersect, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, boolean needOnlyOnePath) {
        return new BiDirectionalBFS(types, direction, maxDepth, stopAsapAtIntersect, read, nodeCursor, relCursor, memoryTracker, needOnlyOnePath);
    }

    public static BiDirectionalBFS newEmptyBiDirectionalBFS(int[] types, SemanticDirection direction, int maxDepth, boolean stopAsapAtIntersect, Read read, MemoryTracker memoryTracker, boolean needOnlyOnePath) {
        return new BiDirectionalBFS(types, direction, maxDepth, stopAsapAtIntersect, read, null, null, memoryTracker, needOnlyOnePath);
    }

    public void resetForNewRow(long sourceNodeId, long targetNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
        this.sourceBFS.resetWithStartNode(sourceNodeId, nodeFilter, relFilter);
        this.targetBFS.resetWithStartNode(targetNodeId, nodeFilter, relFilter);
        this.algorithmState = State.CAN_SEARCH_FOR_INTERSECTION;
    }

    public void resetForNewRow(long sourceNodeId, long targetNodeId, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
        this.sourceBFS.resetWithStartNode(sourceNodeId, nodeCursor, relCursor, nodeFilter, relFilter);
        this.targetBFS.resetWithStartNode(targetNodeId, nodeCursor, relCursor, nodeFilter, relFilter);
        this.algorithmState = State.CAN_SEARCH_FOR_INTERSECTION;
    }

    public Iterator<PathReference> shortestPathIterator() {
        assert (this.algorithmState == State.CAN_SEARCH_FOR_INTERSECTION);
        if (this.sourceBFS.startNodeId == this.targetBFS.startNodeId) {
            return new PathTracingIterator(PrimitiveLongCollections.single((long)this.sourceBFS.startNodeId), this.sourceBFS.currentDepth, this.targetBFS.currentDepth, this.sourceBFS.pathTraceData, this.targetBFS.pathTraceData, this.sourceBFS.needOnlyOnePath);
        }
        BFS bfsToAdvance = null;
        int depth = 0;
        while (this.algorithmState == State.CAN_SEARCH_FOR_INTERSECTION) {
            if (depth++ == this.maxDepth) {
                this.algorithmState = State.REACHED_MAX_DEPTH;
                continue;
            }
            bfsToAdvance = BiDirectionalBFS.pickBFSWithSmallestCurrentLevelSet(this.sourceBFS, this.targetBFS);
            this.algorithmState = bfsToAdvance.searchForIntersectionInNextLevel();
        }
        if (this.algorithmState == State.THERE_IS_NO_INTERSECTION || this.algorithmState == State.REACHED_MAX_DEPTH) {
            return Collections.emptyIterator();
        }
        return new PathTracingIterator(bfsToAdvance.intersectionIterator(), this.sourceBFS.currentDepth, this.targetBFS.currentDepth, this.sourceBFS.pathTraceData, this.targetBFS.pathTraceData, this.sourceBFS.needOnlyOnePath);
    }

    private static BFS pickBFSWithSmallestCurrentLevelSet(BFS bfs1, BFS bfs2) {
        return bfs1.currentLevel.size() > bfs2.currentLevel.size() ? bfs2 : bfs1;
    }

    @Override
    public void close() {
        this.sourceBFS.close();
        this.targetBFS.close();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.sourceBFS.setTracer(tracer);
        this.targetBFS.setTracer(tracer);
    }

    private static class SinglePathBFS
    extends BFS<PathTraceStep> {
        private long foundIntersectionNode = -1L;

        public SinglePathBFS(long startNodeId, int[] types, SemanticDirection direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter, boolean needOnlyOnePath) {
            super(startNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath);
        }

        @Override
        public State searchForIntersectionInNextLevel() {
            if (this.currentLevel.size() == 0) {
                return State.THERE_IS_NO_INTERSECTION;
            }
            this.populateNextLevelOrStopWhenFoundFirstIntersectionNode();
            if (this.foundIntersectionNode != -1L) {
                ++this.currentDepth;
                return State.FOUND_INTERSECTION;
            }
            this.advanceLevel();
            return State.CAN_SEARCH_FOR_INTERSECTION;
        }

        @Override
        public LongIterator intersectionIterator() {
            return new LongIterator(){
                boolean consumedFirst = false;

                public long next() {
                    return foundIntersectionNode;
                }

                public boolean hasNext() {
                    if (!this.consumedFirst) {
                        this.consumedFirst = true;
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        protected boolean addNodeToNextLevelIfQualifies(long currentNode, long foundNode) {
            if (this.hasSeenNode(foundNode) || !this.nodeFilter.test(foundNode)) {
                return false;
            }
            this.nextLevel.add(foundNode);
            this.pathTraceData.put(foundNode, (Object)new PathTraceStep(this.selectionCursor.reference(), currentNode));
            return true;
        }

        private void populateNextLevelOrStopWhenFoundFirstIntersectionNode() {
            while (this.currentLevelItr.hasNext()) {
                long currentNode = this.currentLevelItr.next();
                this.read.singleNode(currentNode, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    throw new EntityNotFoundException("Node " + currentNode + " was unexpectedly deleted");
                }
                this.selectionCursor = this.retriever.selectionCursor(this.relCursor, this.nodeCursor, this.types);
                while (this.selectionCursor.next()) {
                    long foundNode;
                    if (!this.relFilter.test(this.selectionCursor) || !this.addNodeToNextLevelIfQualifies(currentNode, foundNode = this.selectionCursor.otherNodeReference()) || !this.other.currentLevel.contains(foundNode)) continue;
                    this.foundIntersectionNode = foundNode;
                    return;
                }
            }
        }

        private void advanceLevel() {
            HeapTrackingLongHashSet tmp = this.currentLevel;
            this.currentLevel = this.nextLevel;
            this.currentLevelItr = this.currentLevel.longIterator();
            this.nextLevel = tmp;
            this.nextLevel.clear();
            ++this.currentDepth;
        }

        @Override
        public void resetWithStartNode(long startNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
            this.foundIntersectionNode = -1L;
            super.resetWithStartNode(startNodeId, nodeFilter, relFilter);
        }
    }

    private static abstract class BFS<STEPS>
    implements AutoCloseable {
        protected static final int PATHS_TO_NODE_INIT_SIZE = 4;
        protected static final int LEVEL_INIT_CAPACITY = 16;
        protected static final int PATH_TRACE_DATA_INIT_CAPACITY = 64;
        long startNodeId;
        protected int currentDepth;
        protected final int[] types;
        protected final Read read;
        protected NodeCursor nodeCursor;
        protected RelationshipTraversalCursor relCursor;
        RelationshipTraversalCursor selectionCursor;
        protected final MemoryTracker memoryTracker;
        protected LongPredicate nodeFilter;
        protected Predicate<RelationshipTraversalCursor> relFilter;
        protected HeapTrackingLongHashSet currentLevel;
        protected LongIterator currentLevelItr;
        protected HeapTrackingLongHashSet nextLevel;
        protected BFS other;
        protected LongIterator intersectionIterator = null;
        protected HeapTrackingLongObjectHashMap<STEPS> pathTraceData;
        protected SemanticDirection direction;
        protected RelationshipTraversalCursorRetriever retriever;
        boolean closed = false;
        final boolean needOnlyOnePath;

        public BFS(long startNodeId, int[] types, SemanticDirection direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter, boolean needOnlyOnePath) {
            this.needOnlyOnePath = needOnlyOnePath;
            this.startNodeId = startNodeId;
            this.types = types;
            this.read = read;
            this.nodeCursor = nodeCursor;
            this.relCursor = relCursor;
            this.currentLevel = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker, (int)16);
            this.memoryTracker = memoryTracker;
            this.nodeFilter = nodeFilter;
            this.relFilter = relFilter;
            this.currentLevel.add(startNodeId);
            this.currentLevelItr = this.currentLevel.longIterator();
            this.nextLevel = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker, (int)16);
            this.currentDepth = 0;
            this.pathTraceData = HeapTrackingCollections.newLongObjectMap((MemoryTracker)memoryTracker, (int)64);
            this.retriever = direction.equals(SemanticDirection.BOTH$.MODULE$) ? RelationshipSelections::allCursor : (direction.equals(SemanticDirection.OUTGOING$.MODULE$) ? RelationshipSelections::outgoingCursor : RelationshipSelections::incomingCursor);
        }

        public abstract State searchForIntersectionInNextLevel();

        public abstract LongIterator intersectionIterator();

        protected abstract boolean addNodeToNextLevelIfQualifies(long var1, long var3);

        public boolean hasSeenNode(long nodeId) {
            return this.pathTraceData.containsKey(nodeId);
        }

        public void resetWithStartNode(long startNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
            this.startNodeId = startNodeId;
            this.nodeFilter = nodeFilter;
            this.relFilter = relFilter;
            this.currentLevel.clear();
            this.nextLevel.clear();
            this.pathTraceData.clear();
            this.currentLevel.add(startNodeId);
            this.currentLevelItr = this.currentLevel.longIterator();
            this.currentDepth = 0;
        }

        public void resetWithStartNode(long startNodeId, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
            this.nodeCursor = nodeCursor;
            this.relCursor = relCursor;
            this.resetWithStartNode(startNodeId, nodeFilter, relFilter);
        }

        public void setOther(BFS other) {
            this.other = other;
        }

        @Override
        public void close() {
            assert (!this.closed);
            this.pathTraceData.close();
            this.currentLevel.close();
            this.nextLevel.close();
            if (this.selectionCursor != this.relCursor && this.selectionCursor != null) {
                this.selectionCursor.close();
                this.selectionCursor = null;
            }
            this.closed = true;
        }

        public void setTracer(KernelReadTracer tracer) {
            if (this.nodeCursor != null) {
                this.nodeCursor.setTracer(tracer);
            }
            if (this.relCursor != null) {
                this.relCursor.setTracer(tracer);
            }
            if (this.selectionCursor != null) {
                this.selectionCursor.setTracer(tracer);
            }
        }

        @FunctionalInterface
        private static interface RelationshipTraversalCursorRetriever {
            public RelationshipTraversalCursor selectionCursor(RelationshipTraversalCursor var1, NodeCursor var2, int[] var3);
        }
    }

    private static class LazyBFS
    extends ManyPathsBFS {
        private long foundIntersectionNode = -1L;
        private long currentNode = -1L;

        public LazyBFS(long startNodeId, int[] types, SemanticDirection direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter, boolean withFallback) {
            super(startNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, withFallback);
        }

        @Override
        public void resetWithStartNode(long startNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
            this.foundIntersectionNode = -1L;
            this.currentNode = -1L;
            super.resetWithStartNode(startNodeId, nodeFilter, relFilter);
        }

        private void populateNextLevelOrStopWhenFoundFirstIntersectionNode() {
            while (this.currentLevelItr.hasNext()) {
                this.currentNode = this.currentLevelItr.next();
                this.read.singleNode(this.currentNode, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    throw new EntityNotFoundException("Node " + this.currentNode + " was unexpectedly deleted");
                }
                this.selectionCursor = this.retriever.selectionCursor(this.relCursor, this.nodeCursor, this.types);
                while (this.selectionCursor.next()) {
                    long foundNode;
                    if (!this.relFilter.test(this.selectionCursor) || !this.addNodeToNextLevelIfQualifies(this.currentNode, foundNode = this.selectionCursor.otherNodeReference()) || !this.other.currentLevel.contains(foundNode)) continue;
                    this.foundIntersectionNode = foundNode;
                    return;
                }
            }
        }

        private void advanceLevel() {
            HeapTrackingLongHashSet tmp = this.currentLevel;
            this.currentLevel = this.nextLevel;
            this.currentLevelItr = this.currentLevel.longIterator();
            this.nextLevel = tmp;
            this.nextLevel.clear();
            ++this.currentDepth;
        }

        @Override
        public State searchForIntersectionInNextLevel() {
            if (this.currentLevel.isEmpty()) {
                return State.THERE_IS_NO_INTERSECTION;
            }
            this.populateNextLevelOrStopWhenFoundFirstIntersectionNode();
            if (this.foundIntersectionNode != -1L) {
                ++this.currentDepth;
                return State.FOUND_INTERSECTION;
            }
            this.advanceLevel();
            return State.CAN_SEARCH_FOR_INTERSECTION;
        }

        private State findNextIntersectionNode() {
            while (true) {
                if (this.selectionCursor.next()) {
                    long foundNode;
                    if (!this.relFilter.test(this.selectionCursor) || !this.addNodeToNextLevelIfQualifies(this.currentNode, foundNode = this.selectionCursor.otherNodeReference()) || !this.other.currentLevel.contains(foundNode)) continue;
                    this.foundIntersectionNode = foundNode;
                    return State.FOUND_INTERSECTION;
                }
                if (!this.currentLevelItr.hasNext()) {
                    return State.EXHAUSTED_INTERSECTION;
                }
                this.currentNode = this.currentLevelItr.next();
                this.read.singleNode(this.currentNode, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    throw new EntityNotFoundException("Node " + this.currentNode + " was unexpectedly deleted");
                }
                this.selectionCursor = this.retriever.selectionCursor(this.relCursor, this.nodeCursor, this.types);
            }
        }

        @Override
        public LongIterator intersectionIterator() {
            return new LongIterator(){
                boolean consumedFirst = false;

                public long next() {
                    return foundIntersectionNode;
                }

                public boolean hasNext() {
                    if (!this.consumedFirst) {
                        this.consumedFirst = true;
                        return true;
                    }
                    pathTraceData.remove(foundIntersectionNode);
                    return this.findNextIntersectionNode() != State.EXHAUSTED_INTERSECTION;
                }
            };
        }
    }

    private static class EagerBFS
    extends ManyPathsBFS {
        public EagerBFS(long startNodeId, int[] types, SemanticDirection direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter, boolean withFallback) {
            super(startNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, withFallback);
        }

        private void fullyPopulateNextLevel() {
            while (this.currentLevelItr.hasNext()) {
                long currentNode = this.currentLevelItr.next();
                this.read.singleNode(currentNode, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    throw new EntityNotFoundException("Node " + currentNode + " was unexpectedly deleted");
                }
                this.selectionCursor = this.retriever.selectionCursor(this.relCursor, this.nodeCursor, this.types);
                while (this.selectionCursor.next()) {
                    if (!this.relFilter.test(this.selectionCursor)) continue;
                    long foundNode = this.selectionCursor.otherNodeReference();
                    this.addNodeToNextLevelIfQualifies(currentNode, foundNode);
                }
            }
        }

        private void advanceLevel() {
            HeapTrackingLongHashSet tmp = this.currentLevel;
            this.currentLevel = this.nextLevel;
            this.nextLevel = tmp;
            this.nextLevel.clear();
            ++this.currentDepth;
        }

        @Override
        public State searchForIntersectionInNextLevel() {
            if (this.currentLevel.isEmpty()) {
                return State.THERE_IS_NO_INTERSECTION;
            }
            this.fullyPopulateNextLevel();
            this.advanceLevel();
            this.currentLevelItr = this.currentLevel.longIterator();
            MutableLongSet intersection = this.currentLevel.intersect((LongSet)this.other.currentLevel);
            if (intersection.notEmpty()) {
                this.intersectionIterator = intersection.toImmutable().longIterator();
                return State.FOUND_INTERSECTION;
            }
            return State.CAN_SEARCH_FOR_INTERSECTION;
        }

        @Override
        public LongIterator intersectionIterator() {
            assert (this.intersectionIterator != null);
            return this.intersectionIterator;
        }
    }

    private static enum State {
        NOT_INITIALIZED_WITH_NODES,
        CAN_SEARCH_FOR_INTERSECTION,
        FOUND_INTERSECTION,
        EXHAUSTED_INTERSECTION,
        THERE_IS_NO_INTERSECTION,
        REACHED_MAX_DEPTH;

    }

    public static final class PathTraceStep {
        public final long relId;
        public final long prevNodeId;

        public PathTraceStep(long relId, long prevNodeId) {
            this.relId = relId;
            this.prevNodeId = prevNodeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathTraceStep that = (PathTraceStep)o;
            return this.relId == that.relId && this.prevNodeId == that.prevNodeId;
        }

        public int hashCode() {
            return Objects.hash(this.relId, this.prevNodeId);
        }

        public String toString() {
            return "PathTraceStep[relId=" + this.relId + ", prevNodeId=" + this.prevNodeId + "]";
        }
    }

    private static abstract class ManyPathsBFS
    extends BFS<HeapTrackingArrayList<PathTraceStep>> {
        protected HeapTrackingArrayList<HeapTrackingArrayList<PathTraceStep>> availableArrayLists;
        protected int availableArrayListsCurrentIndex = 0;
        protected int availableArrayListsEnd = 0;

        public ManyPathsBFS(long startNodeId, int[] types, SemanticDirection direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter, boolean needOnlyOnePath) {
            super(startNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, needOnlyOnePath);
            this.availableArrayLists = HeapTrackingCollections.newArrayList((int)64, (MemoryTracker)memoryTracker);
        }

        @Override
        protected boolean addNodeToNextLevelIfQualifies(long currentNode, long foundNode) {
            if (!this.hasSeenNode(foundNode) && this.nodeFilter.test(foundNode)) {
                HeapTrackingArrayList pathsToHere;
                this.nextLevel.add(foundNode);
                if (this.availableArrayListsCurrentIndex < this.availableArrayListsEnd) {
                    pathsToHere = (HeapTrackingArrayList)this.availableArrayLists.get(this.availableArrayListsCurrentIndex++);
                    pathsToHere.clear();
                } else {
                    pathsToHere = HeapTrackingCollections.newArrayList((int)4, (MemoryTracker)this.memoryTracker);
                    this.availableArrayLists.add((Object)pathsToHere);
                }
                pathsToHere.add((Object)new PathTraceStep(this.selectionCursor.reference(), currentNode));
                this.pathTraceData.put(foundNode, (Object)pathsToHere);
                return true;
            }
            if (!this.needOnlyOnePath && this.nextLevel.contains(foundNode)) {
                ((HeapTrackingArrayList)this.pathTraceData.get(foundNode)).add((Object)new PathTraceStep(this.selectionCursor.reference(), currentNode));
                return true;
            }
            return false;
        }

        @Override
        public void resetWithStartNode(long startNodeId, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
            super.resetWithStartNode(startNodeId, nodeCursor, relCursor, nodeFilter, relFilter);
            this.availableArrayListsCurrentIndex = 0;
            this.availableArrayListsEnd = this.availableArrayLists.size();
        }

        @Override
        public void resetWithStartNode(long startNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
            super.resetWithStartNode(startNodeId, nodeFilter, relFilter);
            this.availableArrayListsCurrentIndex = 0;
            this.availableArrayListsEnd = this.availableArrayLists.size();
        }

        @Override
        public void close() {
            this.availableArrayLists.forEach(HeapTrackingArrayList::close);
            this.availableArrayLists.close();
            super.close();
        }
    }
}

