/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.collection;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.cypher.internal.collection.DefaultComparatorTopTable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class DefaultComparatorTopTableTest {
    @Inject
    private RandomSupport random;
    private static final List<Long> TEST_VALUES = List.of(7L, 4L, 5L, 0L, 3L, 4L, 8L, 6L, 1L, 9L, 2L);
    private static final long[] EXPECTED_VALUES = new long[]{0L, 1L, 2L, 3L, 4L, 4L, 5L, 6L, 7L, 8L, 9L};
    private static final Comparator<MeasurableLong> comparator = Comparator.comparingLong(MeasurableLong::getValue);
    private static final long MEASURABLE_LONG_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MeasurableLong.class);

    DefaultComparatorTopTableTest() {
    }

    @Test
    void shouldHandleAddingMoreValuesThanCapacity() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 7L);
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong((long)l)));
        table.sort();
        Iterator iterator = table.iterator();
        for (int i = 0; i < 7; ++i) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            long value = ((MeasurableLong)iterator.next()).getValue();
            Assertions.assertEquals((long)EXPECTED_VALUES[i], (long)value);
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldHandleWhenNotCompletelyFilledToCapacity() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 20L);
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong((long)l)));
        table.sort();
        Iterator iterator = table.iterator();
        for (int i = 0; i < TEST_VALUES.size(); ++i) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            long value = ((MeasurableLong)iterator.next()).getValue();
            Assertions.assertEquals((long)EXPECTED_VALUES[i], (long)value);
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldHandleWhenEmpty() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 10L);
        table.sort();
        Iterator iterator = table.iterator();
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldThrowOnInitializeToZeroCapacity() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultComparatorTopTable(comparator, 0L));
    }

    @Test
    void shouldThrowOnInitializeToNegativeCapacity() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultComparatorTopTable(comparator, -1L));
    }

    @Test
    void shouldThrowOnSortNotCalledBeforeIterator() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 5L);
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong((long)l)));
        Assertions.assertThrows(IllegalStateException.class, () -> ((DefaultComparatorTopTable)table).iterator());
    }

    @Test
    void boundCheck() {
        DefaultComparatorTopTable topTable = new DefaultComparatorTopTable(comparator, 5L);
        topTable.sort();
        Assertions.assertThrows(NoSuchElementException.class, () -> topTable.iterator().next());
    }

    @Test
    void randomizedTest() {
        int i;
        int limit = this.random.nextInt(1000, 5000);
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(Long::compareTo, (long)limit);
        PriorityQueue<Long> priorityQueue = new PriorityQueue<Long>(((Comparator)Long::compareTo).reversed());
        for (int i2 = 0; i2 < limit * 4; ++i2) {
            long l = this.random.nextInt(limit / 10);
            table.add((Object)l);
            DefaultComparatorTopTableTest.add(priorityQueue, l, limit);
        }
        Assertions.assertEquals((int)limit, (int)priorityQueue.size());
        table.sort();
        Iterator iterator = table.iterator();
        long[] longs = new long[limit];
        for (i = limit - 1; i >= 0; --i) {
            longs[i] = priorityQueue.poll();
        }
        for (i = 0; i < limit; ++i) {
            Assertions.assertEquals((long)longs[i], (Long)((Long)iterator.next()));
        }
    }

    @Test
    void shouldHandleAddingValuesAfterReset() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 20L);
        long totalCountAfterReset = 7L;
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong(l * 100L)));
        table.sort();
        table.reset(totalCountAfterReset);
        Assertions.assertEquals((int)table.getSize(), (int)0);
        TEST_VALUES.forEach(l -> table.add((Object)new MeasurableLong((long)l)));
        table.sort();
        Iterator iterator = table.iterator();
        int i = 0;
        while ((long)i < totalCountAfterReset) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            long value = ((MeasurableLong)iterator.next()).getValue();
            Assertions.assertEquals((long)EXPECTED_VALUES[i], (long)value);
            ++i;
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private static void add(PriorityQueue<Long> priorityQueue, long e, int limit) {
        if (priorityQueue.size() < limit) {
            priorityQueue.offer(e);
        } else {
            long head = priorityQueue.peek();
            if (head > e) {
                priorityQueue.poll();
                priorityQueue.offer(e);
            }
        }
    }

    private static class MeasurableLong
    implements Measurable {
        private final long value;

        private MeasurableLong(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public long estimatedHeapUsage() {
            return MEASURABLE_LONG_SHALLOW_SIZE;
        }
    }
}

