/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.profiling;

import java.io.Serializable;
import org.mockito.Answers;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.internal.profiling.OperatorProfileEvent;
import org.neo4j.cypher.internal.profiling.ProfilingTracer;
import org.neo4j.cypher.internal.profiling.ProfilingTracerTest$NoKernelStatisticProvider$;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.cypher.internal.util.attribution.Id$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.cypher.result.OperatorProfile;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.kernel.api.query.QueryTransactionStatisticsAggregator;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001\u0002\f\u0018\u0001\tBQa\u000b\u0001\u0005\u000212Aa\f\u0001\u0001a!)1F\u0001C\u0001\u007f!9!I\u0001a\u0001\n\u0003\u0019\u0005b\u0002&\u0003\u0001\u0004%\ta\u0013\u0005\u0007#\n\u0001\u000b\u0015\u0002#\t\u000bI\u0013A\u0011A*\t\u000fY\u0003!\u0019!C\u0005/\"1a\f\u0001Q\u0001\naCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004j\u0001\u0001\u0006I!\u0019\u0004\u0005U\u0002\u00011\u000e\u0003\u0005y\u0019\t\u0005\t\u0015!\u0003z\u0011\u0019YC\u0002\"\u0001\u0002\u0004!9\u0011\u0011\u0002\u0007\u0005B\u0005-\u0001bBA\u0007\u0019\u0011\u0005\u00131B\u0004\b\u0003\u001f\u0001\u0001\u0012AA\t\r\u001d\t\u0019\u0002\u0001E\u0001\u0003+Aaa\u000b\n\u0005\u0002\u0005]\u0001bBA\u0005%\u0011\u0005\u00131\u0002\u0005\b\u0003\u001b\u0011B\u0011IA\u0006\u0005M\u0001&o\u001c4jY&tw\r\u0016:bG\u0016\u0014H+Z:u\u0015\tA\u0012$A\u0005qe>4\u0017\u000e\\5oO*\u0011!dG\u0001\tS:$XM\u001d8bY*\u0011A$H\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005yy\u0012!\u00028f_RR'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\tA\u0013$\u0001\u0003vi&d\u0017B\u0001\u0016&\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\f\u0003\u000b\rcwnY6\u0014\u0007\t\t\u0014\b\u0005\u00023o5\t1G\u0003\u00025k\u0005!A.\u00198h\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\r=\u0013'.Z2u!\tQTH\u0004\u0002/w%\u0011AhF\u0001\u0010!J|g-\u001b7j]\u001e$&/Y2fe&\u0011qF\u0010\u0006\u0003y]!\u0012\u0001\u0011\t\u0003\u0003\ni\u0011\u0001A\u0001\t]\u0006tw\u000eV5nKV\tA\t\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0003M_:<\u0017\u0001\u00048b]>$\u0016.\\3`I\u0015\fHC\u0001'P!\t)U*\u0003\u0002O\r\n!QK\\5u\u0011\u001d\u0001V!!AA\u0002\u0011\u000b1\u0001\u001f\u00132\u0003%q\u0017M\\8US6,\u0007%\u0001\u0005qe><'/Z:t)\taE\u000bC\u0003V\u000f\u0001\u0007A)A\u0003oC:|7/\u0001\u0002jIV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\O\u0005Y\u0011\r\u001e;sS\n,H/[8o\u0013\ti&L\u0001\u0002JI\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u000fM<\u0018\r\u001d9feV\t\u0011\r\u0005\u0002cO6\t1M\u0003\u0002eK\u0006I\u0001/Y4fG\u0006\u001c\u0007.\u001a\u0006\u0003Mv\t!![8\n\u0005!\u001c'a\u0003)bO\u0016\u001cv/\u00199qKJ\f\u0001b]<baB,'\u000f\t\u0002\"\t\u0016dWmZ1uS:<7*\u001a:oK2\u001cF/\u0019;jgRL7\r\u0015:pm&$WM]\n\u0004\u0019Eb\u0007CA7w\u001b\u0005q'BA8q\u0003%\u0019H/\u0019;jgRL7M\u0003\u0002re\u0006)\u0011/^3ss*\u00111\u000f^\u0001\u0005S6\u0004HN\u0003\u0002v;\u000511.\u001a:oK2L!a\u001e8\u0003#M#\u0018\r^5ti&\u001c\u0007K]8wS\u0012,'/\u0001\u0004ue\u0006\u001cWM\u001d\t\u0003u~l\u0011a\u001f\u0006\u0003yv\faaY;sg>\u0014(B\u0001@d\u0003\u001d!(/Y2j]\u001eL1!!\u0001|\u0005]!UMZ1vYR\u0004\u0016mZ3DkJ\u001cxN\u001d+sC\u000e,'\u000f\u0006\u0003\u0002\u0006\u0005\u001d\u0001CA!\r\u0011\u0015Ah\u00021\u0001z\u0003A9W\r\u001e)bO\u0016\u001c\u0015m\u00195f\u0011&$8\u000fF\u0001E\u0003I9W\r\u001e)bO\u0016\u001c\u0015m\u00195f\u001b&\u001c8/Z:\u000239{7*\u001a:oK2\u001cF/\u0019;jgRL7\r\u0015:pm&$WM\u001d\t\u0003\u0003J\u0011\u0011DT8LKJtW\r\\*uCRL7\u000f^5d!J|g/\u001b3feN\u0019!#\r7\u0015\u0005\u0005E\u0001")
public class ProfilingTracerTest
extends CypherFunSuite {
    private volatile ProfilingTracerTest$NoKernelStatisticProvider$ NoKernelStatisticProvider$module;
    private final int id = Id$.MODULE$.INVALID_ID();
    private final PageSwapper swapper = (PageSwapper)this.mock((Answer)Answers.RETURNS_MOCKS, ClassTag$.MODULE$.apply(PageSwapper.class));

    public ProfilingTracerTest$NoKernelStatisticProvider$ NoKernelStatisticProvider() {
        if (this.NoKernelStatisticProvider$module == null) {
            this.NoKernelStatisticProvider$lzycompute$1();
        }
        return this.NoKernelStatisticProvider$module;
    }

    private int id() {
        return this.id;
    }

    private PageSwapper swapper() {
        return this.swapper;
    }

    private final void NoKernelStatisticProvider$lzycompute$1() {
        ProfilingTracerTest profilingTracerTest = this;
        synchronized (profilingTracerTest) {
            if (this.NoKernelStatisticProvider$module == null) {
                this.NoKernelStatisticProvider$module = new ProfilingTracerTest$NoKernelStatisticProvider$(this);
            }
        }
    }

    public ProfilingTracerTest() {
        this.test("shouldReportExecutionTimeOfQueryExecution", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Clock clock = new Clock();
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((ProfilingTracer.Clock)clock, (StatisticProvider)this.NoKernelStatisticProvider());
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            clock.progress(516L);
            event.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.timeOf(new Id(operatorId))), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)516)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("multiple uses of the same Id should aggregate spent time", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Clock clock = new Clock();
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((ProfilingTracer.Clock)clock, (StatisticProvider)this.NoKernelStatisticProvider());
            OperatorProfileEvent event1 = tracer.executeOperator(new Id(operatorId));
            clock.progress(12L);
            event1.close();
            OperatorProfileEvent event2 = tracer.executeOperator(new Id(operatorId));
            clock.progress(45L);
            event2.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.timeOf(new Id(operatorId))), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)57)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("multiple uses of the same Id with NO_DATA should produce NO_DATA", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Clock clock = new Clock();
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((ProfilingTracer.Clock)clock, (StatisticProvider)this.NoKernelStatisticProvider());
            OperatorProfileEvent event1 = tracer.executeOperator(new Id(operatorId), false);
            clock.progress(12L);
            event1.dbHits((long)((int)-1L));
            event1.rows((long)((int)-1L));
            event1.close();
            OperatorProfileEvent event2 = tracer.executeOperator(new Id(operatorId), false);
            clock.progress(45L);
            event2.dbHits((long)((int)-1L));
            event2.rows((long)((int)-1L));
            event2.close();
            OperatorProfile profile = tracer.operatorProfile(operatorId);
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.time()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.dbHits()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.rows()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.pageCacheHits()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)profile.pageCacheMisses()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToLong((long)-1L)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("shouldReportDbHitsOfQueryExecution", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((StatisticProvider)this.NoKernelStatisticProvider());
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 516).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> event.dbHit());
            event.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.dbHitsOf(new Id(operatorId))), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)516)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("shouldReportRowsOfQueryExecution", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int operatorId = this.id();
            ProfilingTracer tracer = new ProfilingTracer((StatisticProvider)this.NoKernelStatisticProvider());
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 516).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> event.row());
            event.close();
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)tracer.rowsOf(new Id(operatorId))), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)516)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("report page cache hits as part of profiling statistics", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int operatorId = this.id();
            DefaultPageCursorTracer cursorTracer = new DefaultPageCursorTracer((PageCacheTracer)new DefaultPageCacheTracer(), "test");
            ProfilingTracer tracer = new ProfilingTracer((StatisticProvider)new DelegatingKernelStatisticProvider(this, cursorTracer));
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
                PinEvent pin = cursorTracer.beginPin(false, 1L, this.swapper());
                pin.hit();
                pin.close();
                cursorTracer.unpin(1L, this.swapper());
            });
            event.close();
            OperatorProfile information = tracer.operatorProfile(operatorId);
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)information.pageCacheHits()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)100)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("report page cache misses as part of profiling statistics", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int operatorId = this.id();
            DefaultPageCursorTracer cursorTracer = new DefaultPageCursorTracer((PageCacheTracer)new DefaultPageCacheTracer(), "test");
            ProfilingTracer tracer = new ProfilingTracer((StatisticProvider)new DelegatingKernelStatisticProvider(this, cursorTracer));
            OperatorProfileEvent event = tracer.executeOperator(new Id(operatorId));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 17).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                PinEvent pin = cursorTracer.beginPin(false, 1L, this.swapper());
                PinPageFaultEvent pageFault = pin.beginPageFault(1L, this.swapper());
                pageFault.close();
                pin.close();
                cursorTracer.unpin(1L, this.swapper());
            });
            event.close();
            OperatorProfile information = tracer.operatorProfile(operatorId);
            return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)information.pageCacheMisses()), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182), Prettifier$.MODULE$.default()).should(this.equal(BoxesRunTime.boxToInteger((int)17)), (Object)Equality$.MODULE$.default());
        }, new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
    }

    public class Clock
    implements ProfilingTracer.Clock {
        private long nanoTime;

        public long nanoTime() {
            return this.nanoTime;
        }

        public void nanoTime_$eq(long x$1) {
            this.nanoTime = x$1;
        }

        public void progress(long nanos) {
            long $org_scalatest_assert_macro_left = nanos;
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"time must move forwards", Prettifier$.MODULE$.default(), new Position("ProfilingTracerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            this.nanoTime_$eq(this.nanoTime() + nanos);
        }

        public /* synthetic */ ProfilingTracerTest org$neo4j$cypher$internal$profiling$ProfilingTracerTest$Clock$$$outer() {
            return ProfilingTracerTest.this;
        }

        public Clock() {
            if (ProfilingTracerTest.this == null) {
                throw null;
            }
            this.nanoTime = 0L;
        }
    }

    public class DelegatingKernelStatisticProvider
    implements StatisticProvider {
        private final DefaultPageCursorTracer tracer;
        public final /* synthetic */ ProfilingTracerTest $outer;

        public long getPageCacheHitsExcludingCommits() {
            return super.getPageCacheHitsExcludingCommits();
        }

        public long getPageCacheMissesExcludingCommits() {
            return super.getPageCacheMissesExcludingCommits();
        }

        public void registerCommitPhaseStatisticsListener(QueryTransactionStatisticsAggregator.CommitPhaseStatisticsListener x$1) {
            super.registerCommitPhaseStatisticsListener(x$1);
        }

        public long getPageCacheHits() {
            return this.tracer.hits();
        }

        public long getPageCacheMisses() {
            return this.tracer.faults();
        }

        public /* synthetic */ ProfilingTracerTest org$neo4j$cypher$internal$profiling$ProfilingTracerTest$DelegatingKernelStatisticProvider$$$outer() {
            return this.$outer;
        }

        public DelegatingKernelStatisticProvider(ProfilingTracerTest $outer, DefaultPageCursorTracer tracer) {
            this.tracer = tracer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

