/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import org.neo4j.cypher.internal.logical.plans.IndexOrder;
import org.neo4j.cypher.internal.logical.plans.IndexOrderAscending$;
import org.neo4j.cypher.internal.logical.plans.IndexOrderDescending$;
import org.neo4j.cypher.internal.logical.plans.IndexOrderNone$;
import org.neo4j.cypher.internal.runtime.CompositeValueIndexCursor$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.helpers.StubNodeValueIndexCursor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.enablers.Size$;
import org.scalatest.enablers.Sortable$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\r4AAB\u0004\u0001%!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0005A!)Q\u0007\u0001C\u0005m!)Q\t\u0001C\u0005\r\"9q\u000bAI\u0001\n\u0013A&!H\"p[B|7/\u001b;f-\u0006dW/Z%oI\u0016D8)\u001e:t_J$Vm\u001d;\u000b\u0005!I\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0015-\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00195\taaY=qQ\u0016\u0014(B\u0001\b\u0010\u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0019\u0013\u0005!Q\u000f^5m\u0013\tQRC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u00059\u0011!C2veN|'OR8s)\t\t#\u0006\u0005\u0002#Q5\t1E\u0003\u0002%K\u0005\u0019\u0011\r]5\u000b\u0005\u0019:\u0013AB6fe:,GN\u0003\u0002\u000b\u001b%\u0011\u0011f\t\u0002\u0015\u001d>$WMV1mk\u0016Le\u000eZ3y\u0007V\u00148o\u001c:\t\u000b-\u0012\u0001\u0019\u0001\u0017\u0002\rY\fG.^3t!\ri\u0003GM\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\tQAH]3qK\u0006$X\r\u001a \u0011\u00055\u001a\u0014B\u0001\u001b/\u0005\rIe\u000e^\u0001\u0007CNd\u0015n\u001d;\u0015\u0005]\u001a\u0005c\u0001\u001dAe9\u0011\u0011H\u0010\b\u0003uuj\u0011a\u000f\u0006\u0003yE\ta\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0005}r\u0013a\u00029bG.\fw-Z\u0005\u0003\u0003\n\u0013A\u0001T5ti*\u0011qH\f\u0005\u0006\t\u000e\u0001\r!I\u0001\u0007GV\u00148o\u001c:\u0002\u001bI\fg\u000eZ8n\u0007V\u00148o\u001c:t)\t9U\n\u0005\u0003.\u0011*\u0013\u0014BA%/\u0005\u0019!V\u000f\u001d7feA\u0019QfS\u0011\n\u00051s#!B!se\u0006L\bb\u0002(\u0005!\u0003\u0005\raT\u0001\u000bS:$W\r_(sI\u0016\u0014\bC\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0015\u0001H.\u00198t\u0015\t!\u0016\"A\u0004m_\u001eL7-\u00197\n\u0005Y\u000b&AC%oI\u0016DxJ\u001d3fe\u00069\"/\u00198e_6\u001cUO]:peN$C-\u001a4bk2$H%M\u000b\u00023*\u0012qJW\u0016\u00027B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u0019\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002c;\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class CompositeValueIndexCursorTest
extends CypherFunSuite {
    private NodeValueIndexCursor cursorFor(Seq<Object> values) {
        StubNodeValueIndexCursor stub = new StubNodeValueIndexCursor();
        ((IterableOnceOps)values.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int v = tuple2._1$mcI$sp();
                int i = tuple2._2$mcI$sp();
                return stub.withNode((long)i, new Value[]{Values.intValue((int)v)});
            }
            throw new MatchError((Object)tuple2);
        });
        return stub;
    }

    /*
     * WARNING - void declaration
     */
    private List<Object> asList(NodeValueIndexCursor cursor) {
        void var2_2;
        ArrayBuffer values = ArrayBuffer$.MODULE$.empty();
        while (cursor.next()) {
            values.append((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)cursor.propertyValue(0).asObject())));
        }
        return var2_2.toList();
    }

    private Tuple2<NodeValueIndexCursor[], Object> randomCursors(IndexOrder indexOrder) {
        NodeValueIndexCursor[] randomArray = new NodeValueIndexCursor[Random$.MODULE$.nextInt(1000)];
        int totalSize = 0;
        for (int i = 0; i < randomArray.length; ++i) {
            Seq seq;
            IndexOrder indexOrder2 = indexOrder;
            if (IndexOrderNone$.MODULE$.equals(indexOrder2)) {
                seq = (Seq)package$.MODULE$.Seq().fill(Random$.MODULE$.nextInt(100), (Function0)(JFunction0.mcI.sp & Serializable)() -> Random$.MODULE$.nextInt());
            } else if (IndexOrderAscending$.MODULE$.equals(indexOrder2)) {
                seq = (Seq)((SeqOps)package$.MODULE$.Seq().fill(Random$.MODULE$.nextInt(100), (Function0)(JFunction0.mcI.sp & Serializable)() -> Random$.MODULE$.nextInt())).sorted((Ordering)Ordering.Int$.MODULE$);
            } else if (IndexOrderDescending$.MODULE$.equals(indexOrder2)) {
                seq = (Seq)((SeqOps)package$.MODULE$.Seq().fill(Random$.MODULE$.nextInt(100), (Function0)(JFunction0.mcI.sp & Serializable)() -> Random$.MODULE$.nextInt())).sorted(Ordering.Int$.MODULE$.reverse());
            } else {
                throw new MatchError((Object)indexOrder2);
            }
            Seq randomInts = seq;
            randomArray[i] = this.cursorFor((Seq<Object>)randomInts.toSeq());
            totalSize += randomInts.size();
        }
        return new Tuple2((Object)randomArray, (Object)BoxesRunTime.boxToInteger((int)totalSize));
    }

    private IndexOrder randomCursors$default$1() {
        return IndexOrderNone$.MODULE$;
    }

    public CompositeValueIndexCursorTest() {
        this.test("should create unordered cursor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.unordered((NodeValueIndexCursor[])((Object[])new NodeValueIndexCursor[]{this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 11, 12})), this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{11, 15}))}));
            List<Object> list = this.asList(cursor);
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 11, 12, 5, 11, 15}))), (Object)Equality$.MODULE$.default());
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("randomized unordered cursor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Tuple2<NodeValueIndexCursor[], Object> tuple2 = this.randomCursors(this.randomCursors$default$1());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            NodeValueIndexCursor[] cursors = (NodeValueIndexCursor[])tuple2._1();
            int totalSize = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)cursors, (Object)BoxesRunTime.boxToInteger((int)totalSize));
            NodeValueIndexCursor[] cursors2 = (NodeValueIndexCursor[])tuple22._1();
            int totalSize2 = tuple22._2$mcI$sp();
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.unordered(cursors2);
            List<Object> list = this.asList(cursor);
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65), Prettifier$.MODULE$.default()).should(this.have()).size((long)totalSize2, Size$.MODULE$.sizeOfGenTraversable());
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("should create ascending cursor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.ascending((NodeValueIndexCursor[])((Object[])new NodeValueIndexCursor[]{this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 11, 12})), this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{11, 15}))}));
            List<Object> list = this.asList(cursor);
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 10, 11, 11, 12, 15}))), (Object)Equality$.MODULE$.default());
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("randomized ascending cursor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Tuple2<NodeValueIndexCursor[], Object> tuple2 = this.randomCursors((IndexOrder)IndexOrderAscending$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            NodeValueIndexCursor[] cursors = (NodeValueIndexCursor[])tuple2._1();
            int totalSize = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)cursors, (Object)BoxesRunTime.boxToInteger((int)totalSize));
            NodeValueIndexCursor[] cursors2 = (NodeValueIndexCursor[])tuple22._1();
            int totalSize2 = tuple22._2$mcI$sp();
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.ascending(cursors2);
            List<Object> list = this.asList(cursor);
            this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94), Prettifier$.MODULE$.default()).should(this.have()).size((long)totalSize2, Size$.MODULE$.sizeOfGenTraversable());
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95), Prettifier$.MODULE$.default()).shouldBe(this.sorted(), Sortable$.MODULE$.sortableNatureOfSeq((Ordering)Ordering.Int$.MODULE$));
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("should create descending cursor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.descending((NodeValueIndexCursor[])((Object[])new NodeValueIndexCursor[]{this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{12, 11, 10})), this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.cursorFor((Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15, 11}))}));
            List<Object> list = this.asList(cursor);
            return this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15, 12, 11, 11, 10, 5}))), (Object)Equality$.MODULE$.default());
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("randomized descending cursor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Tuple2<NodeValueIndexCursor[], Object> tuple2 = this.randomCursors((IndexOrder)IndexOrderDescending$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            NodeValueIndexCursor[] cursors = (NodeValueIndexCursor[])tuple2._1();
            int totalSize = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)cursors, (Object)BoxesRunTime.boxToInteger((int)totalSize));
            NodeValueIndexCursor[] cursors2 = (NodeValueIndexCursor[])tuple22._1();
            int totalSize2 = tuple22._2$mcI$sp();
            NodeValueIndexCursor cursor = CompositeValueIndexCursor$.MODULE$.descending(cursors2);
            List<Object> list = this.asList(cursor);
            this.convertToAnyShouldWrapper(list, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124), Prettifier$.MODULE$.default()).should(this.have()).size((long)totalSize2, Size$.MODULE$.sizeOfGenTraversable());
            return this.convertToAnyShouldWrapper(list.reverse(), new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125), Prettifier$.MODULE$.default()).shouldBe(this.sorted(), Sortable$.MODULE$.sortableNatureOfSeq((Ordering)Ordering.Int$.MODULE$));
        }, new Position("CompositeValueIndexCursorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
    }
}

