/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.neo4j.cypher.internal.runtime.JavaListWrapper;
import org.neo4j.cypher.internal.runtime.RuntimeScalaValueConverter;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.matchers.TypeMatcherHelper$;
import org.scalatest.matchers.should.Matchers;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Stream;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r2A\u0001B\u0003\u0001!!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0003q\u0002B\u0002\u0012\u0001A\u0003%qD\u0001\u0010Sk:$\u0018.\\3TG\u0006d\u0017MV1mk\u0016\u001cuN\u001c<feR,'\u000fV3ti*\u0011aaB\u0001\beVtG/[7f\u0015\tA\u0011\"\u0001\u0005j]R,'O\\1m\u0015\tQ1\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u00195\tQA\\3pi)T\u0011AD\u0001\u0004_J<7\u0001A\n\u0003\u0001E\u0001\"AE\f\u000e\u0003MQ!\u0001F\u000b\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005Y9\u0011\u0001B;uS2L!\u0001G\n\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!B\u0001\nG>tg/\u001a:uKJ,\u0012a\b\t\u00039\u0001J!!I\u0003\u00035I+h\u000e^5nKN\u001b\u0017\r\\1WC2,XmQ8om\u0016\u0014H/\u001a:\u0002\u0015\r|gN^3si\u0016\u0014\b\u0005")
public class RuntimeScalaValueConverterTest
extends CypherFunSuite {
    private final RuntimeScalaValueConverter converter = new RuntimeScalaValueConverter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RuntimeScalaValueConverterTest.$anonfun$converter$1(x$1)));

    public RuntimeScalaValueConverter converter() {
        return this.converter;
    }

    public static final /* synthetic */ boolean $anonfun$converter$1(Object x$1) {
        return false;
    }

    public RuntimeScalaValueConverterTest() {
        this.test("should convert hash map", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            HashMap<String, Integer> it = new HashMap<String, Integer>();
            it.put("k1", BoxesRunTime.boxToInteger((int)5));
            it.put("k2", BoxesRunTime.boxToInteger((int)15));
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39), Prettifier$.MODULE$.default()).should(this.equal(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)BoxesRunTime.boxToInteger((int)15))}))), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("should convert singleton map", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Map<String, Integer> it = Collections.singletonMap("key", BoxesRunTime.boxToInteger((int)12));
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45), Prettifier$.MODULE$.default()).should(this.equal(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)BoxesRunTime.boxToInteger((int)12))}))), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("should convert empty map", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Map it = Collections.emptyMap();
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51), Prettifier$.MODULE$.default()).should(this.equal(Predef$.MODULE$.Map().empty()), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("should convert nested map", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            HashMap<String, Object> it = new HashMap<String, Object>();
            it.put("k1", Collections.singletonMap("a", BoxesRunTime.boxToInteger((int)2)));
            it.put("k2", BoxesRunTime.boxToInteger((int)15));
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59), Prettifier$.MODULE$.default()).should(this.equal(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k1"), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k2"), (Object)BoxesRunTime.boxToInteger((int)15))}))), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("should convert linked list", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LinkedList<Integer> it = new LinkedList<Integer>();
            it.add(BoxesRunTime.boxToInteger((int)12));
            it.add(BoxesRunTime.boxToInteger((int)14));
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{12, 14}))), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("should convert array list", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArrayList<Integer> it = new ArrayList<Integer>();
            it.add(BoxesRunTime.boxToInteger((int)12));
            it.add(BoxesRunTime.boxToInteger((int)14));
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{12, 14}))), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("should convert singleton set", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Set<Integer> it = Collections.singleton(BoxesRunTime.boxToInteger((int)3));
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3}))), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("should convert empty list", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            java.util.List it = Collections.emptyList();
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87), Prettifier$.MODULE$.default()).should(this.equal(package$.MODULE$.List().empty()), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("should convert nested data structures", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Set<java.util.List<Object>> it = Collections.singleton(Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{3, 4})));
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93), Prettifier$.MODULE$.default()).should(this.equal(new .colon.colon((Object)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}))), (List)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("should convert from set", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            HashSet<String> it = new HashSet<String>();
            it.add("Hello");
            return this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue(it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default()).should(this.equal(new .colon.colon((Object)"Hello", (List)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("should convert traversable to Iterable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Stream it = (Stream)package$.MODULE$.Stream().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)3)}));
            Matchers.AnyShouldWrapper $org_scalatest_type_matcher_macro_left = this.convertToAnyShouldWrapper(this.converter().asDeepScalaValue((Object)it), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106), Prettifier$.MODULE$.default());
            return TypeMatcherHelper$.MODULE$.assertAnType($org_scalatest_type_matcher_macro_left.leftSideValue(), this.an(ClassTag$.MODULE$.apply(Iterable.class)), $org_scalatest_type_matcher_macro_left.prettifier(), $org_scalatest_type_matcher_macro_left.pos());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("should preserve java lists without copying", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            java.util.List<Object> javaList = Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 2, 3}));
            Object converted = this.converter().asDeepScalaValue(javaList);
            Matchers.AnyShouldWrapper $org_scalatest_type_matcher_macro_left = this.convertToAnyShouldWrapper(converted, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114), Prettifier$.MODULE$.default());
            TypeMatcherHelper$.MODULE$.assertAType($org_scalatest_type_matcher_macro_left.leftSideValue(), this.a(ClassTag$.MODULE$.apply(JavaListWrapper.class)), $org_scalatest_type_matcher_macro_left.prettifier(), $org_scalatest_type_matcher_macro_left.pos());
            Matchers.AnyShouldWrapper $org_scalatest_type_matcher_macro_left2 = this.convertToAnyShouldWrapper(((JavaListWrapper)converted).inner(), new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115), Prettifier$.MODULE$.default());
            return TypeMatcherHelper$.MODULE$.assertAnType($org_scalatest_type_matcher_macro_left2.leftSideValue(), this.an(ClassTag$.MODULE$.apply(ArrayList.class)), $org_scalatest_type_matcher_macro_left2.prettifier(), $org_scalatest_type_matcher_macro_left2.pos());
        }, new Position("RuntimeScalaValueConverterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }
}

