/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.debug;

import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.scalatest.BeforeAndAfterEach;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y3\u0001\u0002D\u0007\u0011\u0002\u0007\u0005!D\u0016\u0005\u0006O\u0001!\t\u0001\u000b\u0005\bY\u0001\u0011\rQ\"\u0001.\u0011\u001d\t\u0004A1A\u0005\u00025BqA\r\u0001C\u0002\u0013\u0005Q\u0006C\u00044\u0001\u0001\u0007I\u0011\u0002\u001b\t\u000f\t\u0003\u0001\u0019!C\u0005\u0007\")a\t\u0001C)Q!)q\t\u0001C\u0005\u0011\")\u0011\u000b\u0001C)Q!Y!\u000b\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002\u0015T\u0011-!\u0006\u0001%A\u0002\u0002\u0003%I\u0001K+\u0003'M\u000bg/Z$f]\u0016\u0014\u0018\r^3e'>,(oY3\u000b\u00059y\u0011!\u00023fEV<'B\u0001\t\u0012\u0003\u001d\u0011XO\u001c;j[\u0016T!AE\n\u0002\u0011%tG/\u001a:oC2T!\u0001F\u000b\u0002\r\rL\b\u000f[3s\u0015\t1r#A\u0003oK>$$NC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011:\u0012!C:dC2\fG/Z:u\u0013\t13E\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0017A\u0002\u0013j]&$H\u0005F\u0001*!\ta\"&\u0003\u0002,;\t!QK\\5u\u0003i\u0019\u0018M^3HK:,'/\u0019;fIN{WO]2f\u000b:\f'\r\\3e+\u0005q\u0003C\u0001\u000f0\u0013\t\u0001TDA\u0004C_>dW-\u00198\u0002A-,W\r]*pkJ\u001cWMR5mKN\fe\r^3s)\u0016\u001cHOR5oSNDWm]\u0001\u0010Y><7+\u0019<f\u0019>\u001c\u0017\r^5p]\u0006\u0001r-\u001a8fe\u0006$X\rZ*pkJ\u001cWm]\u000b\u0002kA\u0019AD\u000e\u001d\n\u0005]j\"AB(qi&|g\u000e\u0005\u0002:\u00016\t!H\u0003\u0002<y\u0005!a-\u001b7f\u0015\tid(A\u0002oS>T\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002Bu\t!\u0001+\u0019;i\u0003Q9WM\\3sCR,GmU8ve\u000e,7o\u0018\u0013fcR\u0011\u0011\u0006\u0012\u0005\b\u000b\u001a\t\t\u00111\u00016\u0003\rAH%M\u0001\u000bE\u00164wN]3FC\u000eD\u0017aC:fi2{7-\u0019;j_:$\"!S(\u0011\u0005)kU\"A&\u000b\u00051s\u0014\u0001\u00027b]\u001eL!AT&\u0003\rM#(/\u001b8h\u0011\u0015\u0001\u0006\u00021\u00019\u0003!awnY1uS>t\u0017!C1gi\u0016\u0014X)Y2i\u0003A\u0019X\u000f]3sI\t,gm\u001c:f\u000b\u0006\u001c\u0007.\u0003\u0002GK\u0005y1/\u001e9fe\u0012\ng\r^3s\u000b\u0006\u001c\u0007.\u0003\u0002RKI\u0019q+W.\u0007\ta\u0003\u0001A\u0016\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u00035\u0002i\u0011!\u0004\t\u0003EqK!!X\u0012\u0003\u000bM+\u0018\u000e^3")
public interface SaveGeneratedSource
extends BeforeAndAfterEach {
    public void org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$_setter_$keepSourceFilesAfterTestFinishes_$eq(boolean var1);

    public void org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$_setter_$logSaveLocation_$eq(boolean var1);

    public /* synthetic */ void org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$super$beforeEach();

    public /* synthetic */ void org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$super$afterEach();

    public boolean saveGeneratedSourceEnabled();

    public boolean keepSourceFilesAfterTestFinishes();

    public boolean logSaveLocation();

    public Option<Path> org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$generatedSources();

    public void org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$generatedSources_$eq(Option<Path> var1);

    public static /* synthetic */ void beforeEach$(SaveGeneratedSource $this) {
        $this.beforeEach();
    }

    default public void beforeEach() {
        this.org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$super$beforeEach();
        if (this.saveGeneratedSourceEnabled()) {
            Path cwd = Paths.get(".", new String[0]).normalize().toRealPath(new LinkOption[0]);
            if (Files.isDirectory(cwd.resolve("src/test/scala").resolve(this.getClass().getName().replace('.', '/')).getParent(), new LinkOption[0]) && Files.isDirectory(cwd.resolve("target"), new LinkOption[0])) {
                this.setLocation(cwd.resolve("target").resolve("generated-test-sources").resolve("cypher"));
                return;
            }
            throw new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Could not resolve directory for saving generated source code relative to current working directory '" + cwd + "'.\n             |Make sure the working directory in your debug configuration is set to the directory of the Maven module containing the test.")));
        }
    }

    private String setLocation(Path location) {
        if (this.logSaveLocation()) {
            System.err.println("Will save generated sources to " + location);
        }
        this.org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$generatedSources_$eq((Option<Path>)new Some((Object)location));
        return System.setProperty("org.neo4j.cypher.DEBUG.generated_source_location", ((Object)location).toString());
    }

    public static /* synthetic */ void afterEach$(SaveGeneratedSource $this) {
        $this.afterEach();
    }

    default public void afterEach() {
        if (this.saveGeneratedSourceEnabled()) {
            System.clearProperty("org.neo4j.cypher.DEBUG.generated_source_location");
            if (!this.keepSourceFilesAfterTestFinishes()) {
                this.org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$generatedSources().foreach((Function1 & Serializable)location -> Files.walkFileTree(location, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(null){

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }
                }));
            }
        }
        this.org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$super$afterEach();
    }

    public static void $init$(SaveGeneratedSource $this) {
        $this.org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$_setter_$keepSourceFilesAfterTestFinishes_$eq(false);
        $this.org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$_setter_$logSaveLocation_$eq(true);
        $this.org$neo4j$cypher$internal$runtime$debug$SaveGeneratedSource$$generatedSources_$eq((Option<Path>)None$.MODULE$);
    }
}

