/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.graphtemplate.parsing;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.runtime.graphtemplate.Directedness;
import org.neo4j.cypher.internal.runtime.graphtemplate.Directedness$Directed$;
import org.neo4j.cypher.internal.runtime.graphtemplate.Directedness$Undirected$;
import org.neo4j.cypher.internal.runtime.graphtemplate.GraphTemplate;
import org.neo4j.cypher.internal.runtime.graphtemplate.TemplateId;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.InclusiveRect;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.InlineParsedNodeFinder$;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Lines;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Lines$;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.MultiLineParsedRelFinder;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.ParsedRel;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.Vec2d;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GraphTemplateParser$ {
    public static final GraphTemplateParser$ MODULE$ = new GraphTemplateParser$();

    public GraphTemplate parse(String str, int maxGap) {
        GraphTemplate template = new GraphTemplate();
        Lines lines = Lines$.MODULE$.fromStr(str);
        HashSet usedPoints = new HashSet();
        ArrayBuffer nodeAreas = ArrayBuffer$.MODULE$.empty();
        InlineParsedNodeFinder$.MODULE$.extract(lines).foreach((Function1 & Serializable)parsedNode -> {
            TemplateId id = template.addNode(parsedNode.name(), parsedNode.labels()).getId();
            usedPoints.$plus$plus$eq(parsedNode.pos().points());
            return (ArrayBuffer)nodeAreas.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)parsedNode.pos()), (Object)id));
        });
        Map nodesByPoint = ((IterableOnceOps)nodeAreas.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InclusiveRect rect = (InclusiveRect)tuple2._1();
                TemplateId id = (TemplateId)tuple2._2();
                return rect.points().map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)id));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        new MultiLineParsedRelFinder((Set<Vec2d>)nodesByPoint.keySet()).extract(lines).foreach((Function1 & Serializable)parsedRel -> {
            GraphTemplateParser$.$anonfun$parse$4(lines, maxGap, nodesByPoint, usedPoints, template, parsedRel);
            return BoxedUnit.UNIT;
        });
        Seq unused = lines.iterChars().collect((PartialFunction)new Serializable(usedPoints){
            private static final long serialVersionUID = 0L;
            private final HashSet usedPoints$1;

            public final <A1 extends Tuple2<Object, Vec2d>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    char c = A1._1$mcC$sp();
                    Vec2d p = (Vec2d)A1._2();
                    if (c != ' ' && !this.usedPoints$1.contains((Object)p)) {
                        return (B1)BoxesRunTime.boxToCharacter((char)c);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Vec2d> x1) {
                Tuple2<Object, Vec2d> tuple2 = x1;
                if (tuple2 != null) {
                    char c = tuple2._1$mcC$sp();
                    Vec2d p = (Vec2d)tuple2._2();
                    if (c != ' ' && !this.usedPoints$1.contains((Object)p)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.usedPoints$1 = usedPoints$1;
            }
        }).toSeq();
        if (unused.nonEmpty()) {
            throw new IllegalArgumentException("Could not parse graph template diagram; unparsed characters " + unused.mkString("[", ",", "]") + "; input template string:\n" + str);
        }
        return template;
    }

    public int parse$default$2() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$parse$5(ParsedRel parsedRel$1, Lines lines$1, int maxGap$1, Map nodesByPoint$1, HashSet usedPoints$1, GraphTemplate template$1, TemplateId start) {
        parsedRel$1.endProjection().find(lines$1, maxGap$1, nodesByPoint$1).foreach((Function1 & Serializable)end -> {
            usedPoints$1.$plus$plus$eq(parsedRel$1.points());
            SemanticDirection semanticDirection = parsedRel$1.direction();
            if (SemanticDirection.OUTGOING$.MODULE$.equals(semanticDirection)) {
                return template$1.addRel(start, (TemplateId)end, parsedRel$1.name(), parsedRel$1.relType(), (Directedness)Directedness$Directed$.MODULE$);
            }
            if (SemanticDirection.INCOMING$.MODULE$.equals(semanticDirection)) {
                return template$1.addRel((TemplateId)end, start, parsedRel$1.name(), parsedRel$1.relType(), (Directedness)Directedness$Directed$.MODULE$);
            }
            if (SemanticDirection.BOTH$.MODULE$.equals(semanticDirection)) {
                return template$1.addRel((TemplateId)end, start, parsedRel$1.name(), parsedRel$1.relType(), (Directedness)Directedness$Undirected$.MODULE$);
            }
            throw new MatchError((Object)semanticDirection);
        });
    }

    public static final /* synthetic */ void $anonfun$parse$4(Lines lines$1, int maxGap$1, Map nodesByPoint$1, HashSet usedPoints$1, GraphTemplate template$1, ParsedRel parsedRel) {
        parsedRel.startProjection().find(lines$1, maxGap$1, nodesByPoint$1).foreach((Function1 & Serializable)start -> {
            GraphTemplateParser$.$anonfun$parse$5(parsedRel, lines$1, maxGap$1, nodesByPoint$1, usedPoints$1, template$1, start);
            return BoxedUnit.UNIT;
        });
    }

    private GraphTemplateParser$() {
    }
}

