/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.graphtemplate.parsing;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.graphtemplate.GraphTemplate;
import org.neo4j.cypher.internal.runtime.graphtemplate.TemplateId;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.GraphTemplateParser$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.enablers.Messaging$;
import org.scalatest.matchers.should.Matchers;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}1AAA\u0002\u0001%!)1\u0004\u0001C\u00019\t9rI]1qQR+W\u000e\u001d7bi\u0016\u0004\u0016M]:feR+7\u000f\u001e\u0006\u0003\t\u0015\tq\u0001]1sg&twM\u0003\u0002\u0007\u000f\u0005iqM]1qQR,W\u000e\u001d7bi\u0016T!\u0001C\u0005\u0002\u000fI,h\u000e^5nK*\u0011!bC\u0001\tS:$XM\u001d8bY*\u0011A\"D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00059y\u0011!\u00028f_RR'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u001a\u001b\u0005)\"B\u0001\f\u0018\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\tA\u0012\"\u0001\u0003vi&d\u0017B\u0001\u000e\u0016\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0002")
public class GraphTemplateParserTest
extends CypherFunSuite {
    public static final /* synthetic */ void $anonfun$new$24(GraphTemplateParserTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            String template = (String)tuple2._2();
            $this.test("illegal template " + name, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> $this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).shouldBe($this.thrownBy((Function0 & Serializable)() -> GraphTemplateParser$.MODULE$.parse(template, GraphTemplateParser$.MODULE$.parse$default$2())), Prettifier$.MODULE$.default(), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483)), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public GraphTemplateParserTest() {
        this.test("parse single node", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse("()", GraphTemplateParser$.MODULE$.parse$default$2());
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode());
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("parse single named node", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse("(n)", GraphTemplateParser$.MODULE$.parse$default$2());
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode("n"));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("parse single labelled node", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse("(:Label)", GraphTemplateParser$.MODULE$.parse$default$2());
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode((Seq<String>)new .colon.colon((Object)"Label", (List)Nil$.MODULE$)));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("parse single named and labelled node", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse("(n:Label)", GraphTemplateParser$.MODULE$.parse$default$2());
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode("n", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Label"})));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("parse two nodes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse("(a) (b)", GraphTemplateParser$.MODULE$.parse$default$2());
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode("a").addNode("b"));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("parse two nodes on different lines", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("(a)\n        |(b)")), GraphTemplateParser$.MODULE$.parse$default$2());
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode("a").addNode("b"));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.test("parse inline relationship", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            void var2_2;
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse("(a)->(b)", GraphTemplateParser$.MODULE$.parse$default$2());
            Matchers.AnyShouldWrapper anyShouldWrapper = this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296), Prettifier$.MODULE$.default());
            GraphTemplate builder = new GraphTemplate();
            TemplateId a = builder.addNode("a").getId();
            TemplateId b = builder.addNode("b").getId();
            builder.addRel(a, b);
            return anyShouldWrapper.shouldBe((Object)var2_2);
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        this.test("parse vertical relationship", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            void var2_2;
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |(a)\n        | |\n        | v\n        |(b)")), GraphTemplateParser$.MODULE$.parse$default$2());
            Matchers.AnyShouldWrapper anyShouldWrapper = this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315), Prettifier$.MODULE$.default());
            GraphTemplate builder = new GraphTemplate();
            TemplateId a = builder.addNode("a").getId();
            TemplateId b = builder.addNode("b").getId();
            builder.addRel(a, b);
            return anyShouldWrapper.shouldBe((Object)var2_2);
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        this.test("complex diagram 1", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |  .--[r:REL]-->(b)\n        |(a:A)<----------'\n        |")), GraphTemplateParser$.MODULE$.parse$default$2());
            GraphTemplate builder = new GraphTemplate();
            TemplateId b = builder.addNode("b").getId();
            TemplateId a = builder.addNode("a", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})).getId();
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332), Prettifier$.MODULE$.default()).shouldBe((Object)builder.addRel(a, b, "r", "REL").addRel(b, a));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("complex diagram 2", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("    .-----------------.\n        |    |                 v\n        | (n0:S)->(n1)->(n2)->(n3:T)\n        |    |\n        |    '-->(n4)-->(n5:T)\n        |")), GraphTemplateParser$.MODULE$.parse$default$2());
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode("n0", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"S"})).addNode("n1").addNode("n2").addNode("n3", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).addNode("n4").addNode("n5", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"T"})).addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n0"), (Object)"n3")).addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n0"), (Object)"n1")).addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n1"), (Object)"n2")).addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n2"), (Object)"n3")).addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n0"), (Object)"n4")).addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n4"), (Object)"n5")));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        this.test("one whitespace character between relationship arrow and node is permitted", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | (a) <-.\n        |\n        |  '-> (b)\n        |")), GraphTemplateParser$.MODULE$.parse$default$2());
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode("a").addNode("b").addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"a")).addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"b")));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        this.test("two whitespace characters between relationship arrow and node are rejected", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String template = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | (a)  <-.\n        |\n        |\n        |  '->  (b)\n        |"));
            return this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).shouldBe(this.thrownBy((Function0 & Serializable)() -> GraphTemplateParser$.MODULE$.parse(template, GraphTemplateParser$.MODULE$.parse$default$2())), Prettifier$.MODULE$.default(), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        this.test("two whitespace characters between relationship arrow and node are permitted if setting overridden", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GraphTemplate template = GraphTemplateParser$.MODULE$.parse(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | (a)  <-.\n        |\n        |\n        |  '->  (b)\n        |")), 2);
            return this.convertToAnyShouldWrapper(template, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode("a").addNode("b").addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"a")).addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"b")));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        this.test("unused characters are rejected", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String template = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | ()-->()\n        |\n        | !#\n        |\n        |"));
            return this.convertToAnyShouldWrapper(this.the(ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420)).thrownBy((Function0 & Serializable)() -> GraphTemplateParser$.MODULE$.parse(template, GraphTemplateParser$.MODULE$.parse$default$2())), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420), Prettifier$.MODULE$.default()).should(this.have()).message("Could not parse graph template diagram; unparsed characters [!,#]; input template string:\n" + template, Messaging$.MODULE$.messagingNatureOfThrowable());
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("reused node name is rejected", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String template = "(n) (n)";
            return this.convertToAnyShouldWrapper(this.the(ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427)).thrownBy((Function0 & Serializable)() -> GraphTemplateParser$.MODULE$.parse(template, GraphTemplateParser$.MODULE$.parse$default$2())), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427), Prettifier$.MODULE$.default()).should(this.have()).message("Node with name n already exists in template", Messaging$.MODULE$.messagingNatureOfThrowable());
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        this.test("reused relationship name is rejected", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String template = "()-[r]->()-[r]->()";
            return this.convertToAnyShouldWrapper(this.the(ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434)).thrownBy((Function0 & Serializable)() -> GraphTemplateParser$.MODULE$.parse(template, GraphTemplateParser$.MODULE$.parse$default$2())), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434), Prettifier$.MODULE$.default()).should(this.have()).message("Relationship with name r already exists in template", Messaging$.MODULE$.messagingNatureOfThrowable());
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
        this.test("relationship line gap can traverse empty part of string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String template = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("       (a)\n        |\n        |        |\n        |        v\n        |       (b)\n        |"));
            return this.convertToAnyShouldWrapper(GraphTemplateParser$.MODULE$.parse(template, GraphTemplateParser$.MODULE$.parse$default$2()), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448), Prettifier$.MODULE$.default()).shouldBe((Object)new GraphTemplate().addNode("a").addNode("b").addRel((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"b")));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("relationship cannot have two name sections", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String template = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |()--[:A]--[:B]->()"));
            return this.an(ClassTag$.MODULE$.apply(IllegalArgumentException.class)).shouldBe(this.thrownBy((Function0 & Serializable)() -> GraphTemplateParser$.MODULE$.parse(template, GraphTemplateParser$.MODULE$.parse$default$2())), Prettifier$.MODULE$.default(), new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
        }, new Position("GraphTemplateParser.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"double-ended relationship"), (Object)"()<->()"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"undirected relationship"), (Object)"()--()"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationship arrow going wrong way"), (Object)"()-<()"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"direction arrow not connected correctly"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(" () -v\n        |     ()\n        |"))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unconnected relationship"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(" ()\n        |   ->()\n        |"))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"double-ended vertical relationship"), (Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("| ()\n         |  ^\n         |  |\n         |  v\n         | ()"))), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)x0$1 -> {
            GraphTemplateParserTest.$anonfun$new$24(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }
}

