/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.graphtemplate.parsing;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.InclusiveRect;
import org.neo4j.cypher.internal.runtime.graphtemplate.parsing.InlineParsedNodeFinder$;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005u2Aa\u0001\u0003\u0001'!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C\tQ\u0012J\u001c7j]\u0016\u0004\u0016M]:fI:{G-\u001a$j]\u0012,'\u000fV3ti*\u0011QAB\u0001\ba\u0006\u00148/\u001b8h\u0015\t9\u0001\"A\u0007he\u0006\u0004\b\u000e^3na2\fG/\u001a\u0006\u0003\u0013)\tqA];oi&lWM\u0003\u0002\f\u0019\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u000e\u001d\u000511-\u001f9iKJT!a\u0004\t\u0002\u000b9,w\u000e\u000e6\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\r\u000b\u0003\u0011)H/\u001b7\n\u0005m1\"AD\"za\",'OR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003\u0011\t\u0011\u0002]8tSRLwN\\:\u0015\u0005\t\u001a\u0004cA\u0012.a9\u0011AE\u000b\b\u0003K!j\u0011A\n\u0006\u0003OI\ta\u0001\u0010:p_Rt\u0014\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-b\u0013a\u00029bG.\fw-\u001a\u0006\u0002S%\u0011af\f\u0002\u0004'\u0016\f(BA\u0016-!\ty\u0012'\u0003\u00023\t\ti\u0011J\\2mkNLg/\u001a*fGRDQ\u0001\u000e\u0002A\u0002U\n1a\u001d;s!\t1$H\u0004\u00028qA\u0011Q\u0005L\u0005\u0003s1\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011\b\f")
public class InlineParsedNodeFinderTest
extends CypherFunSuite {
    private Seq<InclusiveRect> positions(String str) {
        return InlineParsedNodeFinder$.MODULE$.extract(str).map((Function1 & Serializable)x$4 -> x$4.pos()).toSeq();
    }

    public InlineParsedNodeFinderTest() {
        this.test("Find node in single line", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<InclusiveRect> res = this.positions("()");
            return this.convertToAnyShouldWrapper(res, new Position("InlineParsedNodeFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51), Prettifier$.MODULE$.default()).shouldBe((Object)new .colon.colon((Object)new InclusiveRect(0, 0, 0, 1), (List)Nil$.MODULE$));
        }, new Position("InlineParsedNodeFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("Find named and labelled node in single line", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<InclusiveRect> res = this.positions("(n:L)");
            return this.convertToAnyShouldWrapper(res, new Position("InlineParsedNodeFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57), Prettifier$.MODULE$.default()).shouldBe((Object)new .colon.colon((Object)new InclusiveRect(0, 0, 0, 4), (List)Nil$.MODULE$));
        }, new Position("InlineParsedNodeFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("Find two nodes in single line", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<InclusiveRect> res = this.positions("() ()");
            return this.convertToAnyShouldWrapper(res, new Position("InlineParsedNodeFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63), Prettifier$.MODULE$.default()).shouldBe((Object)new .colon.colon((Object)new InclusiveRect(0, 0, 0, 1), (List)new .colon.colon((Object)new InclusiveRect(0, 0, 3, 4), (List)Nil$.MODULE$)));
        }, new Position("InlineParsedNodeFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("Find nodes on multiple lines", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq<InclusiveRect> res = this.positions(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("()\n        |  ()\n        | ()")));
            return this.convertToAnyShouldWrapper(res, new Position("InlineParsedNodeFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73), Prettifier$.MODULE$.default()).shouldBe((Object)new .colon.colon((Object)new InclusiveRect(0, 0, 0, 1), (List)new .colon.colon((Object)new InclusiveRect(1, 1, 2, 3), (List)new .colon.colon((Object)new InclusiveRect(2, 2, 1, 2), (List)Nil$.MODULE$))));
        }, new Position("InlineParsedNodeFinder.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
    }
}

